<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'masleave-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>
    <div class="tab-content">
        <div class="tab-pane active">
                   <ul class="clearfix form-ul material">
                        <li class="col-sm-4">
                            <?php echo $form->dropdownlist($model, 'branch_id',MasCompanyBranchSponsor::getCompanyBranches(),array('data-label'=>'Branch','empty'=>'Select','onchange'=>'getbranchemployee(this.value)')); ?>
                        </li>
                        <li class="col-sm-4">
                            <?php echo $form->dropdownlist($model, 'parent_id',MasLeave::getParentLeave(),array('data-label'=>'Parent Leave','empty'=>'Select','onchange'=>'hideparentonlyfields(this.value);')); ?>
                        </li>
    			<li class="col-sm-4">
                                 <?php echo $form->hiddenField($model, 'id');?>
                               <?php echo $form->textField($model, 'leave_name',array('data-label'=>'Leave Name')); ?>
                        </li>
                        <li class="col-sm-4">
                                <?php echo $form->textField($model, 'leave_abbreviation',array('data-label'=>'Leave Abbreviation')); ?>
                        </li>
                        <li class="col-sm-4">
                            <?php echo $form->dropdownlist($model, 'leave_type',array('1'=>'Monthly Incremented','2'=>'Yearly','3'=>'None'),array('data-label'=>'Leave Type')); ?>
                        </li>
                        <li class="col-sm-4">
                            <?php echo $form->textField($model, 'leave_days',array('data-label'=>'Leave Days','onkeypress' => 'return isNumberKey(event)')); ?>
                        </li>  
                        <li class="col-sm-4">
                            <?php echo $form->textField($model, 'leave_days_above_5',array('data-label'=>'Leave Days(Above 5 Yr)','onkeypress' => 'return isNumberKey(event)')); ?>
                        </li>  
                        <li class="col-sm-4">
                            <?php echo $form->textField($model, 'leave_days_above_10',array('data-label'=>'Leave Days(Above 10 Yr)','onkeypress' => 'return isNumberKey(event)')); ?>
                        </li>  
                        <li class="col-sm-4">
                            <?php echo $form->textField($model, 'apply_before',array('data-label'=>'Apply Before','onkeypress' => 'return isNumberKey(event)')); ?>
                        </li>  
                        <li class="col-sm-4 parent_only" id="emp_id_li">
                            <?php 
                            if($model->id) {
                                $stype = $model->employee_id;
                                $stype = explode(",", $stype);
                                foreach ($stype as $eachValue)                                    
                                  $selectedOptions[$eachValue] = array('selected'=>'selected');

                            }else{
                                $model_employee = Employee::model()->findAll(array('condition' => 'isActive="Y"'));
                                foreach ($model_employee as $eachValue){
                                    $selectedOptions[$eachValue->id] = array('selected' => 'selected');
                                }
                            }
                            echo $form->dropdownlist($model, 'employee_id',Employee::getEmployee($model->branch_id),array('data-label'=>'Employee *','multiple'=>true,'options' => $selectedOptions)); ?>
                        </li>
                        <li class="col-sm-4 parent_only">
                            <?php echo $form->dropdownlist($model, 'encashable',array('Y'=>'Yes','N'=>'No'),array('data-label'=>'Encashable')); ?>
                        </li>
                        <li class="col-sm-4">
                            <?php echo $form->dropdownlist($model, 'salary_deduction',array('H'=>'Half','Y'=>'Full','N'=>'No'),array('data-label'=>'Salary Deduction')); ?>
                        </li>
                        <li class="col-sm-4 parent_only">
                            <?php echo $form->dropdownlist($model, 'show_in_payslip',array('Y'=>'Yes','N'=>'No'),array('data-label'=>'Show In Payslip')); ?>
                        </li>
                        <li class="col-sm-4 parent_only">
                            <?php echo $form->textField($model, 'additional_leave',array('data-label'=>'Additional Leave','onkeypress' => 'return isNumberKey(event)')); ?>
                        </li> 
                        <li class="col-sm-4">
                            <?php echo $form->dropdownlist($model, 'leave_count_employee_panel',array('Y'=>'Yes','N'=>'No'),array('data-label'=>'Display in Employee Panel')); ?>
                        </li> 
                        <li class="col-sm-4 parent_only">
                            <?php echo $form->dropdownlist($model, 'carry_forward',array('Y'=>'Yes','N'=>'No'),array('data-label'=>'Carry Forward','onchange'=>'displayfield(this.value);')); ?>
                        </li>
                        <?php
                        $forward_display=$forward_display_1=$negative_leave_display=$leave_apply_display='display:none;';
                        if($model->carry_forward=='Y'){
                            $forward_display='display:block;';
                        }
                        if($model->carry_forward_limit=='Y'){
                            $forward_display_1='display:block;';
                        }
                        if($model->negative_leave_apply_permission!='N'){
                            $negative_leave_display='display:block;';
                        }
                        ?>
                        <li class="col-sm-4" style="<?php echo $forward_display; ?>" id="li_carry_forward_limit">
                            <?php echo $form->dropdownlist($model, 'carry_forward_limit',array('Y'=>'Yes','N'=>'No'),array('data-label'=>'Have Carry Forward Limit','onchange'=>'displayfield_1(this.value);')); ?>
                        </li>
                        <li class="col-sm-4" style="<?php echo $forward_display_1; ?>" id="li_carry_forward_leave">
                            <?php echo $form->textField($model, 'carry_forward_leave',array('data-label'=>'Carry Forward Leave','onkeypress' => 'return isNumberKey(event)')); ?>
                        </li> 
                        <li class="col-sm-4 parent_only">
                            <?php
                            if($model->ticket_available=="Y"){
                                $model->ticket_available=1;
                            }else{
                                $model->ticket_available=0;
                            }
                            
                            echo $form->checkBox($model, 'ticket_available',array('class' => '','title' => 'Ticket Available','data-label'=>'Ticket Available')); ?>
                        </li>
                        <li class="col-sm-4">                
                            <?php echo $form->dropDownList($model, 'negative_leave_apply_permission', array('A' => 'From Admin','B' => 'From Both','N' => 'No'), array('data-label' => 'Apply Leave(Count<=0)','onchange'=>'displayfield_2(this.value);')); ?>
                        </li>
                        <li class="col-sm-4" style="<?php echo $negative_leave_display; ?>" id="li_negative_leave">                
                            <?php echo $form->dropDownList($model, 'salary_deduction_negative_leave', array('N' => 'No','Y' => 'Full','H' =>'Half'), array('data-label' => 'Salary Deduction(Negative Leave)')); ?>
                        </li>
                        <li class="col-sm-4">
                            <?php
                            if($model->document_medical_certificate_upload=="Y"){
                                $model->document_medical_certificate_upload=1;
                            }else{
                                $model->document_medical_certificate_upload=0;
                            }
                            
                            echo $form->checkBox($model, 'document_medical_certificate_upload',array('class' => '','title' => 'Document/Medical Certificate Upload','data-label'=>'Document/Medical Certificate Upload')); ?>
                        </li>  
                        <li class="col-sm-4">
                            <?php
                            if($model->leave_apply_limit=='Y'){
                                $leave_apply_display='display:block;';
                            }
                            echo $form->dropdownlist($model, 'leave_apply_limit',array('Y'=>'Yes','N'=>'No'),array('data-label'=>'Have Leave Apply Limit','onchange'=>'displayfield_3(this.value);')); ?>
                        </li>
                        <li class="col-sm-4" style="<?php echo $leave_apply_display; ?>" id="li_leave_apply_limit">
                            <?php echo $form->textField($model, 'max_leave_apply',array('data-label'=>'Max Apply Leave','onkeypress' => 'return isNumberKey(event)')); ?>
                        </li> 
    		</ul>
        </div>
    </div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="masleave_close" data-dismiss="modal">Close</button>
    	<?php
        $url = Yii::app()->createUrl('/masleave/SaveDetail');       
        echo CHtml::ajaxsubmitButton('Save',$url, array(
                'dataType' => 'json',
                'type' => 'post',
                'success' => 'function(data) {
                        if(data.status=="success"){  
                             t8.success("Details Saved Successfully!");
                             $("#masleave_close").click();
                            reloadTable("#tbl_masleave_details");
                        } else { 
                            $.each(data, function(key, val) {
                                t8.error(""+val+""); 
                            }); 
                        } 
                }',
               'beforeSend' => 'function(){
                    $("#loader").show();
                    $(".toast8-error").hide(); 
                    $("#masleave-form .masleave-save-btn").prop("disabled", true);
                    $("#masleave-form .masleave-save-btn").addClass("btn_loading").removeClass("btn-theme");
                }' ,
                'complete' => 'function(){
                    $("#loader").hide(); 
                    $("#masleave-form .masleave-save-btn").prop("disabled", false);
                    $("#masleave-form .masleave-save-btn").addClass("btn-theme").removeClass("btn_loading");
                }' 
        ), array('id' => 'mybtn' . rand(), 'class' => 'masleave-save-btn btn btn-theme'));

    ?>


    </div>
<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript('addemployee', '
  $(document).ready(function() {
    var parent_id=$("#MasLeave_parent_id").val();
    if (Number(parent_id)>0)  {
        $(".parent_only").hide();
    }
    $("#MasLeave_employee_id").multiselect({
      enableFiltering: true,
      includeSelectAllOption:true,
      enableCaseInsensitiveFiltering: true,
    });
  });', CClientScript::POS_HEAD);
$cs->registerScript("displayfield", "function displayfield(carryforward) {
    if (carryforward=='Y')  {
        $('#li_carry_forward_limit').show();
    }else {
        $('#li_carry_forward_limit').hide();
        $('#li_carry_forward_leave').hide();
    } 
};", CClientScript::POS_HEAD);
$cs->registerScript("displayfield_1", "function displayfield_1(carryforward) {
    if (carryforward=='Y')  {
        $('#li_carry_forward_leave').show();
    }else {
        $('#li_carry_forward_leave').hide();
    } 
};", CClientScript::POS_HEAD);
$cs->registerScript("displayfield_2", "function displayfield_2(negativeleave) {
    if (negativeleave!='N')  {
        $('#li_negative_leave').show();
    }else {
        $('#li_negative_leave').hide();
    } 
};", CClientScript::POS_HEAD);
$cs->registerScript("displayfield_3", "function displayfield_3(leavelimit) {
    if (leavelimit=='Y')  {
        $('#li_leave_apply_limit').show();
    }else {
        $('#li_leave_apply_limit').hide();
    } 
};", CClientScript::POS_HEAD);
$cs->registerScript("hideparentonlyfields", "function hideparentonlyfields(parent_id) {
    if (Number(parent_id)>0)  {
        $('.parent_only').hide();
    }else {
        $('.parent_only').show();
    } 
};", CClientScript::POS_HEAD);

$cs->registerScript("getbranchemployee", "function getbranchemployee(branch){  
        jQuery.ajax({
           'dataType':'json',
            'data' : {'branch':branch},
            'type':'post',
            'url': '" . Yii::app()->createUrl('masleave/getbranchemployee') . "',
            'success': function(data) {
                $('#emp_id_li').html(data.emp);
            },
            'beforeSend':function(){
                $('#loader').show();
            },
            'complete':function(){
                $('#loader').hide();
                $('#MasLeave_employee_id').multiselect({
                    enableFiltering: true,
                    includeSelectAllOption:true,
                    enableCaseInsensitiveFiltering: true,
                });
            }
        });
   
};", CClientScript::POS_HEAD);
  ?>







