<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("disableMasLocation", "function disableMasLocation(id){
    var r = confirm('Are you sure to block this MasLocation?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=MasLocation/BlockMasLocation',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('Error while Blocking');
                }else {
                     reloadTable('#tbl_country_details');

                    t8.success('MasLocation blocked SuccessFully');
                }
               }
            });
        }


};", CClientScript::POS_HEAD);
$cs->registerScript("enableMasLocation", "function enableMasLocation(id){
    var r = confirm('Are you sure to unblock this MasLocation?');
        if(r==true)
        {
            jQuery.ajax({
                'type'  : 'post',
                'dataType'  : 'json',
                'data'  : 'id=' + id,
                'url'  : $('#liveSite').val()+'index.php?r=MasLocation/UnBlockMasLocation',
                'cache': false,
                'success':function(data){
                    if(data.status=='success'){
                        reloadTable('#tbl_country_details');
                        t8.success('MasLocation Unblocked SuccessFully!');

                    }else {
                        t8.error('This MasLocation cant be Unblocked');
                    }
                 }
            });
        }
};", CClientScript::POS_END);
 
?>
<script>
    var imageBase64Logo = null;
    $(document).ready(function () {
        var table_id = "#tbl_country_details";
        table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            //scrollY: "450px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('MasLocation/GetList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            columnDefs: [
                       {
                          "targets": [3],"visible": false,
                       },
            ],

            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                if ( aData[3] == "N" )  
                {  
                   $("td", nRow).addClass("bg-danger");

                }
            }
        });

    });
    </script>

<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
    <i class="fa fa-globe"></i>  Location    
        <div class="pull-right">
            <?php 
            if (isset(Yii::app()->user->havePermissionOn['master_location_add']) || Yii::app()->user->authorised_user == 1) { ?>

                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('MasLocation/create', 'Add New Location', 'lg')"><i class="fa fa-plus"></i> ADD</button>
            <?php   } ?>
        </div>
        
            
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_country_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>SI No</th>
                         <th>Location Name</th>
                         <?php  if (
                            Yii::app()->user->authorised_user == 1 ||
                            isset(Yii::app()->user->havePermissionOn['master_location_edit']) ||
                            isset(Yii::app()->user->havePermissionOn['master_location_disable'])
                        ) { ?>
						<th>Action</th>
						<?php } ?>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
