<?php $cs = Yii::app()->getClientScript();

$cs->registerScript("clickledger", "function clickledger(field_id)
        {
         
            $('#MasInventoryStockAdjustmentType_subledger_name').val('');
             $('#MasInventoryStockAdjustmentType_subledger_id').val('');
        }", CClientScript::POS_HEAD);


$cs->registerScript("getSublegders", "function getSublegders(field_id)
        {
          
           account_id = $('#MasInventoryStockAdjustmentType_ledger_id').val();
           $('#subledger_id').val(0);
           if( account_id > 0 ){
                var url = '" . Yii::app()->createUrl('accounts/subledgers/GetSubledgerlist') . "&ledger='+account_id;
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response, url) },
                    focus       : function( event, ui ) {},
                    select          : function( event, ui ) {
                        event.preventDefault();
                        
                       
                        $('#MasInventoryStockAdjustmentType_subledger_name').val(ui.item.label);
                        $('#MasInventoryStockAdjustmentType_subledger_id').val(ui.item.value);
                    }
                })
            }else{
                t8.error('Choose Ledger First!');
                $('#subledger_name').val('');
                return false;
            }
        }", CClientScript::POS_HEAD);


?>
<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'stocktype-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>
<div class="tab-content">
    <div class="tab-pane active">

        <ul class="clearfix form-ul material">

            <?php echo $form->hiddenField($model, 'id'); ?>

            <li class="col-sm-6">
                <?php echo $form->textField($model, 'description', array('data-label' => 'Description <span style="color:red">*</span>', 'data-validation' => 'required')); ?>
                <?php echo $form->error($model, 'description'); ?>
            </li>

            <li class="col-sm-6">
                <?php echo $form->dropDownList($model, 'type', array('I' => 'ISSUE', 'R' => 'RECEIPT'), array('data-label' => 'Type', 'data-validation' => 'required')); ?>
                <?php echo $form->error($model, 'description'); ?>

            </li>

            <li class="col-sm-6">
                <?php
                $modelAccLedger = new AccLedger();
                echo $form->dropdownlist($model, 'ledger_id', $modelAccLedger->getChilds(), array('prompt' => 'select', 'class' => 'tooltipster', 'data-label' => 'Ledgers', 'onChange' => 'js:clickledger(this.id);', 'data-search' => true)); ?>
            </li>

            <li class="col-sm-6">
                <?php if ($model->subledger_id > 0) {
                    $modelAccSubledger = new AccSubledger();
                    $modelAccSubledger = $modelAccSubledger->findBypk($model->subledger_id);
                    $model->subledger_name = $modelAccSubledger['subledger_name'];
                }
                ?>
                <?php echo $form->hiddenField($model, 'subledger_id', array()); ?>
                <?php echo $form->textField($model, 'subledger_name', array('class' => 'tooltipster', 'data-label' => 'Subledger', 'onKeyup' => 'js:getSublegders(this.id);', 'data-label' => 'Sub ledger')); ?>
            </li>

        </ul>
    </div>

</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('masInventoryStockAdjustmentType/SavestockAdjustmentType');
    echo CHtml::ajaxSubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                                    $("#loader").hide();
                                    if(data.status=="success"){  
                                         t8.success("Inventory Stock Adjustment Type  Saved Successfully!");
                                         $(".x.close").click();
                                         reloadTable("#tbl_type_details");
                                    } else { 
                                        $("#stocktype-form .stocktype-save-btn").prop("disabled", false);                      
                                        $("#stocktype-form .stocktype-save-btn").addClass("btn-theme").removeClass("btn_loding"); 
                                        $.each(data, function(key, val) {
                                                $("#stocktype-form #"+key+"_em_").text(val).show(); 
                                                t8.error(""+val+""); 
                                            }); 
                                    } 
                            }',
        'beforeSend' => 'function(){
                                $("#loader").show();
                                $("#stocktype-form .stocktype-save-btn").prop("disabled", true);                      
                                $("#stocktype-form .stocktype-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
                                $(".toast8-error").hide(); 
                            }'


    ), array('id' => 'mybtn' . rand(), 'class' => 'stocktype-save-btn btn btn-theme'));

    ?>
</div>
<?php $this->endWidget(); ?>