<?php

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

?>
<script>
    $(document).ready(function () {
    var table_id = "#tbl_type_details";
    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
    data.type_code = $("#type_code").val();
    
    
    return data;
    }).DataTable({
    scrollY: "645px",
            pageLength: 50,
            processing: true,
            order: [[1, "ASC"]],
            ajax: {
            url: "<?php echo Yii::app()->createUrl('masInventoryStockAdjustmentType/GetList') ?>",
                    type: "POST",
                    cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            AddContextMenu(nRow, aData);
            if (aData[6].status == "N")  {
            $("td", nRow).addClass("bg-danger");
            }
            }
    });
    });
    function AddContextMenu(row, datas) {
        var mas_edit=0;
        var mas_disable=0;
        <?php if (isset(Yii::app()->user->havePermissionOn['mas_stock_adjustment_type_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_edit=1;
        <?php } ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['mas_stock_adjustment_type_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_disable=1;
        <?php } ?> 
        $(row).contextMenu({
        selector: 'td',
            items: {
            "edit": {

                name: "Edit",
                        icon: "edit",
                        accesskey: "e",
                        callback: function () {
                        loadPopupModal("masInventoryStockAdjustmentType/create&id=" + datas[6].id, datas[6].description, "lg");
                        }, 
                    disabled: function(key, opt) { 
                        // this references the trigger element
                        if(mas_edit=='0'){
                            return !this.data('editDisabled'); 
                        }
                    }
                },
                "Disable_Enable":{
                        name: (datas[6].status == "Y") ?"Disable" : "Enable",
                                icon: "edit",
                                accesskey: "d",
                                callback: function () {
                                Disable(datas[6].id, datas[6].status);
                                },
                    disabled: function(key, opt) { 
                            // this references the trigger element
                            if(mas_disable=='0'){
                                return !this.data('Disable_EnableDisabled'); 
                            }
                    }
                }

            }
    });
    }
</script>

  <script>
    function Search() {
        reloadTable($("#tbl_type_details"));
    }
</script>


<script>
    function Disable(id, status){
    var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
    if (r == true)
    {
    jQuery.ajax({
    'type'  : 'post',
            'datatype' :'json',
            'data'  : 'id=' + id + "&status=" + status,
            'url'  : $('#liveSite').val() + 'index.php?r=masInventoryStockAdjustmentType/Disable',
            'cache': false,
            'success':function(data){
            if (data.status == 'fail'){
            t8.error('Error while Delete');
            } else {
            $('#tbl_type_details').DataTable().ajax.reload()
                    t8.success(' Success!');
            }
            }
    });
    }


    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-users"></i> Master Inventory Stock Adjustment Type  
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['mas_stock_adjustment_type_add']) || Yii::app()->user->authorised_user == 1) { ?>

                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('masInventoryStockAdjustmentType/create', 'Add Master Inventory Stock Adjustment Type', 'lg')"><i class="fa fa-plus"></i> ADD</button>

            <?php } ?></div>

           
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_type_details" style="font-size:13px;">
                <thead>
                    
                     <tr>
                        <td colspan="2" ></td>
                  
                          <td style="width: 100px">
                            <?php 
                          
                             $typeArray = ["onchange" => "Search()", 'style' => 'width:200px', 'empty' => '-Type-'];
                            echo CHtml::dropDownList("type_code", "",  array('I' => 'ISSUE', 'R' => 'RECEIPT'), $typeArray);
                            ?>
                        </td>
                        <td  colspan="2" ></td>
                        
                        
                    </tr>
                    
                   <tr>
                        <th>SI No</th>
                        <th>Description</th>
                         <th>Type</th>
                        <th>Ledger</th>
                        <th>Sub Ledger</th>

                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>SI No</th>
                        <th>Description</th>
                         <th>Type</th>
                        <th>Ledger</th>
                        <th>Sub Ledger</th>

                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>
<?php

$cs = Yii::app()->getClientScript();



$cs->registerScript('DeleteAllFiles', 'function DeleteAllFiles(){ 

    var r = confirm("Are you sure to Delete All Files From App PDF Folder?");
   
    if(r==true)
    {

           $("#loader").show();
        jQuery.ajax({
        //    "data" : "phase_id="+phase_id+"&project_id="+project_id,
           "dataType" : "json",
           "type"  : "post",
           "url": "' . Yii::app()->createUrl('country/DeleteAllFiles') . '",
           "success":function(data){
            if(data.status=="success"){
              
                
                t8.success("Success");
                $("#loader").hide();
            }else{
                t8.error("Failed");
                $("#loader").hide();
            }
            // $("#loader").hide();
            // $("#pinfo_close").click();        
        },           
        });
     
 }
 
};', CClientScript::POS_HEAD);

?>