<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadnotification", '
function filterDataTable() {
    var table_id = "#tbl_c_notification";

    var table = $(table_id).DataTable({
        scrollY: "645px",
        pageLength: 50,
		order: [[ 4, "asc" ]],
        processing: true,
        serverSide: true,
        fixedColumns: true,
        ajax: {
            url: "' . Yii::app()->createUrl('masErpNotification/GetList') . '",
            type: "POST",
            cache: false
        },
		
        fixedHeader: {
            headerOffset: $("header.main").outerHeight()
        },
        columnDefs: [
            {
                targets: [6,7,8], // Hide "Notification" column
                visible: false
            },
			{ targets: 2, width: "250px" },
            { targets: 3, width: "350px" }
        ],
        createdRow: function(nRow, aData) {
            $(nRow).addClass("context-menu");
        }
    });

    // Context menu setup
    $.contextMenu({
        selector: "#tbl_c_notification tbody tr.context-menu",
        callback: function(key, options) {
            var data = table.row(this).data();
            var id = data[6]; // ID
            var ref = data[1]; // Reference No

            if (key === "edit") {
                loadPopupModal("masErpNotification/create&id=" + id, "Edit Notification #" + ref, "xl");
            } else if (key === "delete") {
                if (confirm("Are you sure you want to delete this notification?")) {
                    $.post("' . Yii::app()->createUrl('masErpNotification/Deletenotification') . '", {id: id}, function(res) {
                        table.ajax.reload(null, false);
                    });
                }
            }
        },
        items: {
            "edit": {name: "Edit", icon: "edit"},
            "delete": {name: "Delete", icon: "delete"}
        }
    });
}

$(document).ready(function() {
    filterDataTable();
});
');

$cs->registerScript("deletenotification", "function deletenotification(id){
    var r = confirm('Are you sure want to delete?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType'  : 'json',
              'data'  : 'id='+id,
              'url'  : $('#liveSite').val()+'index.php?r=masErpNotification/Deletenotification',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    t8.success('Deleted');
                    reloadTable('#tbl_c_notification'); 
                }else {
                    t8.error('Error in Deletion');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
?>
<section class="panel" style="background-color:#F6F3EE;">
	<header class="panel-heading clearfix panel-theame">
		 Notification
		<div class="pull-right">
			<?php if (Yii::app()->user->authorised_user == 1) { ?>
				<button class="btn btn-sm btn-theme"
					onclick="loadPopupModal('masErpNotification/create','Add Notification','xl')"><i class="fa fa-plus"></i>
					ADD</button>
			<?php } ?>
		</div>
	</header>
	<div class="panel-body">
		<div class="custom-data-table">
			<table id="tbl_c_notification" class="table table-bordered">
				<thead>
					<tr>
						<th>No</th>
						<th>Reference No</th>
						<th>User Names</th>
						<th>Notes</th>
						<th>Date Time</th>
						<th>Status</th>
						<th>ID</th>
						<th>Created By</th>
						<th>Created Date</th>
					</tr>
				</thead>
				<tbody></tbody>
			</table>

		</div>
	</div>
</section>