<?php
//date('F', mktime(0, 0, 0, $m, 1))
$start_year = date('Y');
$end_year = date('Y');
$table_data = array();
$sql = "SELECT YEAR(erp_invoice.invoice_date) as y, MONTH(erp_invoice.invoice_date) as m , SUM(`grand_total`) AS total FROM `erp_invoice` GROUP BY YEAR(erp_invoice.invoice_date), MONTH(erp_invoice.invoice_date) ORDER BY  YEAR(erp_invoice.invoice_date), MONTH(erp_invoice.invoice_date) ";
$row_data = Yii::app()->db->createCommand($sql)->queryAll();



foreach ($row_data as $value) {
    $table_data[$value['y']][$value['m']] = $value ['total'];
    $start_year = ($start_year > $value['y']) ? $value['y'] : $start_year;
}
$josn_data = [];
for ($year_index = $start_year; $year_index <= $end_year; $year_index++) {
    for ($month_index = 1; $month_index <= 12; $month_index++) {
        if (!isset($table_data[$year_index][$month_index])) {
            $table_data[$year_index][$month_index] = 0;
        }
        $josn_data[$year_index][] = $table_data[$year_index][$month_index];
    }
}
$total = [];
?>
<script>
    // to share data to graph 
    sales_per_month_son = JSON.parse('<?= json_encode($josn_data) ?>');
</script>
<div class="custom-data-table">
    <h5>Year Wise sales</h5>
    <table class="table table-hover table-bordered" style="width: 100%" id="month-sales">
        <thead>
            <tr>
                <th>#</th>  
                <th>Month</th>
                <?php for ($index = $start_year; $index <= $end_year; $index++) {
                    ?>
                    <th class="text-right"><?= $index ?></th>
                <?php } ?>
            </tr>
        </thead>
        <tbody>
            <?php for ($index1 = 1; $index1 <= 12; $index1++) {
                ?>
                <tr>
                    <td><?= ($index1) ?></td>            
                    <td><?= date('F', mktime(0, 0, 0, $index1, 1)) ?></td>     
                    <?php for ($index = $start_year; $index <= $end_year; $index++) { ?>
                        <td class="text-right">
                            <?php
                            if (!isset($total[$index])) {
                                $total[$index] = 0;
                            }
                            $total[$index] = $total[$index] + $table_data[$index][$index1];
                            $val = number_format($table_data[$index][$index1]);
                            echo $val;
                            ?>

                        </td>
                    <?php } ?>
                </tr>        
            <?php }
            ?>
        <tfoot>
            <tr>
                <th colspan="2" class="text-right">
                    Total
                </th>
                <?php for ($index = $start_year; $index <= $end_year; $index++) {
                    ?>
                    <th class="text-right">
                        <?= number_format( $total[$index]) ?>
                    </th>
                <?php }
                ?>
            </tr>
        </tfoot>
        </tbody>
    </table>
</div>


<script>
    $(document).ready(function () {
        //document ready
        var settings = {
           // scrollY: "380px",
            paging: false,
            searching: false
        };
        $("#month-sales").DataTable(settings);
    });
</script>

