<?php
$sql = "SELECT erp_stock_ledger.product_id, sum(`erp_stock_ledger`.quantity) as quantity, erp_store.rate, sum(`erp_stock_ledger`.quantity * erp_store.rate) as amt, erp_store.part_number, erp_store.description FROM `erp_stock_ledger` JOIN erp_store on (erp_store.id = erp_stock_ledger.product_id) GROUP by erp_stock_ledger.product_id ORDER by amt desc LIMIT 10 ";
$data = Yii::app()->db->createCommand($sql)->queryAll();
$total = 0;
?>
<h5>High Value Items</h5>
<table class="table table-bordered">
    <thead>
        <tr>
            <th>#</th>
            <th>Part Number</th>
            <th>Description</th>
            <th>Stock Qty</th>
            <th>Rate</th>
            <th>Value</th>
        </tr>
    </thead>
    <tbody>
        <?php
        foreach ($data as $key => $value) {
            $id = $value["product_id"];
            $title = $value["part_number"] . " : " . $value["description"];
            $total += $value["amt"];
            ?>
            <tr ondblclick=" productDetails('<?= $id ?>', '<?= $title ?>')">
                <td><?= ($key + 1) ?></td>
                <td><?= $value["part_number"] ?></td>
                <td><?= $value["description"] ?></td>
                <td class="text-right"><?= number_format($value["quantity"]) ?></td>
                <td class="text-right"><?= number_format($value["rate"], 2) ?></td>
                <td class="text-right"><?= number_format($value["amt"]) ?></td>
            </tr>
        <?php } ?>
    <tfoot>
    <th class="text-right" colspan="5">
        Total
    </th>
    <th class="text-right">
        <?= number_format($total) ?>
    </th>
    </tfoot>
    </tbody>
</table>
<script>
    function productDetails(id, title) {
        var url = "inventory/getDetails&product_id=" + id;
        loadPopupModal(url, title, 'lg');
    }
</script>