<?php
if(isset($month) && (int) $month>0){
    $currentdate = date('Y-'.$month.'-d', time());
    $currentmonth = date('m', strtotime($currentdate));
}
else{
    $currentdate = date('Y-m-d', time());
    $currentmonth = date('m', strtotime($currentdate));
}

$expiry_start_date = date('Y-'.$currentmonth.'-01');
$expiry_end_date = date('Y-'.$currentmonth.'-31');




$sql = "SELECT product_id,product_name,product_description,SUM(quantity) as quantity,rate,expiry_date FROM `erp_stock_ledger` INNER JOIN erp_store AS store ON store.id=product_id WHERE expiry_date>='".$expiry_start_date."' AND expiry_date<='".$expiry_end_date."' GROUP By product_id,expiry_date";
//echo $sql;
$data = Yii::app()->db->createCommand($sql)->queryAll();
$total = 0;


?>
<h5>Nearly Expired and Expired Item 
<select name="month" onchange="loadExpiredProduct(this.value)">
<?php

foreach (['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'] as $monthNumber => $month) {
    $month_no=$monthNumber+1;
    if($month_no==$currentmonth){
        echo "<option value='{$month_no}' selected>{$month}</option>";
    }
    else{
        echo "<option value='{$month_no}'>{$month}</option>";
    }
}
?>
</select>

</h5>


<table class="table table-bordered">
    <thead>
        <tr>
            <th>#</th>
            <th>Part Number</th>
            <th>Description</th>
            <th>Expiry Date</th>
            <th>Stock Qty</th>
            <th>Rate</th>
            <th>Value</th>
        </tr>
    </thead>
    <tbody>
        <?php
        foreach ($data as $key => $value) {
            $id = $value["product_id"];
            $title = $value["product_name"] . " : " . $value["product_description"];
            $total += ($value["quantity"] * $value["rate"]);
            ?>
            <tr ondblclick=" productDetails('<?= $id ?>', '<?= $title ?>')" style="background-color:#f9c1ce;">
                <td><?= ($key + 1) ?></td>
                <td><?= $value["product_name"] ?></td>
                <td><?= $value["product_description"] ?></td>
                <td><?= date('d/m/Y',strtotime($value["expiry_date"])); ?></td>
                <td class="text-right"><?= number_format($value["quantity"]) ?></td>
                <td class="text-right"><?= number_format($value["rate"], 2) ?></td>
                <td class="text-right"><?= number_format(($value["quantity"] * $value["rate"]),2) ?></td>
            </tr>
        <?php } ?>
    <tfoot>
    <th class="text-right" colspan="6">
        Total
    </th>
    <th class="text-right">
        <?= number_format($total,2) ?>
    </th>
</tfoot>
</tbody>
</table>
<script>
    function productDetails(id, title) {
        var url = "inventory/getDetails&product_id=" + id;
        loadPopupModal(url, title, 'lg');
    }
</script>