<script>
    const TYPE = {
        SALES: 1,
        PURCHASE: 2,
        INVENTORY: 3,
        HR: 4,
        OTHERS: 5,
        FINANCE: 6,
        MAINTENANCE: 7
    };
</script>
<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>
<?php $cs->registerScriptFile($baseUrl . "/js/amchart/amcharts.js", CClientScript::POS_HEAD); ?>
<?php $cs->registerScriptFile($baseUrl . "/js/amchart/serial.js", CClientScript::POS_HEAD); ?>
<?php $cs->registerScriptFile($baseUrl . "/js/amchart/export.min.js", CClientScript::POS_HEAD); ?>
<?php $cs->registerCssFile($baseUrl . "/css/amchart/export.css"); ?>
<?php $cs->registerScriptFile($baseUrl . "/js/amchart/light.js", CClientScript::POS_HEAD); ?>
<?php $cs->registerScriptFile($baseUrl . "/js/amchart/funnel.js", CClientScript::POS_HEAD); ?>
<?php
$startYear = 2017;
$endYear = date('Y');
?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
    <!-- <i class="fa fa-dashboard"></i> -->
        MIS Dashboard
    </header>
    <div class="panel-body">
        <div class="panel-heading" >
            <a  onclick="loadButtonClick(TYPE.MAINTENANCE)" class="cards-title"  data-toggle="collapse in" href="#show-maintenance-result">Maintenance <span> [ ] </span></a>
        </div>
        <div class="panel-body" id="show-maintenance-result">

        </div>
        <div class="panel-heading" >
            <a  onclick="loadButtonClick(TYPE.SALES)"class="cards-title"  data-toggle="collapse in" href="#show-sales-result">Sales <span> [ Top Ten Customers / Year-wise Sales / Salesman Targets / Summary ] </span></a>
        </div>
        <div class="panel-body" id="show-sales-result">

        </div>
        <div class="panel-heading" >
            <a  onclick="loadButtonClick(TYPE.PURCHASE)" class="cards-title" data-toggle="collapse in" href="#show-purchase-result">Purchase <span>[ Top Ten Suppliers / Year wise Purchases / Summary ]</span></a>
        </div>
        <div  class="panel-body " id="show-purchase-result">

        </div>
        <div class="panel-heading" >
            <a  onclick="loadButtonClick(TYPE.INVENTORY)" class="cards-title" data-toggle="collapse in" href="#show-inventory-result">Inventory <span> [ Top Products / High Value Items / Dead Stock / Location wise Stock ]</span></a>
        </div>
        <div  class="panel-body " id="show-inventory-result">

        </div>

        <div class="panel-heading" >
            <a  onclick="loadButtonClick(TYPE.HR)" class="cards-title" data-toggle="collapse in" href="#show-hr-result">HR <span>[ Department wise / Designation wise Listing / Document Expiry ]</span></a>
        </div>
        <div  class="panel-body " id="show-hr-result">

        </div>
        <!--div class="panel-heading" >
            <a  onclick="loadButtonClick(TYPE.FINANCE)" class="cards-title" data-toggle="collapse in" href="#show-finance-result">Finance <span>[ Cash Flow / Accounts Payable / Accounts Receivable ]</span></a>
        </div>
        <div  class="panel-body " id="show-finance-result">

        </div-->
        <div class="panel-heading" >
            <a  onclick="loadButtonClick(TYPE.OTHERS)" class="cards-title" data-toggle="collapse in" href="#show-other-result">Others <span>[ Deliveries / Payments / Meetings ]</span></a>
        </div>
        <div  class="panel-body " id="show-other-result">

        </div>
    </div>
</section>
<script>

    function   loadButtonClick(val) {

        var Settingdata;
        switch (val) {
            case TYPE.SALES:
                Settingdata = {};
                Settingdata.url = "managementinfo/loadsales";
                Settingdata.div = "#show-sales-result";
                LoadResult(Settingdata);
                break;
            case TYPE.PURCHASE :
                Settingdata = {};
                Settingdata.url = "managementinfo/loadpurchase";
                Settingdata.div = "#show-purchase-result";
                LoadResult(Settingdata);
                break;
            case TYPE.INVENTORY:
                Settingdata = {};
                Settingdata.url = "managementinfo/loadinventory";
                Settingdata.div = "#show-inventory-result";
                LoadResult(Settingdata);
                break;
            case TYPE.HR:
                Settingdata = {};
                Settingdata.url = "managementinfo/loadhr";
                Settingdata.div = "#show-hr-result";
                LoadResult(Settingdata);
                break;
            case TYPE.OTHERS:
                Settingdata = {};
                Settingdata.url = "managementinfo/loadothers";
                Settingdata.div = "#show-other-result";
                LoadResult(Settingdata);
                break;
            case TYPE.FINANCE:
                Settingdata = {};
                Settingdata.url = "managementinfo/LoadFinance";
                Settingdata.div = "#show-finance-result";
                LoadResult(Settingdata);
                break;
            case TYPE.MAINTENANCE:
                Settingdata = {};
                Settingdata.url = "managementinfo/LoadMaintenance";
                Settingdata.div = "#show-maintenance-result";
                LoadResult(Settingdata);
                break;
        }

    }
    function LoadResult(Settingdata) {
        if (Settingdata == null) {
            console.log('abort');
            return;
        }

        jQuery.ajax({
            data: Settingdata.data,
            dataType: 'html',
            type: 'POST',
            url: "index.php?r=" + Settingdata.url,
            beforeSend: function (xhr) {
                $("#loader").show();
                $("#show-result").html("");
            },
            success: function (data, textStatus, jqXHR) {
                $("#loader").hide();
                $(Settingdata.div).html(data);
            },

        });

    }
</script>
<style>
    .bg-terques {
        background: #6ccac9;
    }
    .symbol {
        display: inline-block;
        text-align: center;
        width: 40%;
        padding: 25px 15px;
        -webkit-border-radius: 4px 0px 0px 4px;
        border-radius: 4px 0px 0px 4px;
        color: #fff;
        font-size: 50px;
        background: #6ccac9;
    }
    .value h1 {
        margin: 0;
        padding: 0;
        color: #8f9196;
        font-weight: 300;
    }
    .cards-title {
        background-color: #dff7f3  !important;
    }
    .cards-title span{
        color: gray;
        font-size: 12px;
        font-weight: 400;
    }
</style>
<style>
    th{
        background: linear-gradient(135deg, #2c3e50 0%, #5db5a4 100%);
        color: white;
    }
</style>