<?php
$currentYear = date('Y');
if (!isset($year)) {
    $year = date('Y');
}
$yearArray = [];
for ($index = 2018; $index <= $currentYear; $index++) {
    $yearArray[$index] = $index;
}
$sql = " SELECT erp_vendor.vendor_name, sum(erp_purchasinginvoice.grand_total) as total FROM `erp_purchasinginvoice` JOIN erp_vendor ON (erp_vendor.id = erp_purchasinginvoice.vendor_id) WHERE year(erp_purchasinginvoice.invoice_date) = '{$year}' GROUP by erp_vendor.vendor_name order by sum(erp_purchasinginvoice.grand_total) DESC LIMIT 10 ";
$data = Yii::app()->db->createCommand($sql)->queryAll();
?>

<div class="custom-data-table">
    <h5>Top Ten Vendor in <?= CHtml::dropDownList("top_ten_customer", $year, $yearArray, array('onchange' => 'js:TopTenVendor(this.value)')) ?></h5>
    <table class="table table-hover table-bordered" style="width: 100%" id="top-ten-vendor">
        <thead>
            <tr>
                <th>#</th>
                <th>Vendor</th>
                <th class="text-right">Amount(<?=$year?>)</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($data as $key => $value) {
                ?>
                <tr>
                    <td><?= ($key + 1) ?></td>            
                    <td><?= $value["vendor_name"] ?></td>
                    <td class="text-right"><?= number_format($value["total"]) ?></td>
                </tr>        
            <?php }
            ?>

        </tbody>
    </table>
</div>
<script>
    $(document).ready(function () {
        //document ready
        var settings = {
         
            paging:false,
            searching:false
        };
        $("#top-ten-vendor").DataTable(settings);
    });
</script>
