<?php
$currentYear = date('Y');
if (!isset($year)) {
    $year = date('Y');
}
$yearArray = [];
for ($index = 2018; $index <= $currentYear; $index++) {
    $yearArray[$index] = $index;
}
$sql = "SELECT erp_customer.customer_name, SUM(`grand_total`) as total FROM `erp_invoice`JOIN erp_customer ON (erp_invoice.customer_id = erp_customer.id) WHERE YEAR(erp_invoice.invoice_date) = '{$year}' GROUP BY erp_customer.customer_name ORDER BY SUM(`grand_total`) DESC LIMIT 10 ";
$data = Yii::app()->db->createCommand($sql)->queryAll();
?>

<div class="custom-data-table">
    <h5>Top Ten Customer in <?= CHtml::dropDownList("top_ten_customer", $year, $yearArray, array('onchange' => 'js:TopTenCustomer(this.value)')) ?></h5>
    <table class="table table-hover table-bordered" style="width: 100%" id="top-ten-customer">
        <thead>
            <tr>
                <th>#</th>
                <th>Customer</th>
                <th class="text-right">Amount
                </th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($data as $key => $value) {
                ?>
                <tr>
                    <td><?= ($key + 1) ?></td>            
                    <td><?= $value["customer_name"] ?></td>
                    <td class="text-right"><?= number_format($value["total"]) ?></td>
                </tr>        
            <?php }
            ?>

        </tbody>
    </table>
</div>
<script>
    $(document).ready(function () {
        //document ready
        var settings = {
            scrollY: "300px",
            paging: false,
            searching: false
        };
        $("#top-ten-customer").DataTable(settings);
    });

   
</script>
