<?php
$currentYear = date('Y');
$currentMonth = date('m');

$totalLead = Lead::model()->count();
$addedThisYear = Lead::model()->count('YEAR(created_datetime) = :year', array(':year' => $currentYear));
$addedThisMonth = Lead::model()->count('YEAR(created_datetime) = :year AND MONTH(created_datetime) = :month', array(':year' => $currentYear, ':month' => $currentMonth));
?>
<?php 
$cs = Yii::app()->getClientScript();
$color = array();$colorname=array();
$modelcolor = MasColourScheme::model()->findAll();
foreach ($modelcolor as $evalue) {
    $color[$evalue->id] = $evalue->colour;
    $colorname[$evalue->id] = $evalue->field;
}
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("check_convert", "function check_convert(id){
    if(id == 'L')
    {

    }else{
        alert('You have no privilege to convert this lead again..');
        $('.quotation-save-btn').hide();
    }

 }", CClientScript::POS_HEAD);
 $cs->registerScript("sendLeadMail", "function sendLeadMail(){
    jQuery.ajax({
        'type': 'post',
        'dataType': 'json',
        'url': '" . Yii::app()->createUrl('lead/SendLeadConversionMail') . "',
        'cache': false,
        'success': function(data) {             
            t8.success('Mail Send Successfully');                
        }
    });
 }", CClientScript::POS_HEAD);
  ?>
<script type="text/javascript">
$(document).ready(function() {
    var table_id ="#tbl_lead_details";
    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
        data.lead_status = $("#lead_status").val();
        data.frm = $("#frm").val();
        return data;
    }).DataTable({
        scrollY         : "645px",
        pageLength      : 100,
        columns: [
            {className: "col-2"},
            {className: "col-2"},
            {className: "col-5"},               
            {className: "col-3" },
            {className: "col-3" },
            {className: "col-3" },
            {className: "col-3"},
            {className: "col-3"},
            {className: "col-3"},
            {className: "col-3"},            
            {className: "col-3"},           
            {className: "col-3"},
            
        ],    
        ajax: {
            url: "<?php echo Yii::app()->createUrl('lead/GetSalesLeadList');?>",
            type: "POST",
            data: {"frm":<?php  echo $frm;?>},
            cache : false,
        },

        serverSide:     true,
        "order": [[ 1, "desc" ]],
        "aoColumnDefs": [
            { "bSortable": false, "aTargets": [ 7,8 ] },
            {
                "targets": [8,9,10,11],
               "visible": false, 
            },
        ], 
        fixedColumns:   true,
        processing: true,
          
          "fnCreatedRow"  : function( nRow, aData, iDataIndex ){
       		$(nRow).addClass("context-menu");
            },
            "fnRowCallback" : function( nRow, aData, iDisplayIndex, iDisplayIndexFull){
                    if ( aData[8] == "High" )  {  
                        $("td", nRow).css("background-color", "<?php echo $color[7];?>"); //high
                           // $("td", nRow).addClass("bg-payment");

                    }
                    else if ( aData[8] == "Medium" ){
                       $("td", nRow).css("background-color", "<?php echo $color[6];?>"); //Medium
                        //$("td", nRow).addClass("bg-success");
                    }  else{
                        $("td", nRow).css("background-color", "<?php echo $color[5];?>"); //low                       
                    }
       	$("#tbl_lead_details tbody").mousedown(function (e) {   
           $(this).contextMenu({
               selector: ".context-menu",
              callback: function(key, options) {
           	var action_id = key;
					var data = table.row( this ).data();
					var file_id=data[0];
					var id=data[1];
					var customer_name=data[2];
					var customer_id = data[9];
					var current_process_status = data[10];
					var lead_status = data[8];
					if(action_id == "edit"){
						if(current_process_status=="L"){
							loadPopupModal("lead/create&id=" + id + "&file_id=" + file_id, "F-" + file_id + "/ L-" + id+" | "+data[2], "xl");

						}
						else{
							loadPopupModal("lead/create&view=1&id="+id,"F-" + file_id + "/ L-" + id+" | "+data[2],"xl");
						}
					}
					else if(action_id == "convert" && current_process_status=="L"){
						loadPopupModal("quotation/create&lead_id="+id+"&file_id="+file_id,"Convert To Quotation" ,"xl");
					}
					else if(action_id == "activity"){
						//loadPopupModal("activity/activity/create&frm=L&type=1&file_id="+file_id+"&customer_id="+customer_id,"Activities" ,"xl");
						loadPopupModal("activity/activity/history&file_id="+file_id+"&customer_id="+customer_id+"&header_id="+id+"&frm=L","Activities" ,"xl");
					}
					else if(action_id == "print"){
						window.open($('#liveSite').val()+"/index.php?r=lead/PrintLeadReportPDF&id=&id="+id,"_blank");
					}

					
       },
               items: {
              	 <?php if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["lead_edit"])){ ?>
                   		"edit": {name: "Edit", icon: "edit"},
                   <?php } ?>
                   <?php if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["lead_convert"]))/*  && $row->file->current_process_status=="L" */){?> 
                   		"convert": {name: "Convert", icon: "fa-retweet"},
                   	<?php } ?>
                   <?php  if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["activity_activity_view"])){ ?>
                   		"activity": {name: "Activity", icon: "fa-certificate"},
                   <?php } ?>
                   <?php if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["lead_pdf"])){ ?>
            			"print": {name: "Print", icon: "fa-print"},
            <?php  } ?>
               }
           }
           );
       });     
   }
    } );

    $(".dataTables_scrollFoot").hide();

});

</script>
    <section class="panel">
        <input type="hidden" name="frm" id="frm" value="<?php echo $frm;?>">        
<header class="panel-heading clearfix panel-theame">
    <div class="row" style="align-items: center;">
        <!-- Left: Leads Heading -->
        <div class="col-sm-6">
            Leads
        </div>

        <!-- Right: Stats + Add Button -->
        <div class="col-sm-6 text-right">
            <div style="display: flex; justify-content: flex-end; align-items: center; gap: 15px;">
                <ul class="list-inline stats-inline" style="margin: 0; font-size: 13px;">
                    <li>Total:<?php echo $totalLead; ?></li>
                    <li>This Year: <?php echo $addedThisYear; ?></li>
                    <li>This Month: <?php echo $addedThisMonth; ?></li>
                </ul>

                <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["lead_add"])) { ?>
                    <button class="btn btn-sm btn-theme" id="add_popup"
                        onclick="loadPopupModal('lead/create&frm=<?php echo $frm; ?>','Add New Lead','xl')" title="Add">
                        <i class="fa fa-plus"></i>
                    </button>
                <?php } ?>
            </div>
        </div>
    </div>
</header>


        <div class="panel-body">

            <div class="custom-data-table">

                <table class="table table-hover table-bordered personal-task" id="tbl_lead_details">

                    <thead>
                        <tr>
                            <th>File</th>
                            <th>Lead #</th>                       
                            <th>Customer</th>
                            <th>Sales Man</th>
                            <th>Enquiry Date</th> 
                            <th>Closing Date</th>
                            <th>Status</th>
                            <th>File Status</th>
                            <th>Priority</th>
                            <th></th>                               
                            <th></th>
                            <th>Created By</th>
                        </tr>
                    </thead>
                </table>

            </div>



















           <!-- <div class="color-indicator">
                <span style="display: inline-block;width:30px;height:30px;background:<?php //echo $color[5];?>; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> <?php //echo $colorname[5];?></span>
                <span style="display: inline-block;width:30px;height:30px;background:<?php //echo $color[6];?>; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> <?php //echo $colorname[6];?></span>
                <span style="display: inline-block;width:30px;height:30px;background:<?php //echo $color[7];?>; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> <?php //echo $colorname[7];?></span>
            </div>-->
        </div>

    </section>