<?php
$currentYear = date('Y');
$currentMonth = date('m');

$totalLead = Lead::model()->count();
$addedThisYear = Lead::model()->count('YEAR(created_datetime) = :year', array(':year' => $currentYear));
$addedThisMonth = Lead::model()->count('YEAR(created_datetime) = :year AND MONTH(created_datetime) = :month', array(':year' => $currentYear, ':month' => $currentMonth));
if (!(Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["lead_view_all"])) {
    $totalLead = Lead::model()->count();
    $addedThisYear = Lead::model()->count('YEAR(created_datetime) = :year', array(':year' => $currentYear));
    $addedThisMonth = Lead::model()->count('YEAR(created_datetime) = :year AND MONTH(created_datetime) = :month', array(':year' => $currentYear, ':month' => $currentMonth));
}
if (!(Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["lead_view_all"])) {
    $criteria = new CDbCriteria();
    $criteria->condition = 'lead_owner_id = :owner';
    $criteria->params = array(':owner' => Yii::app()->user->id);

    $totalLead = Lead::model()->count($criteria);

    $criteriaYear = new CDbCriteria();
    $criteriaYear->condition = 'lead_owner_id = :owner AND YEAR(created_datetime) = :year';
    $criteriaYear->params = array(':owner' => Yii::app()->user->id, ':year' => $currentYear);
    $addedThisYear = Lead::model()->count($criteriaYear);

    $criteriaMonth = new CDbCriteria();
    $criteriaMonth->condition = 'lead_owner_id = :owner AND YEAR(created_datetime) = :year AND MONTH(created_datetime) = :month';
    $criteriaMonth->params = array(':owner' => Yii::app()->user->id, ':year' => $currentYear, ':month' => $currentMonth);
    $addedThisMonth = Lead::model()->count($criteriaMonth);
}

?>
<?php
$cs = Yii::app()->getClientScript();
$color = array();
$colorname = array();
$modelcolor = MasColourScheme::model()->findAll();
foreach ($modelcolor as $evalue) {
    $color[$evalue->id] = $evalue->colour;
    $colorname[$evalue->id] = $evalue->field;
}
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("check_convert", "function check_convert(id){
    if(id == 'L')
    {

    }else{
        alert('You have no privilege to convert this lead again..');
        $('.quotation-save-btn').hide();
    }

 }", CClientScript::POS_HEAD);
$cs->registerScript("sendLeadMail", "function sendLeadMail(){
    jQuery.ajax({
        'type': 'post',
        'dataType': 'json',
        'url': '" . Yii::app()->createUrl('lead/SendLeadConversionMail') . "',
        'cache': false,
        'success': function(data) {             
            t8.success('Mail Send Successfully');                
        }
    });
 }", CClientScript::POS_HEAD);
?>
<script type="text/javascript">
    $(document).ready(function () {
        var table_id = "#tbl_lead_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.lead_status = $("#lead_status").val();
            data.frm = $("#frm").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 100,
            columns: [
                { className: "col-2" },
                { className: "col-2" },
                { className: "col-5" },
                { className: "col-3" },
                { className: "col-3" },
                { className: "col-3" },
                { className: "col-3" },
                { className: "col-3" },
                { className: "col-3" },
                { className: "col-3" },
                { className: "col-3" },
                { className: "col-3" },

            ],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('lead/GetSalesLeadList'); ?>",
                type: "POST",
                data: { "frm": <?php echo $frm; ?> },
                cache: false,
            },

            serverSide: true,
            "order": [[1, "desc"]],
            "aoColumnDefs": [
                { "bSortable": false, "aTargets": [7, 8] },
                {
                    "targets": [8, 9, 10, 11],
                    "visible": false,
                },
            ],
            fixedColumns: true,
            processing: true,

            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "rowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                if (aData[8] == "High") {
                    $("td", nRow).css("background-color", "<?php echo $color[7]; ?>"); //high
                    // $("td", nRow).addClass("bg-payment");

                }
                else if (aData[8] == "Medium") {
                    $("td", nRow).css("background-color", "<?php echo $color[6]; ?>"); //Medium
                    //$("td", nRow).addClass("bg-success");
                } else {
                    $("td", nRow).css("background-color", "<?php echo $color[5]; ?>"); //low                       
                }
            }
                 
        });

        $('#tbl_lead_details tbody').on('mouseover', 'tr', function () {
            $.contextMenu('destroy');
        });
        $('#tbl_lead_details tbody').on('click', 'tr', function () {
             var data = table.row(this).data();
             var current_process_status = data[10];
            var is_approved_status = data[12].is_approved;
            var currentApproveLevel = data[12].currentApproveLevel;
            var accessApproveLevel = data[12].accessApproveLevel;
            $.contextMenu({
                selector: '.context-menu',
                callback: function (key, options) {
                     var action_id = key;
                            var data = table.row(this).data();
                            var file_id = data[0];
                            var id = data[1];
                            var customer_name = data[2];
                            var customer_id = data[9];
                            var current_process_status = data[10];
                            var lead_status = data[8];
                            var frm = <?php echo $frm; ?>;
                     if (action_id == "edit") {
                                if (current_process_status == "L") {
                                    loadPopupModal("lead/create&frm=" + frm + "&id=" + id + "&file_id=" + file_id, "F-" + file_id + "/ L-" + id + " | " + data[2], "xl");

                                }
                                else {
                                    loadPopupModal("lead/create&view=1&id=" + id, "F-" + file_id + "/ L-" + id + " | " + data[2], "xl");
                                }
                            } else if (action_id == "approve_level" && currentApproveLevel > 0) {
                                loadPopupModal("lead/approvelevel&frm=" + frm + "&id=" + id + "&file_id=" + file_id + "&level="+currentApproveLevel, "Level "+currentApproveLevel+" Approve Lead-" + file_id + "/" + id, "lg");
                            }
                            else if (action_id == "convert" && current_process_status == "L") {
                                loadPopupModal("quotation/create&frm=" + frm + "&lead_id=" + id + "&file_id=" + file_id, "Convert To Quotation", "xl");
                            }
                            else if (action_id == "activity") {
                                //loadPopupModal("activity/activity/create&frm=L&type=1&file_id="+file_id+"&customer_id="+customer_id,"Activities" ,"xl");
                                loadPopupModal("activity/activity/history&file_id=" + file_id + "&customer_id=" + customer_id + "&header_id=" + id + "&frm=L", "Activities", "xl");
                            }
                            else if (action_id == "print") {
                                window.open($('#liveSite').val() + "/index.php?r=lead/PrintLeadReportPDF&id=&id=" + id, "_blank");
                            }
                   
                },
                items: {
                            <?php

                            $prefix = ($frm == 3) ? 'service_lead' : 'lead';
                            ?>

                            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_edit"])) { ?>
                                    "edit": { name: "Edit", icon: "edit" },
                                                    <?php } ?>
                            "approve_level": {
                                name: "Approve Level "+currentApproveLevel, icon: "fa-question", disabled: function(key, opt) {
                                    // this references the trigger element
                                    if(is_approved_status == 'Y' || accessApproveLevel =='N'){
                                        return !this.data('approveDisabled');
                                    }
                                },
                                visible: function(key, opt) {
                                    return (is_approved_status == 'N' && currentApproveLevel > 0);
                                }
                            },
                            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_convert"])) { ?>
                             
                                    "convert": { name: "Convert", icon: "fa-retweet", disabled: function (key, opt) {
                                    // this references the trigger element
                                     if (current_process_status!="L" ) {
                                        return !this.data('convertDisabled');
                                    }
                                }, visible: function(key, opt) {
                                return ((is_approved_status == 'Y' && currentApproveLevel == 0) || is_approved_status == 'Y');
                            }  },
                                                    <?php } ?>

                            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_activity"])) { ?>
                                    "activity": { name: "Activity", icon: "fa-certificate" },
                                                    <?php } ?>

                            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_pdf"])) { ?>
                                    "print": { name: "Print", icon: "fa-print", visible: function(key, opt) {
                                return ((is_approved_status == 'Y' && currentApproveLevel == 0) || is_approved_status == 'Y');
                            }  },
                                                    <?php } ?>
                        }
    });
    });
    });</script>

</script>
<section class="panel">
    <input type="hidden" name="frm" id="frm" value="<?php echo $frm; ?>">
    <header class="panel-heading clearfix panel-theame">
        <div class="row" style="align-items: center;">
            <!-- Left: Leads Heading -->
            <div class="col-sm-2">
                Leads
            </div>

            <!-- Right: Stats + Add Button -->
            <div class="col-sm-10" style="display: flex;width:82%;float:right">
                <div style="display: flex; justify-content: flex-end; align-items: center; gap: 15px;width:100%"
                    id="lead-filter-details">
                    <ul class="list-inline stats-inline" style="margin: 0; font-size: 13px;background: #f0f0f029;border-radius: 10px;margin-right: 5px;">
                        <li>Quantity: <?php echo $totalLead; ?></li>
                    </ul>
                </div>

                <div class="dropdown drp-tot">
                    <button class=" dropdown-toggle" type="button" data-toggle="dropdown">
                        <span class="selected-label">---SELECT---</span> <span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu" id="lead-filter">
                        <li><a href="#" data-id="today">Today</a></li>
                        <li><a href="#" data-id="yesterday">Yesterday</a></li>
                        <li><a href="#" data-id="this_week">This Week</a></li>
                        <li><a href="#" data-id="this_month">This Month</a></li>
                        <li><a href="#" data-id="quarterly">This Quarter</a></li>
                        <li><a href="#" data-id="this_year">This Year</a></li>

                    </ul>
                </div>

                <?php  $prefix = ($frm == 3) ? 'service_lead' : 'lead'; if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_add"])) { ?>
                    <a class="ad-btn" id="add_popup"
                        onclick="loadPopupModal('lead/create&frm=<?php echo $frm; ?>','Add New Lead','xl')" title="Add">
                        <svg width="30" height="30" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                            class="pluss-ad">
                            <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                            <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                            <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                        </svg>
                    </a>

                <?php } ?>
            </div>
        </div>
        </div>
    </header>


    <div class="panel-body">

        <div class="custom-data-table">

            <table class="table table-hover table-bordered personal-task" id="tbl_lead_details">

                <thead>
                    <tr>
                        <th>File</th>
                        <th>Lead #</th>
                        <th>Customer</th>
                        <th>Sales Man</th>
                        <th>Enquiry Date</th>
                        <th>Closing Date</th>
                        <th>Status</th>
                        <th>File Status</th>
                        <th>Priority</th>
                        <th></th>
                        <th></th>
                        <th>Created By</th>
                    </tr>
                </thead>
            </table>

        </div>



















        <!-- <div class="color-indicator">
                <span style="display: inline-block;width:30px;height:30px;background:<?php //echo $color[5]; ?>; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> <?php //echo $colorname[5]; ?></span>
                <span style="display: inline-block;width:30px;height:30px;background:<?php //echo $color[6]; ?>; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> <?php //echo $colorname[6]; ?></span>
                <span style="display: inline-block;width:30px;height:30px;background:<?php //echo $color[7]; ?>; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> <?php //echo $colorname[7]; ?></span>
            </div>-->
    </div>

</section>


<script>
    $(document).ready(function () {
        $('#lead-filter li a').on('click', function (e) {
            e.preventDefault(); // Prevent default link behavior

            var filter = $(this).data('id');
            var label = $(this).text();
            var frm = <?php echo $frm; ?>;
            $('.selected-label').text(label);
            $.ajax({
                url: "<?php echo Yii::app()->createUrl('lead/GetFilterleadData'); ?>",
                type: "POST",
                dataType: "json",
                data: { filter: filter, frm: frm },
                success: function (response) {
                    if (response.status === "success") {
                        var qty = response.data.qty || 0;

                        // Use actual period label for current (e.g., "26-06-2025" or "2025")
                        var periodLabel = response.data.current_period || new Date().getFullYear();

                        // Base content for current period
                        var htmlContent = '<li>(' + periodLabel + ') Count: ' + qty + '</li>';

                        // Handle previous_years if exists
                        if (response.data.previous_years && response.data.previous_years.length > 0) {
                            response.data.previous_years.forEach(function (yearData) {
                                var prevQty = yearData.qty || 0;


                                // Prefer date label for today/yesterday, fallback to year
                                var label = yearData.date || yearData.year;

                                htmlContent += '<li> | (' + label + ') Count: ' + prevQty + '</li>';
                            });
                        }

                        $('#lead-filter-details ul').html(htmlContent);
                    } else {
                        t8.error("Failed to fetch invoice data.");
                    }
                },

                error: function (xhr, status, error) {
                    console.error("AJAX Error:", status, error);
                    t8.error("Something went wrong.");
                }
            });
        });
    });
</script>