<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("deleteLandedCostItems", "function deleteLandedCostItems(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=landedcostitems/deleteLandedCostItems',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    alert('Error while Delete', 'Alert');
                }else {
                    location.href=$('#liveSite').val()+'index.php?r=landedcostitems/index';
                    t8.success('Footer Item Deleted SuccessFully!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>

<script>
    $(document).ready(function () {
        var table_id = "#tbl_landed_cost_items_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('landedcostitems/GetLandedCostItemsList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
                console.log(aData);
                if (aData[7].isActive == "N") {
                    $("td", nRow).addClass("bg-danger");
                }
            }
        });
    });
    function AddContextMenu(row, datas) {
        var mas_edit=0;
        var mas_disable=0;
        <?php if (isset(Yii::app()->user->havePermissionOn['landed_cost_items_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_edit=1;
        <?php } ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['landed_cost_items_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_disable=1;
        <?php } ?> 
        $(row).contextMenu({
            selector: 'td',

            items: {
                "edit": {
                        name: "Edit",
                        icon: "edit",
                        accesskey: "e",
                        callback: function () {
                            loadPopupModal("landedcostitems/create&id=" + datas[7].id, datas[7].code, "lg");
                        }, 
                    disabled: function(key, opt) { 
                        // this references the trigger element
                        if(mas_edit=='0'){
                            return !this.data('editDisabled'); 
                        }
    			    }
                },
                "Disable_Enable":{
                        name: "Disable/Enable",
                                icon: "edit",
                                accesskey: "d",
                                callback: function () {
                                Disable(datas[7].id);
                                },
                    disabled: function(key, opt) { 
                            // this references the trigger element
                            if(mas_disable=='0'){
                                return !this.data('Disable_EnableDisabled'); 
                            }
			        }
                },


            }
        });
    }
</script>
<script>
    function Disable(id){
    var r = confirm('Are you sure to disable this?');
    if (r == true)
    {
    jQuery.ajax({
    'type'  : 'post',
            'data'  : 'id=' + id,
            'url'  : $('#liveSite').val() + 'index.php?r=landedcostitems/Disable',
            'cache': false,
            'success':function(data){
            if (data == 'fail'){
            t8.error('Error while Delete');
            } else {
            location.href = $('#liveSite').val() + 'index.php?r=landedcostitems/index';
            t8.success('Success!');
            }
            }
    });
    }


    }
</script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-dollar"></i> Landed Cost Item Details
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['landed_cost_items_add']) || Yii::app()->user->authorised_user == 1) { ?>

                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('landedcostitems/create', 'Add New Landed Cost Item', 'lg')"><i class="fa fa-plus"></i> ADD</button>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_landed_cost_items_details">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Ledger</th>
                        <th>Subledger</th>
                        <th>Item Type</th>
                        <th>Item Name</th>
                        <th>Description</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
