
<?php // $cs = Yii::app()->getClientScript(); ?>

<?php

$form = $this->beginWidget('CActiveForm', array(

    'id' => 'landedcostitem-form',

    'enableAjaxValidation' => false,

    'enableClientValidation' => false,

    //'action'=>Yii::app()->createUrl('/Bank/SaveBank'),

    ));
    
    //To get model from finance module
    Yii::app()->getModule('finance');

?>

    <div class="tab-content">

        <div class="tab-pane active">

                   <ul class="clearfix form-ul material">
                         <li class="col-sm-4">
                            
                            <?php echo $form->dropDownList($model, 'account_id',FinanceLegder::getChilds(),array('data-label'=>'Ledger <span style="color:red">*</span>','data-validation'=>'required','empty'=>'--Select--','data-search'=>true, 'onChange' => 'js:checkSubledgerExist(this.id);')); ?>
                            <?php echo $form->hiddenField($model, 'id'); ?>
                            <?php echo $form->hiddenField($model, 'have_sub_ledger'); ?>
                        </li>
                         <li class="col-sm-4" id="li_sub_ledger">
                                <?php echo $form->hiddenField($model,"subledger_id"); ?>
                                <?php echo $form->textField($model,"subledger_name",array('data-label'=>'Subledger <span style="color:red">*</span>', 'onKeyup' => 'js:getSublegders(this.id);', 'readonly' => ( !$model->isNewRecord && $model->subledger_id == 0) ? true : false )); ?>
                        </li>   

                        <li class="col-sm-4">
                                 
                                 <?php echo $form->dropDownList($model, 'item_type',array(1=>'Addition',2=>'Deduction'),array('data-label'=>'Item Type <span style="color:red">*</span>','data-validation'=>'required','empty'=>'--Select--')); ?>
                                 <?php echo $form->error($model,'item_type'); ?>
                        </li>
                        <li class="col-sm-4">
                                
                                 <?php echo $form->textField($model, 'item_name',array('data-label'=>'Item Name <span style="color:red">*</span>','data-validation'=>'required')); ?>
                                 <?php echo $form->error($model,'item_name'); ?>
                        </li> 
                         <li class="col-sm-8">                  
                       <?php echo $form->textArea($model, 'description',array('data-label'=>'Description')); ?>
                          <?php echo $form->error($model, 'description'); ?>
                       </li>
    		</ul>
        </div>
    </div>

<div class="modal-footer">

    <button type="button" class="btn btn-danger " id="footer_close" data-dismiss="modal">Close</button>

    	<?php
        $url = Yii::app()->createUrl('landedcostitems/SaveLandedCostItem');
        
        echo CHtml::ajaxsubmitButton('Save',$url, array(
                            'dataType' => 'json',

                            'type' => 'post',

                            'success' => 'function(data) {
                                    $("#loader").hide();
                                    if(data.status=="success"){  

                                        t8.success("Landed Cost Item Saved Successfully!");
                                        $("#footer_close").click();
                                        //location.reload();
                                        reloadTable("#tbl_landed_cost_items_details");

                                    } else { 

                                        $("#landedcostitem-form .footeritem-save-btn").prop("disabled", false); 
                                        $("#landedcostitem-form .footeritem-save-btn").addClass("btn-theme").removeClass("btn_loding");
                                        $.each(data, function(key, val) {
                                                $("#landedcostitem-form #"+key+"_em_").text(val).show(); 
                                                t8.error(""+val+""); 
                                        }); 

                                    } 

                                    }',

                           'beforeSend' => 'function(){
                                $("#loader").show();
                                $(".toast8-error").hide();                                 
                                $("#landedcostitem-form .footeritem-save-btn").prop("disabled", true); 
                                $("#landedcostitem-form .footeritem-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
                            }'

                                

                    ), array('id' => 'mybtn' . rand(), 'class' => 'footeritem-save-btn btn btn-theme'));

    ?>


    </div>


<?php $this->endWidget(); ?>
<?php
        $cs = Yii::app()->getClientScript();
$cs->registerScript("getSublegders", "function getSublegders(field_id)
        {
            var account_id = $('#MasLandedCostItems_account_id').val();
            
            if( account_id > 0 ){
                var url = '" . Yii::app()->createUrl('finance/vouchers/subledgerlist') . "&ledger='+account_id;
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response, url) },
                    focus       : function( event, ui ) {},
                    select          : function( event, ui ) {
                        event.preventDefault();
                        $('#MasLandedCostItems_subledger_name').val(ui.item.label);
                        $('#MasLandedCostItems_subledger_id').val(ui.item.value);
                    }
                })
            }else{
                t8.error('Choose Ledger First!');
                $('#MasLandedCostItems_subledger_name').val('');
                return false;
            }
        }", CClientScript::POS_HEAD); 
        
        $cs->registerScript("checkSubledgerExist", "function checkSubledgerExist(field_id)
        {
            var account_id = $('#MasLandedCostItems_account_id').val();
            
             jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('landedcostitems/checksubledgerexist') . "',
                'data' : {'account_id' : account_id},
                'success': function(data) { 
                    $('#MasLandedCostItems_have_sub_ledger').val(data);
                }
            });
        }", CClientScript::POS_HEAD); 










