<script type="text/javascript">
$(document).ready(function () {
    var table_id = "#tbl_directtransfer_details";
    var table = $(table_id).DataTable({
        scrollY: "380px",
        pageLength: 50,
        processing: true,
        "columnDefs": [
            {
                "targets": [9],
                "visible": false,
            },
        ],
        ajax: {
            url: "<?php echo Yii::app()->createUrl('iwarehouse/Getlistmeterial'); ?>",
            type: "POST",
            cache: false,
        },
        serverSide: true,
        fixedColumns: true,
        processing: true,
        fixedHeader: {
            headerOffset: $("header.main").outerHeight()
        },
        "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
        },
        "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            $("#tbl_directtransfer_details tbody").mousedown(function (e) {
                $(this).contextMenu({
                    selector: ".context-menu",
                    build: function ($trigger, e) {
                        const rowData = table.row($trigger).data();
                        const id = rowData[0];
                        var part_number = rowData[2];
                        var status = rowData[10];
                        var approved_status = rowData[11];
                        const items = {};
                        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_transfer_convert"])) { ?>
                            if (status == 'T') {
                                items.convert = {
                                    name: "Return Oil",
                                    icon: "fa-share"
                                };
                            }
                        <?php }
                        if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_transfer_in_add"]) || ((int) Yii::app()->user->havePermissionOn["direct_transfer_in_add"])) { ?>
                            if (status == 'T') {
                                items.edit = {
                                    name: "Edit",
                                    icon: "fa-edit"
                                };
                            } else {
                                items.view = {
                                    name: "View",
                                    icon: "fa-eye"
                                };
                            }
                        <?php }
                        if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_transfer_convert"])) { ?>
                            if (approved_status == 'N' && status == 'C') {
                                items.approve = {
                                    name: "Approve",
                                    icon: "fa-check"
                                };
                            }
                        <?php } ?>
                        items.print = {
                            name: "Print",
                            icon: "fa-print"
                        };
                        return {
                            callback: function (key, options) {
                                if (key === "edit" && status == 'T') {
                                    loadPopupModal("iwarehouse/createmeterial&id=" + id + "&status=" + status, "Edit Oil Issual - " + id, "xl");
                                }
                                if (key === 'view' && status == 'C') {
                                    loadPopupModal("iwarehouse/createmeterial&id=" + id + "&status=" + status, "View Oil Issual - " + id, "xl");
                                }
                                if (key === "convert" && status == 'T') {
                                    loadPopupModal("iwarehouse/convertmeterial&id=" + id + "&status=" + status, "Return Oil - " + id, "xl");
                                }
                                if (key === "approve" && status == 'C' && approved_status == 'N') {
                                    approveReturn(id);
                                }
                                if (key === "print") {
                                    window.open($("#liveSite").val()+"/index.php?r=iwarehouse/PrintMachine&id=" + id,"_blank");
                                }
                            },
                            items: items
                        };
                    }
               });
            });
        }
    });
    $(".dataTables_scrollFoot").hide();
});
function approveReturn(id) {
    var r = confirm('Are you sure to approve the return?');
    if(r==true) {
        jQuery.ajax({
            'type'  : 'post',
            'data'  : 'id=' + id ,
            'url'  : $('#liveSite').val()+'index.php?r=iwarehouse/Approve',
            'cache': false,
            'success':function(data){
                if(data.status=='fail'){
                    t8.error('Error while Approvel');
                }else {
                    $('#po_close').click();
                    t8.success('Approved SuccessFully!');
                    reloadTable('#tbl_directtransfer_details');
                }
            }
        });
    }
}
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">Oil Issual
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['direct_transfer_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <a class="ad-btn" onclick="loadPopupModal('iwarehouse/createmeterial','Add Oil Issual','xl')" title="Add Oil Issual"><svg width="30" height="30" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                    <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                        <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                        <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                </svg></a>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_directtransfer_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>Transfer No</th>
                        <th>Customer</th>
                        <th>Transfer Date</th>
                        <th>From Warehouse</th>
                        <th>To Warehouse</th>
                        <th>Technician</th>
                        <th>Description</th>
                        <th>Reference</th>
                        <th>Status</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>