<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("deleteGeneric", "function deleteGeneric(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=generic/deleteGeneric',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    alert('Error while Delete', 'Alert');
                }else {
                    location.href=$('#liveSite').val()+'index.php?r=generic/index';
                    notification('Generic Deleted SuccessFully!','success');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-ship"></i> -->
        <?php echo ($frm === 'out') ? 'Transfers Out' : (($frm === 'in') ? 'Transfers In' : ' In Transit'); ?>
        </div>
    </header>

    <div class="tab-content">

        <section class="panel">
            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tbl_InTransit_details">
                        <thead>
                            <tr>
                                <th>Transfer No</th>
                                <th>Transfer Date</th>
                                <th>From Warehouse</th>
                                <th>Destination</th>
                                <th>Reference</th>
                                <th>Description</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </section>
    </div>
    <script>
        function initDirectTransferTable() {
            var tableId = "#tbl_InTransit_details";

            // Destroy existing instance if it exists
            if ($.fn.DataTable.isDataTable(tableId)) {
                $(tableId).DataTable().clear().destroy();
                $.contextMenu('destroy');  // Destroy existing context menu to avoid duplication
            }

            // Initialize the table and save the instance
            var table = $(tableId).DataTable({
                scrollY: "100%",
                pageLength: 50,
                processing: true,
                serverSide: true,
                ajax: {
                    url: "<?php echo Yii::app()->createUrl('iwarehouse/GetIndirecttransactionlistTransit') ?>",
                    type: "POST",
                    cache: false,
                },
                fixedColumns: true,
                fixedHeader: {
                    headerOffset: $("header.main").outerHeight() || 0
                },
                columnDefs: [
                    {
                        targets: 6,
                        visible: false
                    }
                ],
                fnCreatedRow: function (nRow, aData, iDataIndex) {
                    $(nRow).addClass("context-menu");
                }
            });

            // Dynamically build context menu based on row data
            $.contextMenu({
                selector: tableId + ' tbody tr.context-menu',
                build: function ($trigger, e) {
                    const rowData = table.row($trigger).data();
                    const id = rowData[0];
                    const status = rowData[7]; // Ensure this column holds the status

                    const items = {};

                    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_transfer_out_print"]) || ((int) Yii::app()->user->havePermissionOn["direct_transfer_in_print"])) { ?>
                        items.print = {
                            name: "Print",
                            icon: "fa-print"
                        };
                    <?php } ?>

                    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_transfer_in_add"])) { ?>
                        if (status !== 'TO') {
                            items.convert = {
                                name: "Convert",
                                icon: "fa-share"
                            };
                        }
                    <?php } ?>

                    return {
                        callback: function (key, options) {
                            if (key === "print") {
                                window.open('index.php?r=iwarehouse/PrintInDirectTransferPDF&frm=transit&id=' + id);
                            }
                            if (key === "convert") {
                                loadPopupModal('iwarehouse/indirectcreate&type=convert&frm=in&id=' + id, 'Convert Transfer In - ' + id, 'xl');
                            }
                        },
                        items: items
                    };
                }
            });
        }

        $(document).ready(function () {
            initDirectTransferTable();
        });
    </script>