<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$total_qty = 0;
$months = array(
    '1' => 'January',
    '2' => 'Februvary',
    '3' => 'March',
    '4' => 'April',
    '5' => 'May',
    '6' => 'June',
    '7' => 'July',
    '8' => 'August',
    '9' => 'September',
    '10' => 'October',
    '11' => 'November',
    '12' => 'December'
); ?>
<div id="div_contract_item_details">
    <div class="table-responsive">
        <table class="table table-hover table-bordered personal-task" id="contract_item_table">
            <tr class="header-row">
                <th>#</th>
                <th>Contract Month</th> <!-- NEW COLUMN -->
                <th>Product Name</th>
                <th>Fragrance</th>
            </tr>
            <?php foreach ($modelContract as $i => $item): ?>
                <tr id="row_<?php echo $i; ?>">
                    <td><?php echo ($i + 1); ?></td>
                    <td>
                        <?php
                        $item->contract_month = $months[$item->contract_month];
                        echo CHtml::textField("OrderContractItem[$i][contract_month]", $item->contract_month ?? '', [
                            'class' => 'form-control input-sm',
                            'placeholder' => 'Contract month',
                            'id' => "OrderContractItem_{$i}_contract_month",
                            'readonly' => true
                        ]); ?>
                    </td>
                    <td>
                        <?php echo CHtml::textField("OrderContractItem[$i][part_number]", $item->part_number ?? '', [
                            'class' => 'form-control input-sm',
                            'placeholder' => 'Product',
                            'id' => "OrderContractItem_{$i}_part_number",
                            'readonly' => true
                        ]); ?>
                        <?php echo CHtml::hiddenField("OrderContractItem[$i][product_id]", $item->product_id ?? '', ['id' => "OrderContractItem_{$i}_product_id"]); ?>
                    </td>
                    <td>
                        <?php echo CHtml::textField("OrderContractItem[$i][description]", $item->description ?? '', [
                            'class' => 'form-control input-sm',
                            'placeholder' => 'Description',
                            'id' => "OrderContractItem_{$i}_description",
                            'readonly' => true
                        ]); ?>
                    </td>
                </tr>
                <?php
            endforeach; ?>
        </table>
    </div>
</div>