<script type="text/javascript">
    $(document).ready(function () {

        var table_id = "#tbl_directtransfer_details";
        var table = $(table_id).DataTable({
            scrollY: "380px",
            pageLength: 50,
            processing: true,
            "columnDefs": [
                {
                    "targets": [5],
                    "visible": false,
                },
            ],

            ajax: {
                url: "<?php echo Yii::app()->createUrl('iwarehouse/Getlist'); ?>", 
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {

                $("#tbl_directtransfer_details tbody").mousedown(function (e) {
                    $(this).contextMenu({
                        selector: ".context-menu",
                        callback: function (key, options) {
                            var action_id = key;
                            var data = table.row(this).data();
                            var id = data[0];
                            var part_number = data[2];
                            // var status = data[6];
                            // if(action_id == "convert"){
                            // 	loadPopupModal("packaging/create&id="+id,"Convert - "+id ,"xl");
                            // }
                            if (action_id == "print") {
                                window.open($('#liveSite').val() + "/index.php?r=iwarehouse/PrintDirectTransferPDF&id=" + id, "_blank")
                            }

                            else if (action_id == "excel") {
                                window.open($('#liveSite').val() + "/index.php?r=iwarehouse/PrintDirectTransferExcel&id=" + id, "_blank")
                            }


                        },
                        items: {
                            <?php if (isset(Yii::app()->user->havePermissionOn['direct_transfer_excel']) || Yii::app()->user->authorised_user == 1) { ?>
                                     "excel": { name: "Excel", icon: "fa-file-excel-o" },
                            <?php } ?>
                     <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_transfer_print"])) { ?>
                                     "print": { name: "Print", icon: "fa-print" },
                            <?php } ?>
                        }
                    }
                    );
                });
            }
        });
        $(".dataTables_scrollFoot").hide();
    });
</script>

<?php
/*$cs = Yii::app()->getClientScript();
$cs->registerScript("loadTransfers", '
        $(document).ready(function() {
            $("#tbl_directtransfer_details").DataTable({
                scrollY         : "645px",
                pageLength      : 50,
                processing: true,
                ajax: {
                    url: "' . Yii::app()->createUrl('iwarehouse/Getlist') . '",
                    type: "POST",
                    cache : false,
                },
                serverSide:     true,
                aaSorting : [[ 0, "desc" ]],
                fixedColumns:   true,
                processing: true,
                "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
                },
                "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {

                    AddContextMenu(nRow, aData);
                }

            });
            function AddContextMenu(row, datas) {
              $print = 0;

             $(row).contextMenu({
            selector: "td",

            items: {
                "print": {
                    name: "Print",
                    icon: "print",
                    accesskey: "e",
                    callback: function () {
                        loadPopupModal("vendor/create&id=" + datas[7].id,datas[7].id+" &nbsp;| &nbsp;"+ datas[7].code, "lg");
                    },
                    disabled: function(key, opt) {
                        // this references the trigger element
                        if ($vendor_edit == 0){
                        return !this.data("editDisabled");
                        }
                    }
                },



            }
        });

          }
    });', CClientScript::POS_HEAD); */
?>
<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li id="pk_li" onclick="reloadTable('#tbl_packing_list');" class="active"><a href="#tab1" data-toggle="tab"><i
                class="fa fa-truck"></i> Packaging</a></li>
    <!--li id="ck_li" onclick="reloadTable('#tble_tble_check_in');"><a href="#tab2" data-toggle="tab"> <i class="fa fa fa-area-chart"></i> Checkin</a></li-->
    <li id="tr_li" onclick="reloadTable('#tbl_directtransfer_details');"><a href="#tab2" data-toggle="tab"><i
                class="fa fa-globe"></i> Transfer</a></li>
</ul>
<div class="tab-content">

    <div class="tab-pane active" id="tab1">
        <section class="panel" style="background-color:#F6F3EE;">

            <header class="panel-heading clearfix panel-theame">
                Transfers
                <div class="pull-right">
                    <?php if (isset(Yii::app()->user->havePermissionOn['direct_transfer_add']) || Yii::app()->user->authorised_user == 1) { ?>
                        <a class="ad-btn" onclick="loadPopupModal('iwarehouse/directcreate','New Transfer','xl')"
                            title="Add"><svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2"
                                    stroke-linecap="round" />
                                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2"
                                    stroke-linecap="round" />
                            </svg></a>
                    <?php } ?>
                </div>
            </header>
            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tbl_packing_list"
                        style="font-size:13px;">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>From</th>
                                <th>To</th>
                                <th>Date</th>
                                <th>File#</th>
                                <th>Customer</th>
                                <th>Status</th>
                                <th>Technician</th>
                            </tr>
                        </thead>
                    </table>
                    </table>
                </div>
            </div>
        </section>
    </div>
    <!--div class="tab-pane" id="tab2">
    <section class="panel">
                <div class="panel-body">
                    <div class="custom-data-table">
                        <table class="table table-hover table-bordered personal-task" id="tble_tble_check_in">
                            <thead style="width: 100%;">
                                <tr>
                                <th>No</th>
                                <th>File#</th>
                                <th>Date</th>
                                <th>Customer</th>
                                <th>Status</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </section>
        </div-->
    <div class="tab-pane" id="tab2">
        <section class="panel" style="background-color:#F6F3EE;">

            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tbl_directtransfer_details"
                        style="font-size:13px;">
                        <thead>
                            <tr>
                                <th>Transfer No</th>
                                <th>Transfer Date</th>
                                <th>From Warehouse</th>
                                <th>To Warehouse</th>
                                <th>Technician</th>
                                <th>Description</th>
                                <th>Reference</th>
                                <?php  //if (isset(Yii::app()->user->havePermissionOn['direct_transfer_print']) || isset(Yii::app()->user->havePermissionOn['direct_transfer_excel']) || Yii::app()->user->authorised_user == 1) { ?>
                                <!-- <th>Actions</th> -->
                                <?php //} ?>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </section>
    </div>

</div>
<script>
    var table_id = "#tbl_packing_list";
    var table = $(table_id).DataTable({
        scrollY: "645px",
        pageLength: 100,
        processing: true,
        "columnDefs": [
            {
                "targets": [5],
                "visible": false,
            },
        ],

        ajax: {
            url: "<?php echo Yii::app()->createUrl('packaging/GetList&frm=DTOUT'); ?>",
            type: "POST",
            cache: false,
        },
        columns: [
            { title: "Transaction No", data: 0 }, // transaction_id
            { title: "Date", data: 1 },           // transaction_date
            { title: "From", data: 7 },           // location_from
            { title: "To", data: 6 },             // location_to
            { title: "File#", data: 3 },          // file_id
            { title: "Customer", data: 2 },       // customer_name
            { title: "Status", data: 5 } , 
            { title: "Technician", data: 8 }  // Technician
        ],

        columnDefs: [
            { targets: [4, 5, 6], visible: false }, // hide File#, Customer, Status
            {}
        ],
        serverSide: true,
        fixedColumns: true,
        processing: true,
        fixedHeader: {
            headerOffset: $("header.main").outerHeight()
        },
        "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
        },
        "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {

            $("#tbl_packing_list tbody").mousedown(function (e) {
                $(this).contextMenu({
                    selector: ".context-menu",
                    callback: function (key, options) {
                        var action_id = key;
                        var data = table.row(this).data();
                        var id = data[0];
                        var part_number = data[1];
                        var status = data[4];
                        //alert(status);
                        if (action_id == "convert") {
                            loadPopupModal("packaging/create&id=" + id + "&status=" + status, "Convert - " + id, "lg");
                        }
                        else if (action_id == "edit") {
                            loadPopupModal("iwarehouse/directcreate&id=" + id + "&status=" + status, "Edit Transfer - " + id, "xl");
                        }


                    },
                    items: {
                        <?php if (isset(Yii::app()->user->havePermissionOn['direct_transfer_convert']) || Yii::app()->user->authorised_user == 1) { ?>
                                     "convert": { name: "Convert", icon: "fa-retweet" },
                        <?php } ?>
                     <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_transfer_edit"])) { ?>
                                     "edit": { name: "Edit", icon: "fa-edit" },
                        <?php } ?>
                    }
                }
                );
            });
        }
    });

    /*var table_2 = $('#tble_tble_check_in').DataTable({
        scrollY: "645px",
        pageLength: 50,
        processing: true,
        columns: [
            { className: "nw sl col-max-1" },
            { className: "nw sl col-max-4" },
            { className: "nw sl col-max-5" },
            { className: "nw sl col-max-3" },
            { className: "nw sl col-max-3" },
        ],
        ajax: {
            url: "<?php echo Yii::app()->createUrl('checkin/GetList&frm=DTCK') ?>",
            type: "POST",
            cache: false,
        },
        serverSide: true,
        fixedColumns: true,
        processing: true,
        "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
        },
        "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {

            $("#tble_tble_check_in tbody").mousedown(function (e) {
                $(this).contextMenu({
                    selector: ".context-menu",
                    callback: function (key, options) {
                        var action_id = key;
                        var data = table_2.row(this).data();
                        var id = data[0];
                        var part_number = data[1];
                        var status = data[5];
                        if (action_id == "convert") {
                            loadPopupModal("checkin/create&id=" + id + "&status=" + status, "Items - " + id, "xl");
                        }
                    },
                    items: {
                        <?php //if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["rawmaterial_edit"])){ ?>
                       "convert": { name: "Convert", icon: "fa-retweet" },
                        <?php //} ?>
                    }
                }
                );
            });
        }
    });*/
</script>