<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$total_vat = $total_ =0;
$model_settings         = new MasCompanySettings();
$crm_login_company_id   = Yii::app()->user->master_user_company_id;        
$model_settings         = $model_settings->find(array('condition'=>'crm_company_id='.$crm_login_company_id));  
$bonus_quantity         = $model_settings->bonus_quantity;
?>

<div id="div_service_item_details">
    <div class="table-responsive">
        <table class="table table-hover table-bordered personal-task" id="exchange_invoice_item_table">
            <tr>
                <th style="width:15%">Item</th>
                <th style="width:20%">Description</th>
                <th style="width:8%">Quantity</th>
                <th style="width:8%">Unit</th>
                <th style="width:8%">Rate</th>
                <th>Disc. %</th>
                <th>Discount</th>
                <th style="width:10%">Net/Item</th>
                <th style="width:8%">Tax(%)</th>
                <th style="width:10%">Amount</th>
                <th style="width:2%"><a class="btn btn-xs btn-theme " href="javascript:void(0);" onclick="addTableRow($('#exchange_invoice_item_table'));"><i class="fa fa-plus"></i></a></th>
                </th>
            </tr>
            <?php
            $total = $total_vat = 0;
            $readonly = '';
            if ($type == 'view') {
                $readonly = 'readonly';
            }

            foreach ($modelInvoiceItems as $i => $modelItems) {
                $value = $modelItems->product->part_number;
                $modelItems->id='';
                ?>
                <tr>
                    <td>
                        <?php echo $form->textField($modelItems, "[" . $i . "]product_name", array('class' => 'tooltipster go', 'onKeypress' => 'js:autoCompleteProduct(this.id,"invoice");', 'readonly' => $readonly, 'value' => $value)); ?>
                        <?php echo $form->hiddenField($modelItems, "[" . $i . "]product_id"); ?>
                        <?php echo $form->hiddenField($modelItems, "[" . $i . "]id"); ?>
                    </td>
                    <td>
                        <?php echo $form->textArea($modelItems, "[" . $i . "]description", array('class' => 'tooltipster desc go en-text-area', 'readonly' => $readonly)); ?>
                    </td>
                    <td>

                        <?php echo $form->textField($modelItems, "[" . $i . "]quantity", array('class' => 'qty go cell-center text-right', 'onkeypress' => 'return isNumberKey(event,this.value);', 'onkeyup' => 'calculateExchangeInvoice($("#exchange_invoice_item_table"))', 'readonly' => $readonly)); ?>
                    </td>
                    <?php
                    $modelItems->unit = $modelItems->invoiceunit->name;
                    ?>

                    <td id="unit_<?php echo $i; ?>">
                        <?php
                        ($modelItems->product_id > 0) ? $data = UnitOfMeasurement::getUnits($modelItems->product_id) : $data = array();
                        ?>
                        <?php echo $form->dropdownlist($modelItems, "[" . $i . "]unit_id", $data, array('class' => 'qty go')); ?>
                    </td>
                    <td>
                        <?php echo $form->hiddenField($modelItems, "[" . $i . "]actual_tax_percentage", array('value' => $modelItems->product->tax->percentage)); ?>
                        <?php echo $form->hiddenField($modelItems, "[" . $i . "]actual_tax_amount", array('value' => $modelItems->tax_vat_amount)); ?>
                        <input type="hidden" id="check_direct_sale_tax_percentage_<?php echo $i; ?>" value="<?php echo $modelItems->product->tax->percentage; ?>" />
                        <?php echo $form->textField($modelItems, "[" . $i . "]rate", array('class' => 'rate go text-right'/* ,'onblur' => 'checkSaleRate(this.id);' */, 'onkeypress' => 'return isNumberKey(event,this.value);', 'onkeyup' => 'calculateExchangeInvoice($("#exchange_invoice_item_table"))', 'readonly' => $readonly)); ?>
                        <?php echo $form->hiddenField($modelItems, "[" . $i . "]actual_rate"); ?>
                    </td>
                    <td>
                        <?php echo $form->textField($modelItems, "[" . $i . "]deduction_percentage", array('class' => 'txt-6 go exception text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateExchangeInvoice($("#exchange_invoice_item_table"));')); ?>                    
                    </td>
                    <td>
                        <?php echo $form->textField($modelItems, "[" . $i . "]deduction_amount", array('class' => 'go exception text-right deductions', 'onkeypress' => 'return isNumberKey(event,this.value)', 'onkeyup' => 'calculateExchangeInvoice($("#exchange_invoice_item_table"));')); ?>
                        <?php echo $form->error($modelItems, "[" . $i . "]deduction_amount"); ?>

                    </td>
                    <td>
                        <?php
                        if ($modelItems->net_per_item == 0 && $modelItems->quantity > 0) {
                            $modelItems->net_per_item = $modelItems->rate + ($modelItems->tax_vat_amount / $modelItems->quantity);
                        }
                        echo $form->textField($modelItems, "[" . $i . "]net_per_item", array('class' => 'go text-right', 'onkeypress' => 'return isNumberKey(event,this.value)', 'onkeyup' => 'calculateReverseInvoiceValue(this.id)','readonly'=>true));
                        ?>
                    </td> 
                    <td>
                        <?php echo $form->textField($modelItems, "[" . $i . "]tax_vat_percentage", array('class' => 'rate go text-right', 'readonly' => 'readonly')); ?>
                        <?php echo $form->hiddenField($modelItems, "[" . $i . "]tax_vat_amount", array('class' => 'unit go cell-center text-center')); ?>
                    </td>    
                    <td>
                        <?php 
                        $modelItems->amount = $modelItems->net_amount;
                        echo $form->textField($modelItems, "[" . $i . "]amount", array('class' => 'amount go text-right', 'onkeypress' => 'return isNumberKey(event,this.value)', 'readonly' => 'readonly')); ?>
                    </td>
                    <td class="text-center nw" width="1%">
                        <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-xs btn-danger', 'onclick' => 'removeExchangeInvoiceTableRow($(\'#exchange_invoice_item_table\'),this)', 'title' => 'Remove this item', 'id' => 'material_' . $i)); ?>
                    </td>
                </tr>
                <?php
                $total += $modelItems->amount;
                $total_vat += $modelItems->tax_vat_amount;
                $grand_total = $total + $total_vat;
            }
            ?>
        </table>
        <table class="table table-hover table-bordered table-nexted material_total">
            <tr class="bg-total">
                <td width="70%" class="text-right table_total_title">
                    <h2>Total</h2>
                </td>
                <td width="30%" class="text-right table_total ">
                    <h2 class="text-right exchange_invoice_total"><?php echo Yii::app()->numberFormatter->formatCurrency($total, " "); ?></h2>
                </td>
            </tr>
        </table>  
        <table class="table table-hover table-bordered table-nexted order_grand_total">
            <tr  class="summary_tr bg-total"> 
                <td width="70%" class="text-right table_total_title">
                    <h2>VAT</h2></td>
                <td width="30%" class="text-right table_total">
                    <h2 class="vat exchange_invoice_vat_total" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_vat, " "); ?></h2></td>
            </tr>
            <tr class="summary_tr bg-total">
                <td width="70%" class="text-right table_total_title">
                    <h1>Grand Total</h1></td>
                <td width="30%" class="text-right table_total">
                    <h1 class="grandtotal exchange_invoice_grand_total" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency(($grand_total), " "); ?></h1>
                </td>
            </tr>
        </table>
        </div>
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php  echo $form->dropDownList($model, 'created_by', User::getActiveUsers(), array( 'data-label' => 'Salesman <span style="color:red;">*</span>', 'prompt' => 'Select','data-search'=>true)); ?>
            </li>
             <li class="col-sm-2">
                <?php echo CHtml::textField('invoice_totalamount',Yii::app()->numberFormatter->formatCurrency(($grand_total), " "), array('class' => 'text-bold  text-right',  'data-label' => 'Invoice Amount')); ?>
            </li>
            <li class="col-sm-2">
                <?php 
                if($model->received_amount>0)
                {
              $receive= number_format(floatval($model->received_amount), 2, '.', ''); 
                }
                echo $form->textField($model, 'received_amount', array('class' => 'text-bold  text-right','onkeypress' => 'return isNumberKey(event,this.value);',  'data-label' => 'Previous Invoice Amount <span style="color:red;">*</span>','value' => $receive,'readonly'=>true)); ?>
            </li>
             <li class="col-sm-2">
                <?php
                
                $invice_balance=$grand_total-$model->received_amount;
                echo CHtml::textField('invoice_balance',Yii::app()->numberFormatter->formatCurrency(($invice_balance), " "), array('class' => 'text-bold text-right','onkeypress' => 'return isNumberKey(event,this.value);',  'data-label' => 'Balance to Pay <span style="color:red;">*</span>','readonly'=>true)); ?>
            </li>
            <li class="col-sm-3">
                    <?php 
                    $model->receipt_type='';
                    echo $form->dropDownList($model, 'receipt_type', array('CH'=>'Cash','CA'=>'Card','CC' =>'Card + Cash'), array( 'data-label' => 'Receipt Type <span style="color:red;">*</span>', 'prompt' => 'Select','onchange'=>'showReceiptTypeDetails();'));?>
            </li>
             <li class="col-sm-2" id="li_received_cash_amount" style="display:none;">
                <?php
                $model->received_cash_amount='';
                echo $form->textField($model, 'received_cash_amount', array('class' => 'text-bold  text-right','onkeypress' => 'return isNumberKey(event,this.value);',  'data-label' => 'Cash Amount <span style="color:red;">*</span>'));
                //echo CHtml::textField('received_cash_amount','', array('class' => 'text-bold','onkeypress' => 'return isNumberKey(event,this.value);',  'data-label' => 'Cash Amount <span style="color:red;">*</span>')); ?>
            </li>
             <li class="col-sm-2"  id="li_received_card_amount" style="display:none;">
                <?php
                $model->received_card_amount='';
                echo $form->textField($model, 'received_card_amount', array('class' => 'text-bold  text-right','onkeypress' => 'return isNumberKey(event,this.value);',  'data-label' => 'Card Amount <span style="color:red;">*</span>'));
                //echo CHtml::textField('received_card_amount','', array('class' => 'text-bold','onkeypress' => 'return isNumberKey(event,this.value);',  'data-label' => 'Card Amount <span style="color:red;">*</span>')); ?>
            </li>
            <li class="col-sm-2" id="li_authorization" style="display:none;">
                <?php echo $form->textField($model, 'authorization_code', array('class' => 'text-bold',  'data-label' => 'Authorization Code<span style="color:red;">*</span>')); ?>
            </li>
        </ul>
    
</div>

<?php

    $cs = Yii::app()->getClientScript();

$cs->registerScript("autoCompleteProduct", "function autoCompleteProduct(field_id,frm)

		{

		var url = '" . Yii::app()->createUrl('quotation/GetProducts') . "'+'&frm='+frm;

				$('#'+field_id).autocomplete({

                minLength   : 1,

                source      : function (request, response) { autoCompleteSource(request, response,url) },

                focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},

                select          : function( event, ui ) {

                event.preventDefault();

                trigger_target_id  	=   $(event.target).attr('id');

				var product_id=ui.item.value; 	

                                var desc=ui.item.description; 

                                var unit_id=ui.item.unit_id;  

                                var unit_name=ui.item.unit_name;
                                var tax_percentage = 0;
                                if(ui.item.tax_code!=null){
                                    tax_percentage = ui.item.tax_code.percentage;
                                }

                                var arr_fields= field_id.split('_');

                                var model_name   = arr_fields[0];

                                var row_field  = arr_fields[1];   
                                
                                var item_type = ui.item.other;
                                
                                $('#product_'+row_field+'_inventorytype').val(item_type);       

                                $('#InvoiceItem_'+row_field+'_description').val(desc);

                                $('#InvoiceItem_'+row_field+'_unit').val(unit_name); 

                                $('#InvoiceItem_'+row_field+'_unit_id').val(unit_id);  

                                $('#InvoiceItem_'+row_field+'_product_id').val(product_id);
                                var Invoice_invoice_type_id  = $('#Invoice_invoice_type').val();  

                                if(product_id > 0){
                                    jQuery.ajax({
                                       'type': 'post',
                                       'dataType': 'json',
                                       'url': '" . Yii::app()->createUrl('invoice/getunitdrop') . "',
                                       'data': {'row_field' : row_field, 'product_id' : product_id},
                                       'cache': false,
                                       'success': function(data) {
                                           $('#unit_'+row_field).html(data.drop);
                                           return false;
                                       }
                                   });
                                }
                                
                                if(Invoice_invoice_type_id>0){
        
                                        jQuery.ajax({
                                                'dataType' : 'json',
                                              'type'  : 'post',
                                              'data'  : 'id='+Invoice_invoice_type_id,
                                              'url'  : $('#liveSite').val()+'index.php?r=masinvoicetype/getInvoiceTypeTax',
                                              'cache': false,
                                              'success':function(data){
                                                
                                                if(data.status=='success'){ 
                                                    if(item_type == '2'){  // itemtype = 2 means service items
                                                        $('#InvoiceItem_'+row_field+'_tax_vat_percentage').val(tax_percentage);
                                                        $('#check_tax_sales_vat_percentage_'+row_field).val(tax_percentage);
                                                        
                                                    }
                                                    else{
                                                        if(data.tax == 'Y'){
                                                            
                                                            $('#InvoiceItem_'+i+'_tax_vat_percentage').val(tax_percentage);
                                                                $('#check_tax_sales_vat_percentage_'+row_field).val(tax_percentage); 
                                                            }
                                                        else{
                                                            $('#InvoiceItem_'+i+'_tax_vat_percentage').val(0);
                                                           // $('#OrderItem_'+row_field+'_tax_vat_percentage').val(0);
                                                                $('#check_tax_sales_vat_percentage_'+row_field).val(tax_percentage);
                                                            }
                                                        }
                                                    
                                                }
                                                calculateExchangeInvoice($('#exchange_invoice_item_table'));
                                               }
                                            });
                                        
                                    }  

                            }

			})



		}", CClientScript::POS_HEAD);

$cs->registerScript("checkall" ,"function checkall()
        {
        $('#ckbCheckAll').click(function () {
            $('.checkBoxClass').prop('checked', $(this).prop('checked'));
        })
    }", CClientScript::POS_HEAD);
    
$cs->registerScript("calculateReverseInvoiceValue", " function calculateReverseInvoiceValue(id) {
    row_id   =   id.split('_')[1];
    var net_rate = $('#InvoiceItem_'+row_id+'_net_per_item').val();
    var tax =  $(this).find('[id $=_tax_vat_percentage]').val();
    if(tax > 0){
         tax_amount = (net_rate*100)/(100+tax);
    }else{
         var rate = net_rate;
    }    
    $('#InvoiceItem_'+row_id+'_rate').val(rate.toFixed(4));
    calculateExchangeInvoice($('#direct_invoice_item_table'),'rev');
  }", CClientScript::POS_HEAD);
  
$cs->registerScript("calculateExchangeInvoice", " function calculateExchangeInvoice(jQtable,frm) {
    formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
    var count,qty,rate,amount,net_amount,discount,costrate,deduction_percentage,deduction_percentage_amount,tot_after_discount;
    var total   =   0;
    var grand_total =   0;
    var vat_total = 0;
    var total_balance = 0;
    
    jQtable.find('tr:gt(0)').each(function() {
        net_amount = 0;  discount = 0;tot_after_discount=0;
        costrate = $(this).find('[id $=_costrate]').val();
        rate = $(this).find('[id $=_rate]').val();
        //net_per_item = rate*105/100;

        qty =   $(this).find('[id $=_quantity]').val();
        var tax =  $(this).find('[id $=_tax_vat_percentage]').val();
        var tax_amount  = 0;
        discount                =   $(this).find('[id $=_deduction_amount]').val();
        deduction_percentage    =   $(this).find('[id $=_deduction_percentage]').val();
        if(deduction_percentage!=undefined){
            deduction_percentage   =   deduction_percentage.replace(/%/,'');
            var deduction_percentage_amount = Number(deduction_percentage/100)*rate*qty;
        }
        tot_after_discount=((Number(rate)*Number(qty)) - Number(discount) -Number(deduction_percentage_amount));
        if(Number(qty)> 0)
        net_amount              =tot_after_discount*(100/(100+Number(tax)))/Number(qty);
        else
        net_amount              = 0;
        net_per_item            = net_amount;
        net_amount              =   (Number(net_amount)*Number(qty)).toFixed(2);
        /*if(discount!=undefined){
            count = discount.match(/%/g);
            discount   =   discount.replace(/%/,'');
            var value = Number(discount)/100;
        }
        if(isNumber(discount))
            discount  =  (count!==null && count.length>0) ? (Number(net_amount)*value) : discount;*/

        //net_amount -= discount;
        total   =   Number(total)+Number(net_amount);
        $(this).find('[id $=_amount]').val(net_amount);
        $(this).find('[id $=_deduction_amount]').val(discount);
        //if(frm!='rev'){
            $(this).find('[id $=_net_per_item]').val(Number(net_per_item).toFixed(2));
        //}
        if(net_amount > 0){
            if(tax > 0){
                 tax_amount = Number(tot_after_discount)*(Number(tax)/(100+Number(tax)));
            }else{
                 tax_amount = 0;
            }
            $(this).find('[id $=_tax_vat_amount]').val(Number(tax_amount).toFixed(2));
            grand_total += tax_amount;
            vat_total +=tax_amount;
            //alert(tax_amount);
        } 
    });
    other_additions    = 0;
    other_deductions =0;
    grand_total +=   (Number(total)   +   Number(other_additions));
    grand_total -=  Number(other_deductions);
     var receivedamount = $('#Invoice_received_amount').val();
    total_balance =   (Number(grand_total)   -   Number(receivedamount));
    $('.exchange_invoice_total').html(Number(total).toFixed(2));
     $('#invoice_totalamount').val(Number(grand_total).toFixed(2)).addClass('filled');
      $('#invoice_balance').val(Number(total_balance).toFixed(2)).addClass('filled');
    // $('#invoice_totalamount').val(Number(tax_amount).toFixed(2));
    $('.exchange_invoice_grand_total').html(Number(grand_total).toFixed(2));
    $('.exchange_invoice_vat_total').html(Number(vat_total).toFixed(2));
}", CClientScript::POS_HEAD);    
    
        
$cs->registerScript("removeExchangeInvoiceTableRow", " function removeExchangeInvoiceTableRow(jQtable,evt) {

            formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];

            var num_rows    =   jQtable.find('tr:gt(0)').length;

            if(num_rows>1){

            var tr  =   $(evt).parent().parent();

            if(isRowEmpty(tr)) {

                amount = $(evt).parents('tr').find('[id$=\"_amount\"]').val();
                //code to deduct tax amount

                tax_percentage = $(evt).parents('tr').find('[id$=\"_tax_vat_percentage\"]').val();
                var  tax_amount = (amount * tax_percentage) / 100;
                total_vat_amount =$('.'+formIdStarter+'_grand_total .vat_total_val').text();
                total_vat_amount=(Number(total_vat_amount)-Number(tax_amount)).toFixed(2);
                vat_total_val= $('.'+formIdStarter+'_grand_total .vat_total_val').text(Number(total_vat_amount).toFixed(2));

                //

                total =   $('.'+formIdStarter+'_total .total').text();

                total =   (Number(total)-Number(amount)).toFixed(2);

                $('.'+formIdStarter+'_total .total').text(total)

                gd_total =   $('.'+formIdStarter+'_grand_total .grandtotal').text();

                // gd_total =   (Number(gd_total)-Number(amount)).toFixed(2);
                //code to add tax amnt
                    gd_total =   (Number(total)+Number(total_vat_amount)).toFixed(2);
                //

                $('.'+formIdStarter+'_grand_total .grandtotal').text(gd_total);

                $(evt).parents('tr').remove();

                var i=0;

                jQtable.find('tr:gt(0)').each(function() { $(this).find('input,select,textarea,.errorMessage').each(function()

                {

                old_id   =   $(this).attr('id');

                new_id   =   old_id.replace(/\d+/,i);

                $(this).attr('id',new_id);

                old_name =   $(this).attr('name');

                if(old_name!==undefined) {

                    new_name =   old_name.replace(/\d+/,i);

                    $(this).attr('name',new_name);} });

                    $(this).find('td:first label').html(++i); }); }
                    
                    calculateExchangeInvoice($('#exchange_invoice_item_table'));

                    //adjustPopup();
                    //calculateemployeesalaryamount();
                    } else alert('Atleast one item needed here'); 
    
}", CClientScript::POS_HEAD
        );
        
    $cs->registerScript("showReceiptTypeDetails", " function showReceiptTypeDetails() {
    var type = $('#Invoice_receipt_type').val();
    if(type=='CA'){
        $('#li_authorization').show();
        $('#li_received_card_amount').show();
        $('#li_received_cash_amount').hide();
    }
    else if(type=='CH'){
        $('#li_authorization').hide();
        $('#li_received_cash_amount').show();
        $('#li_received_card_amount').hide();
    }
    else if(type=='CC'){
        $('#li_authorization').show();
        $('#li_received_card_amount').show();
        $('#li_received_cash_amount').show();
    }
    else{
        $('#li_authorization').hide();
        $('#li_received_card_amount').hide();
        $('#li_received_cash_amount').hide();
    }
 }", CClientScript::POS_HEAD);
        
        
        ?>
             