<?php

$form = $this->beginWidget('CActiveForm', array(
    'id' => 'paymenttype-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
// $payment_complete_status = $modelInvoice->payment_complete_status;

$grand_total =  number_format(Round($modelInvoice->grand_total, 3), 3);

?>
<ul class="clearfix form-ul material">


    <li class="col-sm-4">
        <?php



        echo $form->textfield($modelInvoice, 'grand_total', array('value' => $grand_total, 'class' => 'tooltipster', 'data-label' => 'Invoice Amount', 'readonly' => 'true'));
        echo $form->hiddenField($modelInvoice, 'id');
        echo $form->hiddenField($modelInvoice, 'customer_id');
        ?>
    </li>


    <li class="col-sm-12">
        <div id="div_project_type_detl">


            <div class="table-responsive">
                <table class="table table-hover table-bordered personal-task" id="tbl_payment_item">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Payment Type</th>
                            <th>Bank Name</th>
                            <th>Card No</th>
                            <th>Cheque No</th>
                            <th>Cheque Date</th>
                            <th>Amount</th>
                            <?php if ($modelInvoice->posted == "N") {
                            ?>
                                <th width="3%" class="text-center">
                                    <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addTablelist($('#tbl_payment_item'));"><i class="fa fa-plus"></i></a>
                                </th>
                            <?php  }
                            ?>
                        </tr>
                    </thead>
                    <tbody>

                        <?php
                        $k = 0;
                        $total = 0;

                        foreach ($receipt_list as $i => $Details) { ?>
                            <tr>

                                <td> <label><?php echo ($k + 1); ?> </label></td>
                                <td>
                                    <?php
                                    $modelAccPaymentMode = new AccPaymentMode();
                                    echo CHtml::dropDownList(
                                        "InvoicePayments[$i][payment_mode_id]",
                                        $Details->payment_mode_id,
                                        $modelAccPaymentMode->getAccPaymentModes(),
                                        array('prompt' => '--select--', 'class' => 'form-control')
                                    );
                                    ?>
                                </td>
                                <td><?php echo CHtml::textField("InvoicePayments[$i][bank_name]", $Details->bank_name, array('data-label' => 'Bank Name', 'class' => 'form-control')); ?></td>
                                <td><?php echo CHtml::textField("InvoicePayments[$i][card_no]", $Details->card_no, array('data-label' => 'Card No', 'class' => 'form-control')); ?></td>
                                <td><?php echo CHtml::textField("InvoicePayments[$i][cheque_no]", $Details->cheque_no, array('data-label' => 'Cheque No', 'class' => 'form-control')); ?></td>
                                <td>
                                    <?php
                                    $cheque_date = ($Details->cheque_date == '0000-00-00' || $Details->cheque_date == '30/11/-0001') ? "0000-00-00" : date('d/m/Y', strtotime($Details->cheque_date));
                                    echo CHtml::textField("InvoicePayments[$i][cheque_date]", $cheque_date, array('data-label' => 'Cheque Date', 'class' => 'form-control datepicker'));
                                    ?>
                                </td>
                                <td><?php echo CHtml::textField("InvoicePayments[$i][amount]", $Details->amount, array('data-label' => 'Amount', 'class' => 'form-control')); ?></td>

                                <?php if ($modelInvoice->posted == "N") {
                                ?>
                                    <td>
                                        <?php

                                        echo CHtml::link(
                                            '<i class="fa fa-times"></i>',
                                            'javascript:void(0);',
                                            array(
                                                'class' => 'btn btn-sm btn-danger',
                                                'id' => $i,
                                                'onclick' => 'removeTableitem($(\'#tbl_payment_item\'), this, this.id)',
                                                'title' => 'Remove this item'
                                            )
                                        );

                                        ?>
                                    </td>
                                <?php }
                                ?>
                            </tr>
                        <?php $k++;
                        } ?>
                        </tr>

                    </tbody>
                </table>
                <table class="table table-hover table-bordered table-nexted material_total">
                    <tr class="bg-total">
                        <td width="70%" class="text-right table_total_title">

                            <h2>Total</h2>
                        </td>
                        <td width="30%" class="text-right table_total ">
                            <h2 class="text-right total"><?php echo number_format(round($total, 3), 3); ?></h2>
                        </td>
                    </tr>

                </table>
                <?php if ($modelInvoice->posted == "Y") { ?>
                    <table class="table table-hover table-bordered table-nexted">
                        <tr class="">
                            <td width="70%" class="text-right table_total_title">

                                <h4>Posted To Accounts</h4>
                            </td>
                        </tr>
                    <?php } ?>

                    </table>
            </div>

        </div>

</ul>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="cust_close" data-dismiss="modal">Close</button>
    <?php

    if ($modelInvoice->posted == "N") {
        echo CHtml::ajaxSubmitButton('Save', Yii::app()->createUrl('invoice/SaveInvoicePayments'), array(
            'dataType' => 'json',
            'type' => 'post',
            'success' => 'function(data) {
                            $("#loader").hide();
                            $("#paymenttype-form .paymenttype-btn").prop("disabled", false);                      
                            $("#paymenttype-form .paymenttype-btn").addClass("btn-theme").removeClass("btn_loding");
                            if(data.status=="success"){  
                                t8.success("Saved Successfully!");
                                $(".x.close").click();
                                reloadTable("#tble_invoice");
                            }else{ 
                                $.each(data, function(key, val) {
                                    t8.error(""+val+""); 
                                }); 
                            } 
                        }',
            'beforeSend' => 'function(){
                            $("#loader").show();
                               $("#paymenttype-form .ledger-btn").prop("disabled", true);                      
                               $("#paymenttype-form .ledger-btn").addClass("btn_loding").removeClass("btn-theme"); 
                        }',
        ), array('id' => 'mybtn' . rand(), 'class' => 'paymenttype-btn btn btn-theme'));
    }
    ?>
</div>
<?php $this->endWidget(); ?>

<?php

$cs = Yii::app()->getClientScript();

$cs->registerScript("calculateInvoicepaymentValue", "
    function calculateInvoicepaymentValue(jQtable, frm) {
        var  amount;
        var total_amount = 0;
        jQtable.find('tr:gt(0)').each(function () {
            amount = $(this).find('[id $=_amount]').val();
           
            if (amount == '') {
                amount = 0;
            }
            total_amount += parseFloat(amount);
        });
        $('.total').html(Number(total_amount).toFixed(3));
    }", CClientScript::POS_HEAD);


$cs->registerScript("addTablelist", " function addTablelist(jQtable) {
        formId              =   jQtable.attr('id');
        formIdStarter       =   jQtable.attr('id').split(/_(.+)?/)[0];
        lastId = jQtable.find('tr:last input:first').attr('id');
        thenum = lastId.match(/\d+/g);
        newId = Number(thenum) + 1;
        var date = $('#InvoicePayments_'+thenum+'_cheque_date').val();

        newrow= jQtable.find('tr:last').clone();
        newrow.find('label:first').html(newId+1);
        newrow.attr('class',newId);
     

        newrow.find('.hasDatepicker').removeClass('hasDatepicker');
        newrow.find('.datetimepicker').siblings().remove();
        newrow.find('.datetimepicker').datetimepicker( 'destroy' );
        newrow.find('div,input,textarea,checkbox,td,select,.errorMessage,a,span').each(function() {
            this.id= this.id.replace(/\d+/,newId);
           if(!$(this).is(':checkbox'))
                this.value  = '';
            else
                $(this).prop('checked', false);
            (this.name!==undefined) ? this.name= this.name.replace(/\d+/,newId) : this.style  =   '';});
            jQtable.append(newrow);
        $('#InvoicePayments_'+newId+'_cheque_date').datetimepicker({format: 'DD/MM/YYYY'}).val(date);

}", CClientScript::POS_HEAD);

$cs->registerScript("removeTableitem", "
    function removeTableitem(jQtable, evt) {
        var formIdStarter = jQtable.attr('id').split(/_(.+)?/)[0];
        var num_rows = jQtable.find('tr:gt(0)').length;
        if (num_rows > 1) {
            var tr = $(evt).closest('tr');
            if (isRowEmpty(tr)) {
                var amount = tr.find('[id$=\"_amount\"]').val();
                var total = $('.total').html();
                var out_total = (Number(total) - Number(amount)).toFixed(3);
                $('.total').html(Number(out_total).toFixed(3));
                $(evt).parents('tr').remove();
                var i = 0;
                jQtable.find('tr:gt(0)').each(function () {
                    $(this).find('input, select, textarea, .errorMessage').each(function () {
                        var old_id = $(this).attr('id');
                        var new_id = old_id.replace(/\d+/, i);
                        $(this).attr('id', new_id);

                        var old_name = $(this).attr('name');
                        if (old_name !== undefined) {
                            var new_name = old_name.replace(/\d+/, i);
                            $(this).attr('name', new_name);
                        }
                    });
                    $(this).find('td:first label').html(++i);
                });
            }
        } else {
            alert('At least One item needed here');
        }
    }
", CClientScript::POS_HEAD);






?>