<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>
     <script>
     $(document).ready(function() {
         var table_id ="#tbl_raw_material_details";
         var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
             data.display_type = $("#display_type").val();
             return data;
         }).DataTable({
             scrollY         : "645px",
             pageLength      : 50,
             processing: true,
             columns:[
                 {className:"nw sl col-max-1"},
                 {className:"nw sl col-max-4"},
                 {className:"nw sl col-max-5"},
                 {className:"nw sl col-max-3"},
                 {className:"nw sl col-max-1 text-right"},
                 {className:"nw sl col-max-1"},
             ],
             ajax: {
                 url: "<?php  echo Yii::app()->createUrl('inventory/GetRawMaterialList') ?>",
                 type: "POST",
                 cache : false,
             },
             serverSide:     true,
             fixedColumns:   true,
             processing: true,
		 	"fnCreatedRow"  : function( nRow, aData, iDataIndex ){
         		$(nRow).addClass("context-menu");
     		},
     		"fnRowCallback" : function( nRow, aData, iDisplayIndex, iDisplayIndexFull){
         
         	$("#tbl_raw_material_details tbody").mousedown(function (e) {   
             $(this).contextMenu({
                 selector: ".context-menu",
                callback: function(key, options) {
             	var action_id = key;
					var data = table.row( this ).data();
					var id=data[0];
					var part_number = data[1];
					if(action_id == "edit"){
						loadPopupModal("inventory/create&view=raw_material_create&id="+id,"Raw Material - "+part_number ,"lg");
					}
         },
                 items: {
                	 <?php if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["rawmaterial_edit"])){ ?>
                     		"edit": {name: "Edit", icon: "edit"},
                     <?php } ?>
                 }
             }
             );
         });     
     }
     });
		
		
     });
        </script>

    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-tags"></i> Raw Materials
            <div class="pull-right">
                <?php  if (isset(Yii::app()->user->havePermissionOn['rawmaterial_add']) ||  Yii::app()->user->authorised_user == 1) {?>

<button class="btn btn-sm btn-theme" onclick="loadPopupModal('inventory/create&view=raw_material_create','Add Raw Material','lg')"> <i class="fa fa-plus"></i> ADD</button>
          <?php } ?>            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_raw_material_details">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Part No</th>
                            <th>Description</th>
                            <th>Brand</th>
                            <th>Total Qty</th>
                            <th>Unit</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>
