<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'inventory-batch-split-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));



?>
   <div class="panel-body">
  <div class="tab-content">

        <div class="tab-pane active">
             <div id ="div_service_item_details">
             
    <ul class="clearfix form-ul material">
        <li class="col-sm-3">
            <?php echo CHtml::textField('product_name','',array('class' => 'tooltipster', 'placeholder' => 'Please choose a product','data-label'=>'Part No <span style="color : red;">*</span>','onKeyup' => 'js:autoCompleteBatchSplitProduct(this.id,"batchsplit");')); ?>
            <?php echo CHtml::hiddenField('product_id'); ?>
        </li>
        <li class="col-sm-3">
            <?php echo CHtml::textField('batchno','',array('class' => 'tooltipster', 'placeholder' => 'Please choose Batch','data-label'=>'Batch<span style="color : red;">*</span>','onKeyup' => 'js:autoCompleteBatchSplitBatch(this.id,"batchsplit");')); ?>
        </li>
        <li class="col-sm-3">
            <input type="button" value="Search" onclick="loadProductDetails();return false;" class='plan-save-btn btn btn-theme' />
        </li>
        <li class="col-sm-3" id="total_qty_li" style="display: none;">
            <?php echo CHtml::textField('total_qty','',array('class' => 'tooltipster', 'placeholder' => '','data-label'=>'Total Qty','readonly'=>true)); ?>
        </li>
    </ul>

    <div class="table-responsive" id="batch_items_details">


</div>
<div class="modal-footer" id="footer_btn" style="display: none;">
    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
    	<?php 
        
        $url = Yii::app()->createUrl('inventory/saveBatchSplit');
        echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                    if(data.status=="success"){
                                         t8.success("Done");                                         
                                         $(".x.close").click();
                                         $("#loader").hide();
                                    } else { 
                                         $("#loader").hide();
                                         $.each(data, function(key, val) {
                                                t8.error(""+val+""); 
                                         }); 
                                    } 
                                    }',
                                    'beforeSend' => 'function(){
                                        
                                        var valid  = false;
                                        var totalQty = $("#total_qty").val();
                                        var sum_to_qty = 0;
                                        var err = [];
                                        var row_count  = $("#batchno_split_items_table").find("tr:gt(0)").length;
                                        for (i=0; i <row_count; i++){
                                            var qty  = parseFloat($("#StockLedger_"+i+"_quantity").val());
                                            if(qty>0){
                                                sum_to_qty +=qty;
                                            }
                                        }                                       
                                        if(totalQty != sum_to_qty){
                                            valid = false;
                                            err.push("Quantity mismatch for Item ");
                                        }
                                        else{
                                            valid  = true;
                                        }
                                        if(valid){
                                            return true;
                                            $("#loader").show();
                                        }else{
                                            $.each(err, function(key, val) {
                                                t8.error(""+val+""); 
                                            }); 
                                            return false;
                                        }
                                    }'


                    ), array('id' => 'mybtn' . rand(), 'class' => 'transfer-save-btn btn btn-theme'));
        

    ?>

    </div>
</div>


    </div>
    

<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();


$cs->registerScript("rowSplit", "function rowSplit(jQtable,evt,field_id) {   
                
                var parentTR  =   $(evt).parent().parent();                
                parentTR.clone().find('input').val('').end().insertAfter(parentTR);
                
                var i=0;
                    jQtable.find('tr:gt(0)').each(function() { 
                        $(this).find('input,textarea,.errorMessage,select,a').each(function(){
                            old_id   =   $(this).attr('id');
                            new_id   =   old_id.replace(/\d+/,i);
                            $(this).attr('id',new_id);
                            old_name =   $(this).attr('name');
                            if(old_name!==undefined) {
                            new_name =   old_name.replace(/\d+/,i);
                            $(this).attr('name',new_name);} 
                        });
                    $(this).find('td:first label').html(++i); 
                });
                var arr_fields = field_id.split('_');
                var row_field  = arr_fields[1];
                var currentrow     = parseInt(row_field);
                var newrow     = parseInt(row_field)+1;
                
                var file_id  = $('#StockLedger_'+currentrow+'_file_id').val();
                var header_id  = $('#StockLedger_'+currentrow+'_header_id').val();
                var header_item_id  = $('#StockLedger_'+currentrow+'_header_item_id').val();
                var customer_vendor_id  = $('#StockLedger_'+currentrow+'_customer_vendor_id').val();
                var customer_vendor_name  = $('#StockLedger_'+currentrow+'_customer_vendor_name').val();
                var product_id  = $('#StockLedger_'+currentrow+'_product_id').val();
                var product_name  = $('#StockLedger_'+currentrow+'_product_name').val();
                var product_description  = $('#StockLedger_'+currentrow+'_product_description').val();
                var brand_id  = $('#StockLedger_'+currentrow+'_brand_id').val();
                var brand_name  = $('#StockLedger_'+currentrow+'_brand_name').val();
                var warehouse_id  = $('#StockLedger_'+currentrow+'_warehouse_id').val();
                var warehouse_name  = $('#StockLedger_'+currentrow+'_warehouse_name').val();
                var rack_id  = $('#StockLedger_'+currentrow+'_rack_id').val();
                var rack_name  = $('#StockLedger_'+currentrow+'_rack_name').val();
                var bin_id  = $('#StockLedger_'+currentrow+'_bin_id').val();
                var bin_name  = $('#StockLedger_'+currentrow+'_bin_name').val();
                var unit_id  = $('#StockLedger_'+currentrow+'_unit_id').val();
                var unit_name  = $('#StockLedger_'+currentrow+'_unit_name').val();
                var unit_factor  = $('#StockLedger_'+currentrow+'_unit_factor').val();
                var available_status  = $('#StockLedger_'+currentrow+'_available_status').val();
                var serial_no  = $('#StockLedger_'+currentrow+'_serial_no').val();
                var manufacturing_date  = $('#StockLedger_'+currentrow+'_manufacturing_date').val();
                var cost_price  = $('#StockLedger_'+currentrow+'_cost_price').val();
                var master_stock_ledger_id  = $('#StockLedger_'+currentrow+'_master_stock_ledger_id').val();
                var expiry_date  = $('#StockLedger_'+currentrow+'_expiry_date').val();
                
            
                
                $('#StockLedger_'+newrow+'_file_id').val(file_id);
                $('#StockLedger_'+newrow+'_header_id').val(header_id);
                $('#StockLedger_'+newrow+'_header_item_id').val(header_item_id);
                $('#StockLedger_'+newrow+'_customer_vendor_id').val(customer_vendor_id);
                $('#StockLedger_'+newrow+'_customer_vendor_name').val(customer_vendor_name);
                $('#StockLedger_'+newrow+'_product_id').val(product_id);
                $('#StockLedger_'+newrow+'_product_name').val(product_name);
                $('#StockLedger_'+newrow+'_product_description').val(product_description);
                $('#StockLedger_'+newrow+'_brand_id').val(brand_id);
                $('#StockLedger_'+newrow+'_brand_name').val(brand_name);
                $('#StockLedger_'+newrow+'_warehouse_id').val(warehouse_id);
                $('#StockLedger_'+newrow+'_warehouse_name').val(warehouse_name);
                $('#StockLedger_'+newrow+'_rack_id').val(rack_id);
                $('#StockLedger_'+newrow+'_rack_name').val(rack_name);
                $('#StockLedger_'+newrow+'_bin_id').val(bin_id);
                $('#StockLedger_'+newrow+'_bin_name').val(bin_name);
                $('#StockLedger_'+newrow+'_unit_id').val(unit_id);
                $('#StockLedger_'+newrow+'_unit_name').val(unit_name);
                $('#StockLedger_'+newrow+'_unit_factor').val(unit_factor);
                $('#StockLedger_'+newrow+'_available_status').val(available_status);
                $('#StockLedger_'+newrow+'_serial_no').val(serial_no);
                $('#StockLedger_'+newrow+'_manufacturing_date').val(manufacturing_date);
                $('#StockLedger_'+newrow+'_cost_price').val(cost_price);
                $('#StockLedger_'+newrow+'_master_stock_ledger_id').val(master_stock_ledger_id);
                $('#StockLedger_'+newrow+'_expiry_date').datetimepicker({format: 'DD/MM/YYYY'});
                
                

}", CClientScript::POS_HEAD); 

$cs->registerScript("loadProductDetails", "function loadProductDetails(){
        
        var product_id = $('#product_id').val();        
        var batchno    = $('#batchno').val(); 
        
        $('#batch_items_details').html('');
        $('#total_qty_li').hide();  
        $('#footer_btn').hide(); 
        if(batchno!='' & product_id>0){
            
            $('#loader').show();
            var pars = 'batchno='+batchno+'&product_id='+product_id;
            var url = '" . Yii::app()->createUrl('inventory/fetchBatchNoItems') . "';       
                 
            jQuery.ajax({
                'type': 'post',
                'data': pars,
                'dataType' : 'json', 
                'url': url,
                'cache': false,
                'success': function(data){
                    $('#loader').hide();
                    $('#batch_items_details').show();
                    $('#batch_items_details').html(data.table); 
                    $('#total_qty_li').show(); 
                    $('#total_qty').addClass('filled');
                    $('#total_qty').val(data.total_qty); 
                    $('#footer_btn').show(); 
                                   
                }
            });
        }
        else{
            t8.error('Please fill all mandatory fields');
        }
         }", CClientScript::POS_HEAD);




$cs->registerScript("autoCompleteBatchSplitProduct", "function autoCompleteBatchSplitProduct(field_id,frm)
    {
        
	var url = '" . Yii::app()->createUrl('iwarehouse/GetRackBinProduct') . "'+'&frm='+frm;

		$('#'+field_id).autocomplete({

                    minLength   : 1,

                    source      : function (request, response) { autoCompleteSource(request, response,url) },

                    focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},

                    select          : function( event, ui ) {

                        event.preventDefault();

                        trigger_target_id  	=   $(event.target).attr('id');
                        var part_num=ui.item.product_id;
                        $('#product_id').val(part_num);
                    }

		});
    }", CClientScript::POS_HEAD);
    
    $cs->registerScript("autoCompleteBatchSplitBatch", "function autoCompleteBatchSplitBatch(field_id,frm){
        
        var product_id  = $('#product_id').val();
        if(product_id>0){
            var url = '" . Yii::app()->createUrl('inventory/GetProductBatchNo') . "'+'&frm='+frm+'&product_id='+product_id;
            $('#'+field_id).autocomplete({
                minLength   : 1,
                source      : function (request, response) { autoCompleteSource(request, response,url) },
                focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
                select          : function( event, ui ) {
                    event.preventDefault();
                    trigger_target_id  	=   $(event.target).attr('id');
                }
            });
        }
        else{
            $('#batchno').val();
            t8.error('Please select product');
        }
    }", CClientScript::POS_HEAD);


        
?>    