<script>
    function Disable(id, status) {
        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true) {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=industry/Disable',
                'cache': false,
                'success': function (data) {
                    if (data.status == 'fail') {
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_industry_details').DataTable().ajax.reload()
                        t8.success(' Success!');
                    }
                }
            });
        }


    }
</script>
<script>
    var imageBase64Logo = null;
    $(document).ready(function () {
        var table_id = "#tbl_industry_details";
        table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            //scrollY: "450px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('industry/GetList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                //console.log(aData);
                if (aData[2] == "Y") {
                    $("td", nRow).addClass("bg-payment");

                } else {
                    $("td", nRow).addClass("bg-test");
                }
                if (aData[4].status == "N") {
                    $("td", nRow).addClass("bg-danger");
                }
                AddContextMenu(nRow, aData);
            }
        });
    });

    function AddContextMenu(row, datas) {
        var mas_edit = 0;
        var mas_disable = 0;

        <?php if (isset(Yii::app()->user->havePermissionOn['cus_master_industry_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            mas_edit = 1;
        <?php } ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['cus_master_industry_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            mas_disable = 1;
        <?php } ?>

        // Build menu items dynamically
        var menuItems = {};

        <?php if (isset(Yii::app()->user->havePermissionOn['cus_master_industry_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            menuItems.edit = {
                name: "Edit",
                icon: "edit",
                accesskey: "e",
                callback: function () {
                    loadPopupModal("industry/create&id=" + datas[4].id, datas[4].code, "lg");
                }
            };
        <?php } ?>

        <?php if (isset(Yii::app()->user->havePermissionOn['cus_master_industry_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            menuItems.Disable_Enable = {
                name: (datas[4].status == "Y") ? "Disable" : "Enable",
                icon: "edit",
                accesskey: "d",
                callback: function () {
                    Disable(datas[4].id, datas[4].status);
                },
                disabled: function (key, opt) {
                    // disable if already active or other condition
                    if (String(datas[2]).trim().toUpperCase() === 'Y') {
                        return true;
                    }
                    return false;
                }
            };
        <?php } ?>

        // Attach context menu only if at least one menu item exists
        if (Object.keys(menuItems).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: menuItems
            });
        }
    }

</script>

<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-industry"></i> -->
        Industry
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['cus_master_industry_add']) || Yii::app()->user->authorised_user == 1) { ?>

                <a class="ad-btn" onclick="loadPopupModal('industry/create','Add New Industry','lg')" title="Add">
                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                        class="pluss-ad">
                        <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                        <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                        <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                    </svg>
                </a>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_industry_details"
                style="font-size:13px;">
                <thead>
                    <tr>
                        <th>SI No</th>
                        <th>Industry Name</th>

                    </tr>
                </thead>

            </table>
        </div>
    </div>
</section>