<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'hiring-transfer-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>
            <ul class="clearfix form-ul material">
                <li class="col-sm-2 m-select">
                 <?php echo $form->dropDownList($model,'from_warehouse_id',MasInventoryWarehouse::getWarehouses(),array('class' => '','data-label'=>'From Warehouse <span style="color:red">*</span>','empty'=>'--Select--')); ?>
                 <?php echo $form->hiddenField($model, 'id'); ?>
                </li>
                <!--,'onchange'=>'getid()'-->
                <div id="div_towarehouse">
                    <li class="col-sm-2"  id="to_ware_house_data">
                     <?php echo $form->dropDownList($model,'to_warehouse_id',MasInventoryWarehouse::getHiringWarehouse(),array('class' => '','data-label'=>'To Warehouse <span style="color:red">*</span>')); ?>
                    </li>
                </div>
                <li class="col-sm-3">
                 <?php echo $form->textField($model,'reference',array('class' => 'tooltipster', 'title' => 'Reference','data-label'=>'Reference')); ?>
                </li>
                <li class="col-sm-2">
                 <?php echo $form->textField($model,'transfer_date',array('class' => 'datepicker', 'title' => 'Transfer Date','data-label'=>'Transfer Date <span style="color:red">*</span>','value' => date('d/m/y'))); ?>
                </li>
                <li class="col-sm-3">
                 <?php echo $form->textArea($model,'direct_transfer_description',array('class' => 'tooltipster', 'title' => 'Description','data-label'=>'Description')); ?>
                </li>
            </ul>
          
<?php

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

?>
    <div class="table-responsive">
        <table class="table table-hover table-bordered personal-task" id="transfer_item_table">
            <tr>
                <th>No</th> 
                <th>Item</th>
                <th>Description</th>
                <th>Available Qty</th>
                <th>Transfer Qty</th>
                <th>Unit</th>
                <th class="text-center">
                    <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addTableRow($('#transfer_item_table'));"><i class="fa fa-plus"></i></a>
                </th>

            </tr>

            <?php

        foreach ($model_items as $i => $modeltransfer){?>

                <tr>

                    <td><label><?php echo ($i+1); ?></label></td>

                    <td> 
                        <?php  
                        $modeltransfer->item_name=$modeltransfer->stock->part_number;
                        echo $form->textField($modeltransfer, "[" . $i . "]item_name", array('class'=>'tooltipster go', 'placeholder' => 'Type & Select','onKeyup' => 'js:autoCompleteProduct(this.id,"transfer");','title' => 'Select product' )); ?>
                        
                        <?php echo $form->hiddenField($modeltransfer, "[" . $i . "]id"); ?>
                        <?php echo $form->hiddenField($modeltransfer, "[" . $i . "]product_id"); ?>
                        <?php echo $form->error($modeltransfer, "[" . $i . "]id"); ?>
                        <?php ($modeltransfer->unit > 0) ? $factor = $modeltransfer->unitdetails->factor : $factor = 1;  ?>
                        <?php echo CHtml::hiddenField("InventoryHiringTransferItem[" . $i . "][factor]",$factor); ?>

                    </td>
                        <td>
                            <?php echo $form->textArea($modeltransfer, "[" . $i . "]item_description", array( 'class' => 'tooltipster desc go',  'title' => 'Add Description here'));  ?>
                            <?php echo $form->error($modeltransfer, "[" . $i . "]item_description"); ?>

                        </td>
                        <td>
                            <?php echo $form->textField($modeltransfer, "[" . $i . "]available_qty", array('class' => 'qty go cell-center text-right','readonly'=>true)); ?>
                            <?php echo $form->error($modeltransfer, "[" . $i . "]available_qty"); ?> 
                        </td>
                        <td>
                            <?php echo $form->textField($modeltransfer, "[" . $i . "]transfer_qty", array('class' => 'qty go cell-center text-right','onkeypress'=>'return isPositiveNumber(event)')); ?>
                            <?php echo $form->error($modeltransfer, "[" . $i . "]transfer_qty"); ?> 
                        </td>
                        <td id="unit_<?php echo $i; ?>">
                             <?php 
                               ($modeltransfer->product_id > 0) ? $data = UnitOfMeasurement::getUnits($modeltransfer->product_id) : $data = array();
                             ?>
                             <?php echo $form->dropdownlist($modeltransfer, "[" . $i . "]unit",$data, array('class'=>'qty go')); ?>
                             
                        </td>
                       
                        <td class="text-center nw" width="1%">
                          <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','onclick' => 'rmRow($(\'#transfer_item_table\'),this,this.id)', 'title' => 'Remove this item','id'=>'ProductLocation_'.$i)); ?>
                    </td>
                
                </tr>
        <?php }?>
                
        </table>
    </div>
<div class="modal-footer">
<button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
    	<?php 
        if($type!= 'view'){
        $url = Yii::app()->createUrl('hiringtransfer/SaveTransfer');
        echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                    if(data.status=="success"){  
                                         t8.success("Tansfer No. "+data.id+" Saved Successfully!");
                                         $(".x.close").click();
                                         $("#loader").hide();
                                         $("#pk_li").click();
                                         reloadTable("#tbl_hiring_transfer_details");
                                         reloadTable("#tbl_packing_list");
                                    } else { 
                                         $("#loader").hide();
                                         $.each(data, function(key, val) {
                                                t8.error(""+val+""); 
                                         }); 
                                    } 
                                    }',

                                    'beforeSend' => 'function(){                                        
                                        $(".toast8-error").hide();
                                        $("#loader").show();
                                                                         
                        }'

                    ), array('id' => 'mybtn' . rand(), 'class' => 'transfer-save-btn btn btn-theme'));
        }

    ?>

    </div>
<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("getTowareHouse", " function getTowareHouse(from_id) {
    if(from_id>0){
        $('#stock_details_table').html('');
    }    
    jQuery.ajax({
        'dataType':'json', 
        'type': 'post',
        'url': '" . Yii::app()->createUrl('iwarehouse/getTowarehouseLocation') . "',
        'data': {'from_id':from_id},
        'cache': false,
        'success': function(data) {            
            $('#to_ware_house_data').html(data.towarehouse);
        }
    });

}", CClientScript::POS_HEAD);

?>
       
<?php 
$cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompleteProduct", "function autoCompleteProduct(field_id,frm)
{

      var frm_warehouse_id = $('#InventoryHiringTransfer_from_warehouse_id').val();
      if(frm_warehouse_id==''){
          t8.error('Please select from warehouse'); 
          $('#'+field_id).val('');
      }
      else{
        var url = '" . Yii::app()->createUrl('iwarehouse/GetProducts') . "'+'&frm='+frm+'&frm_warehouse_id='+frm_warehouse_id;
        $('#'+field_id).autocomplete({
            minLength   : 1,
            source      : function (request, response) { autoCompleteSource(request, response,url) },
            focus       : function( event, ui ) { $(this).val((ui.item.part_number)); return false;},
            select          : function( event, ui ) {
                event.preventDefault();
                trigger_target_id   =   $(event.target).attr('id');
                var product_id=ui.item.value;
                var id=ui.item.value;
                var desc=ui.item.description;
                var quantity=ui.item.total_q;
                var available_qty=ui.item.other;
                if(quantity == null){
                    quantity=0;
                }
                var unit_id=ui.item.unit_id;
                var unit_name=ui.item.unit_name;
                var arr_fields= field_id.split('_');
                var model_name   = arr_fields[0];
                var row_field  = arr_fields[1];
                $('#InventoryHiringTransferItem_'+row_field+'_item_description').val(desc);
                $('#InventoryHiringTransferItem_'+row_field+'_unit_id').val(unit_id); //for showing hidden field
                $('#InventoryHiringTransferItem_'+row_field+'_unit').val(unit_name); //FOR SHOWING UNIT NAME
                $('#InventoryHiringTransferItem_'+row_field+'_product_id').val(product_id);
                $('#InventoryHiringTransferItem_'+row_field+'_product_id').val(id);
                $('#InventoryHiringTransferItem_'+row_field+'_available_qty').val(available_qty);
                if(product_id > 0){
                    jQuery.ajax({
                       'type': 'post',
                       'dataType': 'json',
                       'url': '" . Yii::app()->createUrl('iwarehouse/getunitdrop') . "',
                       'data': {'row_field' : row_field, 'product_id' : product_id,'type' : 'HT'},
                       'cache': false,
                       'success': function(data) {
                           $('#unit_'+row_field).html(data.drop);
                           return false;
                       }
                   });
                }
               
            }

        })
        
  }
       

    }", CClientScript::POS_HEAD);

 ?>
<?php   
    $cs = Yii::app()->getClientScript();
    $cs->registerScript("FetchData" ,"function FetchData(Qty,field_id,event)
    {
        if (event.keyCode == 13) {

            event.preventDefault();
            var arr_fields   = field_id.split('_');
            var model_name   = arr_fields[0];
            var row_field    = arr_fields[1];
            
            var from_warehouse = $('#InventoryDirectTransfer_from_warehouse_id').val();
            var to_warehouse = $('#InventoryDirectTransfer_to_warehouse_id').val();
            var product_id = $('#InventoryHiringTransferItem_'+row_field+'_product_id').val();
            var rows = $('#table-stock-details').find('tr:gt(0)').length;
            
            if(rows>0){
                var lastRowId = $('#table-stock-details').find('tr:last input:first').attr('id');
                var split_id  = lastRowId.match(/\d+/g);
                var rows   = Number(split_id);
                rows  = rows+1;
           }

            if(from_warehouse > 0 && to_warehouse > 0){
                if(from_warehouse === to_warehouse){
                    t8.error('Choose Distinct Warehouses!');
                    return false;
                }else{
                    var i=0;
                    var products = [];
        
                    for (i=0; i<= rows; i++){
                        try{
                            if($('#Data_'+i+'_product_id').val() > 0 && products.includes($('#Data_'+i+'_product_id').val()) === false)
                                products.push($('#Data_'+i+'_product_id').val());
                        }catch(e){}
                    } 
                    
                    var sum_qty  = 0;
                    $('#table-stock-details').find('tr.transfer_pro_'+product_id).remove();
                    if(products.includes(product_id)){
                        
                        for (j=0; j<= rows; j++){
                            
                            if($('#InventoryHiringTransferItem_'+j+'_product_id').val() == product_id & $('#InventoryHiringTransferItem_'+j+'_transfer_qty').val() >0){
                                sum_qty+=parseInt($('#InventoryHiringTransferItem_'+j+'_transfer_qty').val());
                                
                            }
                        }
                        Qty  = sum_qty;
                    }
                    
                    //if(products.includes(product_id))
                        //return false;
                    //else{
                       
                            if(product_id > 0 && Qty > 0){
                                
                                jQuery.ajax({
                                    'type': 'post',
                                    'url': '" . Yii::app()->createUrl('iwarehouse/getStockDetails') . "',
                                    'data': {'product_id' : product_id, 'Qty' : Qty, 'length' : rows, 'from_warehouse' : from_warehouse, 'to_warehouse' : to_warehouse},
                                    'cache': false,
                                    'success': function(data) {
                                        $('#div_stock').show();
                                        if(data != '')
                                            $('.no-data-tr').remove(); 
                                        $('#stock_details_table').append(data);
                                        return false;
                                    }
                                });
                            }
                        return false;
                    }
               // }
            }else{
                t8.error('Choose Warehouses!');
                return false;
            }
        }
    }", CClientScript::POS_HEAD);

    $cs->registerScript("verifyQty" ,"function verifyQty(field_id,qty)
    {
    
         if(parseInt(qty) > 0){
            var arr_fields= field_id.split('_');
            var model_name   = arr_fields[0];
            var row_field  = arr_fields[1];   
            
            var max_qty = parseInt($('#Data_'+row_field+'_qty_available').val());
           
            if(parseInt(qty) > max_qty){
                $('#Data_'+row_field+'_picked_qty').val('');
            }

          

        }
        
    }", CClientScript::POS_HEAD);
    
     $cs->registerScript("rmRow ", "function rmRow(jQtable,evt,field_id) {
            
            var arr_fields= field_id.split('_');
            var row_field=arr_fields[1];
            var rows = $('#table-stock-details').find('tr:gt(0)').length;
            var pro_id = $('#InventoryHiringTransferItem_'+row_field+'_product_id').val();
            var num_rows    =   jQtable.find('tr:gt(0)').length;
            if(num_rows>1){
                $(evt).parents('tr').remove();
                for (i=0; i<= rows; i++){
                    try{
                        if($('#Data_'+i+'_product_id').val()  === pro_id){
                                $('.pro'+pro_id).remove();
                        }

                    }catch(e){}
                } 
                autoarrange();
            }else{
                alert('Atleast one item needed here','Alert');
            }
                
        };", CClientScript::POS_HEAD);
     
         
    $cs->registerScript("autoarrange", "function autoarrange(){                                
                    var i=0;
                   $('#table-stock-details').find('tr:gt(0)').each(function() {       
                            $(this).find('input,tr,select,textarea,.errorMessage').each(function()
                            {                   
                                old_id   =   $(this).attr('id');
                                new_id   =   old_id.replace(/\d+/,i);
                                $(this).attr('id',new_id);
                               
                                old_name =   $(this).attr('name');
                                if(old_name!==undefined) {
                                    new_name =   old_name.replace(/\d+/,i);
                                    $(this).attr('name',new_name);
                                } 
                            });
                            $(this).find('td:first label').html(++i); 
                    });         
    }", CClientScript::POS_HEAD);

    $cs->registerScript("getFactor" ,"function getFactor(field_id,value)
    {
        var arr_fields= field_id.split('_');
        var model_name   = arr_fields[0];
        var row_field  = arr_fields[1];   
        jQuery.ajax({
            'type': 'post',
            'url': '" . Yii::app()->createUrl('iwarehouse/GetFactor') . "',
            'data': {'value' : value},
            'cache': false,
            'success': function(data) {
                $('#InventoryHiringTransferItem_'+row_field+'_factor').val(data);
                return false;
            }
        });
        
    }", CClientScript::POS_HEAD);
    
        
   