<!DOCTYPE html>
<html>
    <head>
        <title>Stock Ledger</title>
    </head>
    <body>
    
        <div class="heading">
            <div class="logo col-6">
                <img src="images/pdf/logo.png">
          </div> 
            <div class="col-12 text-center" style="margin: 0 auto;">
                <h1><u>STOCK STATE</u></h1>
            </div>
            <div class="col-12">
                    <div class="details-box">

                        <table class="table" style="width:100%">
                            <?php
                            if ( $to_date != '') {
                            ?>
                                <tr>
                                    <td><b>As on date</b></td>
                                    <td>
                                        <?php echo date('d/m/Y', strtotime($to_date)); ?>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                            <?php
                            if ( $generic_id != '') {
                                $modelGeneric  = MasGeneric::model()->findByPk($generic_id);
                            ?>
                                <tr>
                                    <td><b>Generic</b></td>
                                    <td>
                                        <?php echo $modelGeneric->generic_name; ?>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                            <?php
                            if($brand_id != '') {
                                $modelBrand  = ProductClass::model()->findByPk($brand_id);
                            ?>
                                <tr>
                                    <td><b>Brand /Class</b></td>
                                    <td>
                                        <?php echo $modelBrand->product_class; ?>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                        </table>


                </div>
            </div>
        </div>        
        
        <div class="clearfix"></div>
        <div class="table-body">
            <table class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                       <th>No</th>
                        <th>Part Number</th>
                        <th>Description</th>
                        <th>Generic</th> 
                        <th>Brand /Class</th>
                        <th>Serial No</th>
                        <th>Batch No</th>
                        <th>Expiry Date</th>
                        <th>Quantity</th>
                        <th>Rate</th>                        
                        <th>Value</th>
                    </tr>
                </thead>
                <tbody>
                    <?php  
                            $total = 0;
                            foreach ($model as $row) { 
                                $eachTotal = round(($row['quantity'] * $row['rate']), 4) ;
                                $total +=  $eachTotal;
                                
                                 $part_number="";
                                $description="";
                                $generic_name="";
                                $brand_name = "";
                                $row_show_no="";
                                $product_no="";
                                if($product_id==$row['product_id']){
                                    $class_repeat='yes';
                                    $product_id=$row['product_id'];
                                    $part_number="";
                                    $description="";
                                    $generic_name="";
                                    $brand_name="";
                                    $row_show_no="";
                                    $product_no = "";
                                }
                                else{
                                    $product_id=$row['product_id'];
                                    $product_no=$product_id;
                                    $part_number=$row['part_number'];
                                    $description = $row['description'];
                                    $generic_name=$row['generic_name'];
                                    $brand_name = $row['brand'];
                                    $row_no=$row_no+1;
                                    $row_show_no=$row_no;
                                }
                                                
                                
                                
                        ?>
                        <tr>
                                                    <td><?php echo $product_no; ?></td> 
                                                    <td><?php echo $part_number; ?></td>
                                                    <td><?php echo $description; ?></td>
                                                    <td><?php echo $generic_name; ?></td>
                                                    <td><?php echo $brand_name; ?></td>
                                                    <td><?php echo $row['serial_no'] ?></td>
                                                    <td><?php echo $row['batch_no'] ?></td>
                                                    <td><?php echo ($row['expiry_date']!="0000-00-00")?date("d/m/Y",strtotime($row['expiry_date'])):""; ?></td>
                                                    <td><?php echo Yii::app()->numberFormatter->formatCurrency($row['quantity'],""); ?></td>
                                                    <td><?php echo Yii::app()->numberFormatter->formatCurrency((round($row['rate'],2)),""); ?></td>                                                    
                                                    <td class="text-right"><?php echo number_format((float)$eachTotal, 2, '.', '');; ?></td>
                                                </tr>
                        <?php
                     }
                    ?>

                    <tr>
                        <td colspan="10" class="text-right"><b>Total</b></td>
                        <td  class="text-right"><b><?php echo number_format((float)$total, 2, '.', ''); ?></b></td>
                    </tr>
                </tbody>
            </table>
        </div>
       
        <htmlpagefooter name="myfooter">


<div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
    <?php
              date_default_timezone_set("Asia/Dubai");
             echo date('d/m/Y')." ".date("h:i:sa"); ?>
</div>


    <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
         <div style="text-align:center;width:100%">
            <b><?= Yii::app()->user->footer_line_1 ?></b><br>
            <?= Yii::app()->user->footer_line_2 ?>
        </div>
        <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
    </div>
</htmlpagefooter>
</body>

</html>
