<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head ">
        Operator Wage Sheet
    </div>
    <?php
    $model_operator = Employee::model()->findByPK($employee_id);
    ?>
    <div class="panel-body">
        <div class="table-responsive">
            <table class="table table-fixed table-bordered table-primary">
                <thead>
                    <tr>
                        <th class="text-center tbl-iw nw" rowspan="2">No</th> 
                        <th class="text-center tbl-iw nw" rowspan="2">Name</th> 
                        <th class="text-center tbl-iw nw" rowspan="2">MOL ID</th>  
                        <th class="text-center tbl-iw nw" colspan="4"><?php echo HrGenerelSettings::getMonthName($month).'-'.$year; ?></th>
                    </tr>
                    <tr>
                        <th class="text-center tbl-iw nw">WPS</th>  
                        <th class="text-center tbl-iw nw">DA</th>  
                        <th class="text-center tbl-iw nw">OT</th>
                        <th class="text-center tbl-iw nw">Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition='isActive="Y"';
                    if ($employee_id != '') {
                        $condition .= ' AND id= "' . $employee_id . '"';
                    }
                    $model_employee = Employee::model()->findAll(array('condition' =>$condition));
                    $arr_employee=array();
                    foreach ($model_employee as $key => $value) {
                        $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d")]=$value['id'];
                    }
                    ksort($arr_employee); 
                    $k=1;
                    if(count($arr_employee)>0){
                        $total_da=$total_ot=$grand_total=0.00;
                        foreach ($arr_employee as $each) {
                            $model_employee = Employee::model()->findByPK($each);
                          //Data from Employee Attendance
                            $model_attendance = EmployeeAttendance::model()->with('siteovertime')->find(array('select'=>'sum(daily_allowance) as daily_allowance,sum(total_overtime_amount) as total_overtime_amount','condition' =>'MONTH(work_date)="'.$month.'" and YEAR(work_date)="'.$year.'" and t.employee_id="'.$each.'"'));
                            if($model_attendance->daily_allowance>0){
                                $total_da+=$model_attendance->daily_allowance;
                                $total_ot+=$model_attendance->total_overtime_amount;
                                $grand_total+=$model_attendance->daily_allowance+$model_attendance->total_overtime_amount;
                    ?>
                    <tr>       
                        <td><?php  echo $k;?></td>
                        <td><?php  echo $this->ciphertext($model_employee->first_name,"d").' '.$this->ciphertext($model_employee->last_name,"d");?></td>
                        <td><?php  echo $model_employee->personal_file_no;?></td>
                        <td></td>
                        <td class="text-right"><?php  echo Yii::app()->numberFormatter->formatCurrency($model_attendance->daily_allowance, " ");?></td>
                        <td class="text-right"><?php  echo Yii::app()->numberFormatter->formatCurrency($model_attendance->total_overtime_amount, " ");?></td>
                        <td class="text-right"><?php  echo Yii::app()->numberFormatter->formatCurrency($model_attendance->daily_allowance+$model_attendance->total_overtime_amount, " "); ?></td>
                    </tr>
                    <?php 
                        $k++;
                            }
                        }
                        ?>
                    <tr style="text-align: center; background-color: lemonchiffon;">
                            <td colspan="3" class="text-right text-bold">Total</td>
                            <td></td>
                            <td class="text-right"><b>
                               <?php echo Yii::app()->numberFormatter->formatCurrency($total_da," "); ?></b>
                            </td>
                            <td class="text-right"><b>
                               <?php echo Yii::app()->numberFormatter->formatCurrency($total_ot," "); ?></b>
                            </td>
                            <td class="text-right"><b>
                               <?php echo Yii::app()->numberFormatter->formatCurrency($grand_total," "); ?></b>
                            </td>
                        </tr>
                    <?php
                    }
                    ?>
                </tbody>
            </table>
            <br>
            <div class="btn-wrap text-center">
                <button type="button" class="btn btn-theme" onclick="exceloperatorwagesheet();">Export Excel</button>			  
            </div>
        </div>
    </div>
</div>
</div><?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("exceloperatorwagesheet", "function exceloperatorwagesheet(){    
    var employee_id = $('#operatorwagesheet_employee_id').val();
    var month = $('#operatorwagesheet_month').val();
    var year= $('#operatorwagesheet_year').val(); 
    window.open($('#liveSite').val()+'index.php?r=hiringreports/exceloperatorwagesheet&employee_id='+employee_id+'&month='+month+'&year='+year, '_blank');
}", CClientScript::POS_HEAD);
