<script type="text/javascript">
    $(document).ready(function() {

    var table_id = "#tbl_hiring_creditnote";
    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
    return data;
    }).DataTable({
        scrollY         : "450px",
        pageLength      : 50,
        processing: true,
        columns:[
            {className:"nw sl col-max-1"},
            {className:"nw sl col-max-4"},
            {className:"nw sl col-max-5"},
            {className:"nw sl col-max-3"},
            {className:"nw sl col-max-1"},
            {className:"nw sl col-max-4"},
            {className:"nw sl col-max-3 text-right"},
            {className:"nw sl col-max-3 text-right"},
            {className:"nw sl col-max-1 text-right"},
            {className:"nw sl col-max-2 text-right"},
            {className:"nw sl col-max-1 text-right"},
        ],
        "columnDefs": [
                {
                "targets": [10],
                        "visible": false,
        },
        ],
        ajax: {
            url: "<?php  echo Yii::app()->createUrl('hiringcreditnote/GetCreditNoteList') ?>",
            type: "POST",
            cache : false,
        },
        serverSide:     true,
        fixedColumns:   true,
        processing: true,
        "fnCreatedRow"  : function( nRow, aData, iDataIndex ){
                $(nRow).addClass("context-menu");
        },
    });
    $('#tbl_hiring_creditnote tbody').on('mouseover', 'tr', function () {
        $.contextMenu('destroy');
    });
      $('#tbl_hiring_creditnote tbody').on('click', 'tr', function () {
        var data = table.row(this).data();
        var posted = data[10];
            $.contextMenu({
            selector: '.context-menu',
            callback: function(key, options) {
                var action_id = key;
                var id = data[0];
                var file_id = data[1];
                var customer_name = data[3];
                if(action_id == "print"){
                    window.open($('#liveSite').val()+"/index.php?r=hiringcreditnote/printcreditnote&id="+id,"_blank")
                }else if (action_id == "updatecreditdate"){
                    loadPopupModal("hiringcreditnote/editdate&id=" + id, "Edit Credit NOte - "+ customer_name + "/" + file_id + "/" + id, "md");
                }
            },
            items: {
                <?php if ((isset(Yii::app()->user->havePermissionOn['creditnote_creditdate']) || Yii::app()->user->authorised_user == 1) && $_GET['frm']!= 1) { ?>
                        "updatecreditdate": {name: "Edit Date", icon: "fa-edit", disabled: function (key, opt) {
                            // this references the trigger element
                            if (posted=='Y') {
                                return !this.data('updatecreditdate');
                                }
                            }
                        },
                <?php } ?>
                <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["rawmaterial_edit"])) { ?>
                                                    "print": {name: "Print", icon: "fa-print"},
                <?php } ?>
            }
        });
    });
});</script>

<section class="panel">
        <header class="panel-heading clearfix panel-theame-new">
            <i class="fa fa-money"></i> Credit Note
            <div class="pull-right">
                <div class="col-md-12">
                    
                    <?php
                    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["credit_add"])) {
                        ?>
                        <div class="col-md-3">
                            <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('hiringcreditnote/create','Add New Credit Note','xl')"><i class="fa fa-plus"></i> ADD</button>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </header>   
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_hiring_creditnote">
                    <thead>
                        <tr>
                            <th>Credit Note #</th>
                            <th>File#</th>
                            <th>Invoice No</th>
                            <th>Customer</th>
                            <th>Credit Date</th>
                            <th>Currency</th>
                            <th>Invoice Amount</th>
                            <th>VAT</th>
                            <th>Credit Amount</th>
                            <th>Created By</th>
                            <th></th>
                        </tr>
                    </thead>

                </table>
            </div>
        </div>
</section>