<?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'edit_creditnote-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false
    ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">      
                <?php 
                if($model->credited_date!='' && $model->credited_date!='0000-00-00'){
                    $model->credited_date=date("d/m/Y", strtotime($model->credited_date));
                }
                echo $form->textField($model, 'credited_date', array('class'=>'datepicker', 'data-label'=>'Credited Date <span style="color:red;">*</span>','onkeypress' => 'return false;')); ?>   
                <?php echo $form->hiddenField($model, 'id');?>
                <?php echo $form->hiddenField($model, 'is_hiring');?>
            </li>  
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="save_credit_close" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme" onclick="SaveDate();">Save</button>
</div>
<?php $this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript('SaveDate', 'function SaveDate(){	
    jQuery.ajax({
        "dataType":"json",
        "data" : $("#edit_creditnote-form").serialize(),
        "type"  : "post",
        "url": "' . Yii::app()->createUrl('hiringcreditnote/SavecreditDate') . '",
        "success":function(data){
            if(data.status=="success"){  
                t8.success("Saved Successfully!");  
                $("#save_credit_close").click();
                reloadTable("#tble_tble_credit");
                reloadTable("#tbl_hiring_creditnote");
            } 
        },
        "beforeSend":function(){
            $(".toast8-error").hide(); 
            var credited_date=$("#Creditnote_credited_date").val();
            if(credited_date==""){
                t8.error("Select Credit Date"); 
                return false;
            }else{
                $("#loader").show();
                $(".errorMessage").hide(); 
            }
        },
        "complete":function(){
            $("#loader").hide();
        }
    });
};', CClientScript::POS_HEAD);
?>

