<div class="popup_inner_element">
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'hiring_credit-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false
    ));
    ?>
<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li class="active"><a href="#hiring_creditnote_tab1" data-toggle="tab">General</a></li>
    <li><a href="#hiring_creditnote_tab2" data-toggle="tab">Details</a></li>
    <li><a href="#hiring_creditnote_tab3" data-toggle="tab">Terms and Conditions</a></li>
</ul>
<div class="tab-content">
    <div class="tab-pane active" id="hiring_creditnote_tab1">
        <?php $this->renderPartial('general', array('model' => $model, 'form' => $form)); ?>                
    </div> 

    <div class="tab-pane" id="hiring_creditnote_tab2">
        <?php $this->renderPartial('details', array('model' => $model,'model_items'=>$model_items, 'form' => $form,'model_additions' => $model_additions,'model_deductions' => $model_deductions)); ?>                
    </div> 

    <div class="tab-pane" id="hiring_creditnote_tab3">
        <?php $this->renderPartial('terms_and_conditions', array('model' => $model, 'form' => $form)); ?>  
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal" ID="hiring_creditnote_close">Close</button>
    <?php
        $url = Yii::app()->createUrl('hiringcreditnote/SaveCreditNote');
        echo CHtml::ajaxSubmitButton('Save', $url, array(
            'dataType' => 'json',
            'data'=>'js:$("#hiring_credit-form").serialize()+"&terms_conditions="+encodeURIComponent(CKEDITOR.instances.Creditnote_terms_and_conditions.getData())',
            'type' => 'post',
            'success' => 'function(data) {   
                if(data.status=="success"){  
                    t8.success("Credit Note Saved!","Success");  
                    $("#hiring_creditnote_close").click();
                    reloadTable("#tbl_hiring_creditnote");               						
                } else { 
                    $.each(data, function(key, val) {
                        t8.error(""+val+""); 
                    }); 
                } 
            }',
            'beforeSend' => 'function(){
                $(".errorMessage").hide(); 
                var invoice_amount=$("#invoice_total_amount").val();
                var grand_total=$("#grand_total").val();
                var credited_amount=$("#credited_amount").val();
                var balance_amount=Number(invoice_amount)-Number(credited_amount);
                if(Number(balance_amount)<0){
                    balance_amount=0.00;
                }
                if(Number(grand_total)<=0){
                    t8.error("Grand Total must be greater than 0"); 
                    return false;
                }else if(Number(grand_total)> Number(balance_amount)){
                    t8.error("Grand Total cannot be greater than "+balance_amount); 
                    return false;
                }else if(Number(grand_total)> Number(invoice_amount)){
                    t8.error("Grand Total cannot be greater than invoice amount"); 
                    return false;
                }else{
                    $("#loader").show();
                    $(".toast8-error").hide(); 
                    $("#hiring_credit-form.hiring_credit-save-btn").prop("disabled", true);
                    $("#hiring_credit-form.hiring_credit-save-btn").addClass("btn_loding").removeClass("btn btn-primary"); 
                }
            }',
            'complete' => 'function(){
                $("#hiring_credit-form .hiring_credit-save-btn").prop("disabled", false);
                $("#hiring_credit-form .hiring_credit-save-btn").addClass("btn-theme").removeClass("btn_loading");
                $("#loader").hide(); 
            }'
        ), array('id' => 'hire_credit_note' . rand(), 'class' => 'hiring_credit-save-btn btn btn-theme'));
?>
</div>       
<?php $this->endWidget(); ?>
</div>

