<div class="popup_inner_element">
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'enquiry-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false,
    )); ?>
    <div class="tab-content">
        <div class="tab-pane active" id="tab1">            
            <?php echo $form->hiddenField($model, 'id'); ?>
            <input type="hidden" name="level" id="level" value="<?php echo $level; ?>">
            <input type="hidden" name="frm" id="frm" value="<?php echo $frm; ?>">
            <ul class="clearfix form-ul material">
                <li class="col-sm-3">
                    <?php 
                    $vendor_ids=  array();
                    $vendor = explode(",", $model->vendor_id);
                    foreach ($vendor as $eachValue){
                        $vendor_ids[$eachValue] = array('selected' => 'selected');
                    }                
                    echo $form->dropDownList($model, 'vendor_id', Vendor::getVendors(), array('data-search'=>true,'options' => $vendor_ids,'class' => '', 'title' => 'Select Suppliers','multiple'=>true,'data-label'=>'Suppliers <span style="color:red">*</span>', 'disabled' => true)); ?>
                </li>
                <li class="col-sm-3">                
                    <?php echo $form->textField($model, 'enquiry_date', array('class'=>'datepicker','title' => 'Enquiry Date ','data-label'=>'Enquiry Date <span style="color:red">*</span>', 'readonly' => true)); ?>
                    <?php echo $form->error($model, 'enquiry_date'); ?>
                </li> 
                <li class="col-sm-3">
                    <?php echo $form->textField($model, 'required_date', array('class'=>'datepicker','title' => 'Required Date ','data-label'=>'Required Date <span style="color:red">*</span>', 'readonly' => true)); ?>
                    <?php echo $form->error($model, 'required_date'); ?>
                </li> 
                <li class="col-sm-6">
                    <?php echo $form->textArea($model, 'remarks', array(
                        'class' => 'tooltipster',
                        'title' => 'Notes',
                        'value' => '',
                        'data-label' => 'Notes',
                    )); ?>
                </li>
            </ul>
        </div>
    </div> 
    <div class="modal-footer">
        <button type="button" class="btn btn-danger" id="enquiry_close" data-dismiss="modal">Close</button>
        <?php
        $btn = 'Approve';
        $url = Yii::app()->createUrl('features/approvelevel/saveapprove');
        echo CHtml::ajaxSubmitButton($btn, $url, array(
            'dataType' => 'json',
            'data' => 'js:$("#enquiry-form").serialize()',
            'type' => 'post',
            'success' => 'function(data) {
                $("#loader").hide();
                if(data.status=="success"){
                    t8.success("Enquiry Approved!","Success");
                    $("#enquiry_close").click();
                    reloadTable("#tbl_enquiry_details");
                } else {
                    $("#enquiry-form .enquiry-save-btn").prop("disabled", false);
                    $("#enquiry-form .enquiry-save-btn").addClass("btn-theme").removeClass("btn_loading");
                    $.each(data, function(key, val) {
                        $("#enquiry-form #"+key+"_em_").text(val).show();
                            t8.error(""+val+"");
                        });
                    }
                }',
                'complete' => 'function(){}'
        ), array('id' => 'save_convert' . rand(), 'class' => 'enquiry-save-btn btn btn-theme'));
        $btn = 'Reject';
        $url = Yii::app()->createUrl('features/approvelevel/savereject');
        echo CHtml::ajaxSubmitButton($btn, $url, array(
            'dataType' => 'json',
            'data' => 'js:$("#enquiry-form").serialize()',
            'type' => 'post',
            'success' => 'function(data) {
                $("#loader").hide();
                if(data.status=="success"){
                    t8.success("Enquiry Rejected!","Success");
                    $("#enquiry_close").click();
                    reloadTable("#tbl_enquiry_details");
                } else {
                    $("#enquiry-form .enquiry-save-btn").prop("disabled", false);
                    $("#enquiry-form .enquiry-save-btn").addClass("btn-theme").removeClass("btn_loading");
                    $.each(data, function(key, val) {
                        $("#enquiry-form #"+key+"_em_").text(val).show();
                        t8.error(""+val+"");
                    });
                }
            }',
            'complete' => 'function(){}'
        ), array('id' => 'save_convert' . rand(), 'class' => 'enquiry-save-btn btn btn-theme')); ?>        
        <?php $this->endWidget(); ?>
    </div>
</div>