<?php
$cs = Yii::app()->getClientScript();

$baseUrl = Yii::app()->baseUrl;
?>
<script>
    $(document).ready(function () {
    var table_id = "#tbl_emicategory_details";
    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
    data.display_type = $("#display_type").val();
    return data;
    }).DataTable({
    scrollY: "645px",
            pageLength: 50,
            processing: true,
            "order": [[ 1, "asc" ]],
            ajax: {
            url: "<?php echo Yii::app()->createUrl('emicategory/GetList') ?>",
                    type: "POST",
                    cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            AddContextMenu(nRow, aData);
            }

    });
    });
    function AddContextMenu(row, datas) {

    $(row).contextMenu({
    selector: 'td',
            items: {
            "edit": {

<?php
if (isset(Yii::app()->user->havePermissionOn['mas_inv_emicategory_add']) || Yii::app()->user->authorised_user == 1) {
    ?>

                name: "Edit",
                        icon: "Edit",
                        accesskey: "e",
                        callback: function () {
                        loadPopupModal("emicategory/create&id=" + datas[3].id, datas[3].name, "lg");
                        }
                },
<?php } 
if (isset(Yii::app()->user->havePermissionOn['mas_inv_emicategory_delete']) || Yii::app()->user->authorised_user == 1) {
?>
            "del":{
            name:"Delete",
                    icon:"trash",
                    callback:() => {
            var id = datas[3].id;
            deleteemicategory(id);
            }
            },
<?php } ?>
            }
    });
    }
</script>

<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="material-icons"></i> Emi Category   
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['mas_inv_emicategory_add']) || Yii::app()->user->authorised_user == 1) { ?>

                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('emicategory/create', 'Add New Emi Category', 'lg')"><i class="fa fa-plus"></i> ADD</button>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_emicategory_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>SI No</th>
                        <th>Name</th>                        
                        <th>Active</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>SI No</th>
                        <th>Name</th>                        
                        <th>Active</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>
<script>
    function deleteemicategory(id) {
    var r = confirm('Are you sure to delete this?');
    if (r == true)
    {
    jQuery.ajax({
    'type': 'post',
            'data': 'id=' + id,
            'url': $('#liveSite').val() + 'index.php?r=emicategory/DeleteItem',
            'cache': false,
            'success': function (data) {
            if (data == 'fail') {
            t8.error('Error while Delete');
            } else {
            reloadTable("#tbl_emicategory_details");
            t8.success('Deleted SuccessFully');
            }
            }
    });
    }


    }
</script>
