<?php /**
 * Please Modify if you modify this file
 * Last Modified By Jisha On 9-11-2022
 */ ?>
<ul class="clearfix form-ul material">
    <li class="col-sm-3">
        <?php $arr_invoice_status = MasInvoiceStatus::model()->find(array('condition' => 'status_code="O"')); ?>
        <?php echo $form->hiddenField($model, 'id'); ?>
        <?php echo $form->hiddenField($model, 'invoice_status', array('value' => $arr_invoice_status->id)); ?>
        <?php
        $model->currency = Yii::app()->user->company_base_currency;
        echo $form->hiddenField($model, 'currency');
        $model->exchange_rate = 1;
        echo $form->hiddenField($model, 'exchange_rate');
        $model->sales_group = 1;
        echo $form->hiddenField($model, 'sales_group');
        $model->crm_user_id = Yii::app()->user->id;
        $model->lead_owner_id= Yii::app()->user->id;
        echo $form->hiddenField($model, 'lead_owner_id');
        echo $form->hiddenField($model, 'crm_user_id');
        $invoice_date = date("d/m/Y");
        if ($model->id > 0) {
            $invoice_date = date("d/m/Y", strtotime($model->invoice_date));
        }
        ?>  
        <?php
        $model->customer_name = $model->customer->customer_name;
        echo $form->textField($model, 'customer_name', array('class' => '', 'onKeyup' => 'js:autoCompleteInvoiceCustomer(this.id,"Order");', 'prompt' => '--select--', 'title' => 'Select Customer', 'data-label' => 'Customer <span style="color:red;">*</span>'));
        ?>
        <?php echo $form->hiddenField($model, 'customer_id'); ?>
    </li>
    <div id="div_customer_contact">
        <li class="col-sm-3">
            <?php
            if ($model->contact_id > 0) {
                echo $form->dropDownList($model, 'contact_id', CustomerContact::getCustomerContacts($model->customer_id), array(
                    'options' => array($model->contact_id => array('selected' => true)), 'readonly' => true, 'data-label' => 'Contact <span style="color:red">*</span>', 'prompt' => 'Select'));
            } else {
                echo $form->dropDownList($model, 'contact_id', '', array('class' => 'tooltipster', 'title' => 'Contact name', 'data-label' => 'Contact <span style="color:red;">*</span>'));
            }
            ?>
        </li>
    </div>   
    <li class="col-sm-2">
        <?php echo $form->textField($model, 'invoice_date', array('class' => 'datepicker text-bold', 'title' => 'Invoice Date', 'data-label' => 'Invoice Date <span style="color:red;">*</span>', 'value' => $invoice_date));
        ?>
    </li>   
    <li class="col-sm-2">
        <?php echo $form->dropdownlist($model, 'payment_terms', MasPaymentTerm::getPaymentTerms(), array('class' => 'text-bold', 'data-label' => 'Payment terms', 'onchange' => 'getInvoiceType(this.value,this.id);')); ?>

    </li>


    <li class="col-sm-2">
        <?php
        if ($model->id > 0) {
            $default_invc_id = $model->invoice_type;
            if ($default_invc_id <= 0) {
                $default_invc_count = MasInvoiceType::model()->count('inv_type="sales" AND is_default="Y"');
                if ($default_invc_count > 0) {
                    $default_invc_model = MasInvoiceType::model()->find('inv_type="sales" AND is_default="Y"');
                } else {
                    $default_invc_model = MasInvoiceType::model()->find('inv_type="sales"');
                }
                $default_invc_id = $default_invc_model->id;
            }
        } else {
            $default_invc_count = MasInvoiceType::model()->count('inv_type="sales" AND is_default="Y"');
            if ($default_invc_count > 0) {
                $default_invc_model = MasInvoiceType::model()->find('inv_type="sales" AND is_default="Y"');
            } else {
                $default_invc_model = MasInvoiceType::model()->find('inv_type="sales"');
            }
            $default_invc_id = $default_invc_model->id;
        }


        echo $form->dropDownList($model, 'invoice_type', MasInvoiceType::getInvoceType('sales'), array('class' => '', 'data-label' => 'Invoice Type <span style="color:red">*</span>', 'onchange' => 'getInvoiceType(this.value,this.id);', 'options' => array($default_invc_id => array('selected' => true))));
        ?>
        <?php echo $form->error($model, 'invoice_type'); ?>
    </li>
    <li class="col-sm-6">

        <?php echo $form->textArea($model, 'billing_address', array('class' => 'text-bold', 'data-label' => 'Billing Address')); ?>

    </li>    
</ul>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompleteInvoiceCustomer", "function autoCompleteInvoiceCustomer(field_id,frm){
var url = '" . Yii::app()->createUrl('customer/GetCustomerDetails') . "'+'&frm='+frm;
        $('#'+field_id).autocomplete({
        minLength : 1,
        source : function (request, response) {
            autoCompleteSource(request, response,url)
        },
        focus : function( event, ui ) {
            $(this).val((ui.item.label)); return false;
        },
        select : function( event, ui ) {
            event.preventDefault();
            trigger_target_id = $(event.target).attr('id');
            var customer_id=ui.item.value;
            var currency=ui.item.currency;
            var currency_id=ui.item.currency_id;
            var exchange_rate =1;
            var payment_term = ui.item.payment_term;
            var billing_address = ui.item.billaddress;
                    $('#Invoice_customer_id').val(customer_id);
                    $('#Invoice_payment_terms').multiselect('select', payment_term);
                    $('#Invoice_billing_address').val(billing_address);
                    $('#Invoice_billing_address').addClass('filled');
                    
                    jQuery.ajax({

                        'data' :{'id':customer_id,'modelName':'Invoice','columnWidth':3},

                        'dataType' : 'json',

                        'type':'post',

                        'url': '" . Yii::app()->createUrl('customer/getCustomerContactdetails') . "',

                        'success': function(data) {

                          $('#div_customer_contact').html(data.dt);

                        }

                    });

        } }) }", CClientScript::POS_HEAD);

$cs = Yii::app()->getClientScript('jquery.ui');
$baseUrl = Yii::app()->baseUrl;
$cs->registerScript('getInvoiceType', ' function getInvoiceType(typeid,id) {

    if(typeid>0){

        jQuery.ajax({
        
            "dataType" : "json",
            
            "type"  : "post",
            
            "data"  : "id="+typeid,

            "url"  : $("#liveSite").val()+"index.php?r=masinvoicetype/getInvoiceTypeTax",
            
            "cache": false,
            
            "success":function(data){
                
                if(data.status=="success"){
                    var tr_rowCount = $("#direct_invoice_item_table tr").length;
                    tr_rowCount  = tr_rowCount-2;
                    if(data.tax == "Y"){
                        for (i = 0; i <= tr_rowCount; i++){
                            var find_value  = $("#InvoiceItem_"+i+"_actual_tax_amount").val();
                            var find_tax_percentage  = $("#InvoiceItem_"+i+"_actual_tax_percentage").val();
                            $("#InvoiceItem_"+i+"_tax_vat_amount").val(find_value);
                            $("#InvoiceItem_"+i+"_tax_vat_percentage").val(find_tax_percentage);
                        }
                    }
                    else{
 
                        for (i = 0; i <= tr_rowCount; i++){
                            $("#InvoiceItem_"+i+"_tax_vat_amount").val(0);
                            $("#InvoiceItem_"+i+"_tax_vat_percentage").val(0);
                        }
                    }
                    calculateInvoiceValue($("#direct_invoice_item_table"));
                }
               }
            });
    }
}', CClientScript::POS_HEAD);
?>