<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$cs->registerScript("loadDirectPurchase", '$(document).ready(function() {
        var table_id ="#direct_purchase_table";
        var table = $(table_id).DataTable({
        scrollY         : "380px",
        pageLength      : 50,
        "order": [[ 0, "desc" ]],
        processing: true,
        ajax: {
        url: "' . Yii::app()->createUrl('directpurchase/GetList') . '",
        type: "POST",
        cache : false,
        },
        serverSide:     true,
        fixedColumns:   true,
        processing: true,
        fixedHeader: {
        headerOffset: $("header.main").outerHeight()
        }
        } );
        $(".dataTables_scrollFoot").hide();
        });', CClientScript::POS_HEAD);
?>    <section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa  fa-balance-scale"></i> Direct Purchase
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['direct_purchase_add']) || Yii::app()->user->authorised_user == 1) { ?>

                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('directpurchase/create&type=create', 'Add Direct Purchase', 'xl')"><i class="fa fa-plus"></i> ADD</button>

            <?php } ?></div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="direct_purchase_table">
                <thead>
                    <tr>
                        <th>Invoice No</th>
                        <th>Date</th>
                        <th>Vendor</th>
                        <th>Currency</th>
                        <th>VAT</th>
                        <th>Grand Total</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>Invoice No</th>
                        <th>Date</th>
                        <th>Vendor</th>
                        <th>Currency</th>
                        <th>VAT</th>
                        <th>Grand Total</th>
                        <th>Actions</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>