<ul class="clearfix form-ul material">
    <li class="col-sm-4">
        <?php echo $form->dropDownList(
            $model,
            'city',
            CustomerShippingDetails::getCity($model->customer_id),
            array(
                'data-label' => 'City',
                'prompt' => 'Select',
                'onchange' => 'getshippingAddress(this)'
            )
        ); ?>

    </li>
    <li class="col-sm-4">
        <?php echo $form->textArea($model, 'shipping_address', array('data-label' => 'Shipping Address')); ?>
        <?php echo $form->error($model, 'shipping_address'); ?>
    </li>
    <li class="col-sm-4">
        <?php echo $form->textArea($model, 'shipping_conditions', array('data-label' => 'Shipping Condition')); ?>
        <?php echo $form->error($model, 'shipping_conditions'); ?>
    </li>
    <li class="col-sm-4" style="display:none;">
        <?php
        if ($model->shipped_by == '' && $model->file_id > 0)
            $model->shipped_by = Order::getShipping($model->file_id); ?>
        <?php echo $form->dropDownList($model, 'shipped_by', MasShipping::getShipping(), array('prompt' => '-select-', 'data-label' => 'Shipped By', 'class' => 'tooltipster', 'class' => 'text-bold', )); ?>
        <?php echo $form->error($model, 'shipped_by'); ?>
    </li>
    <!--    <li class="col-sm-4">               
        <?php //echo $form->dropDownList($model, 'warehouse', MasInventoryWarehouse::getWarehouses(), array('data-label'=>'Warehouse','class'=>'tooltipster','class'=>'text-bold','onchange' => 'sortdata("date","stock_affect_date")')); ?>
        <?php //echo $form->error($model, 'warehouse'); ?>
    </li> -->
    <li class="col-sm-4" style="display:none;">
        <?php echo $form->textField($model, 'awb_no', array('class' => 'tooltipster ', 'data-label' => 'AWB No')); ?>
        <?php echo $form->hiddenField($model, 'awb_no'); ?>
    </li>
    <li class="col-sm-4" style="display:none;">
        <?php echo $form->textField($model, 'tracking_no', array('data-label' => 'Tracking No', 'onkeyup' => 'setBillofexit(this.value); return false;')); ?>
        <?php echo $form->error($model, 'tracking_no'); ?>
    </li>
    <li class="col-sm-4" style="display:none;">
        <?php echo $form->textField($model, 'no_of_boxes', array('data-label' => 'No of Boxes')); ?>
        <?php echo $form->error($model, 'no_of_boxes'); ?>
    </li>
    <li class="col-sm-4" style="display:none;">
        <?php echo $form->textField($model, 'total_weight', array('data-label' => 'Total Weight')); ?>
        <?php echo $form->error($model, 'total_weight'); ?>
    </li>
    <li class="col-sm-4" style="display:none;">
        <?php echo $form->textField($model, 'total_volume', array('data-label' => 'Total Volume')); ?>
        <?php echo $form->error($model, 'total_volume'); ?>
    </li>
    <li class="col-sm-4" style="display:none;">
        <?php echo $form->textField($model, 'packed_by', array('data-label' => 'Packed By')); ?>
        <?php echo $form->error($model, 'packed_by'); ?>
    </li>
</ul>
<script>
    function getshippingAddress(element) {
        var id = $(element).val(); // Get selected city or ID
    
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("delivery/getCustomerContactdetails"); ?>',
            data: { id: id },
            dataType: 'json',
            success: function(response) {
                if (response.adds) {
                    $('#DeliveryNote_shipping_address').val(response.adds).addClass('filled');
                }
            },
            error: function() {
                console.log('Error fetching shipping address');
            }
        });
    }
</script>

