<ul class="clearfix form-ul material">
    <li class="col-sm-2">
        <?php echo $form->textField($model, 'file_id', array('class' => 'tooltipster', 'data-label' => 'File No', 'disabled' => true)); ?>
    </li>
    <li class="col-sm-2">
        <?php echo $form->textField($model, 'file_title', array('class' => 'tooltipster', 'data-label' => 'File Title', 'disabled' => true)); ?>
    </li>
    <li class="col-sm-2">
        <?php echo $form->textField($model, 'customer_name', array(
            'class' => 'text-bold',
            'data-label' => "Customer",
            'value' => $model->customer->customer_name,
            'disabled' => true
        ));
        ?>
    </li>
    <li class="col-sm-2">
        <?php
        echo $form->dropDownList($model, 'contact_id', CustomerContact::getCustomerContacts($model->customer_id), array(
            'options' => array($model->contact_id => array('selected' => true)),
            'disabled' => true,
            'data-label' => 'Contact Person'
        ));

        ?>
    </li>
    <?php
    if (empty($model->inco_term_id)) {
        $defaultTerm = MasIncoTerms::model()->findByAttributes(['isDefault' => 'Y', 'isActive' => 'Y']);
        if ($defaultTerm) {
            $model->inco_term_id = $defaultTerm->id;
        }
    }
    ?>
    <li class="col-sm-2" style="display:none">
        <?php echo $form->dropDownList(
            $model,
            'inco_term_id',
            MasIncoTerms::getIncoTerms(),
            array(
                'prompt' => '--Select--',
                'data-label' => 'Inco Terms <span style="color:red">*</span>'
            )
        ); ?>
    </li>
    <li class="col-sm-2">
        <?php
        if ($model->delivery_date != '' && $model->delivery_date != '0000-00-00') {
            $model->delivery_date = date("d/m/Y", strtotime($model->delivery_date));
        }
        ?>
        <?php echo $form->textField($model, 'delivery_date', array('class' => '', 'data-label' => 'Delivery Date', 'disabled' => true)); ?>
    </li>
    <li class="col-sm-2">
        <?php echo $form->textField($model, 'lpo', array('data-label' => 'PO Reference', 'disabled' => true)); ?>
    </li>



    <li class="col-sm-4">
        <?php echo $form->textArea($model, 'billing_address', array('data-label' => 'Billing Address', 'class' => 'en-text-area', 'disabled' => true)); ?>
    </li>
</ul>