<style>
    .text-red {
        color: red;
    }
</style>
<div class="stats-table">

    <!-- Header Row -->
    <div class="stats-header">
        <div></div>
        <div class="header-this">This Year</div>
        <div class="header-prev">Prev Year</div>
    </div>

    <?php
    // Helper function for formatting numbers or fallback
    function formatNum($num)
    {
        return is_null($num) ? '-' : number_format($num, 2);
    }

    // For quantities, just integers or fallback
    function formatQty($num)
    {
        return is_null($num) ? '-' : intval($num);
    }

    // Get all unique product names from both years
    $allProducts = array_unique(array_merge(
        array_keys($currentYearProductSales),
        array_keys($lastYearProductSales)
    ));

    foreach ($allProducts as $productName):
        $shortName = mb_substr($productName, 0, 21);

        $curr = $currentYearProductSales[$productName] ?? null;
        $last = $lastYearProductSales[$productName] ?? null;
        ?>

        <div class="stats-row">
            <div class="stats-label" title="<?= htmlspecialchars($productName) ?>">
                <?= htmlspecialchars($shortName) ?>
            </div>
            <div class="stats-box" style="height: 116px;">
                <div>Qty: <span class="spn-last <?= isset($curr['qty']) && $curr['qty'] < 0 ? 'text-red' : '' ?>">
                        <?= isset($curr['qty']) && $curr['qty'] != 0 ? formatQty($curr['qty']) : '-' ?>
                    </span></div>

                <div>Sales: <span
                        class="spn-last <?= isset($curr['sales_value']) && $curr['sales_value'] < 0 ? 'text-red' : '' ?>">
                        <?= isset($curr['sales_value']) && $curr['sales_value'] != 0 ? formatNum($curr['sales_value']) : '-' ?>
                    </span></div>

                <div>Cost: <span
                        class="spn-last <?= isset($curr['cost_value']) && $curr['cost_value'] < 0 ? 'text-red' : '' ?>">
                        <?= isset($curr['cost_value']) && $curr['cost_value'] != 0 ? formatNum($curr['cost_value']) : '-' ?>
                    </span></div>

                <div>GP: <span class="spn-last <?= isset($curr['gp']) && $curr['gp'] < 0 ? 'text-red' : '' ?>">
                        <?= isset($curr['gp']) && $curr['gp'] != 0 ? formatNum($curr['gp']) : '-' ?>
                    </span></div>

                <div>GP%: <span
                        class="spn-last <?= isset($curr['gp_percent']) && $curr['gp_percent'] < 0 ? 'text-red' : '' ?>">
                        <?= isset($curr['gp_percent']) && $curr['gp_percent'] != 0 ? number_format($curr['gp_percent'], 2) . '%' : '-' ?>
                    </span></div>
            </div>

            <div class="stats-box-prev" style="height: 116px;">
                <div>Qty: <span class="spn-last <?= isset($last['qty']) && $last['qty'] < 0 ? 'text-red' : '' ?>">
                        <?= isset($last['qty']) && $last['qty'] != 0 ? formatQty($last['qty']) : '-' ?>
                    </span></div>

                <div>Sales: <span
                        class="spn-last <?= isset($last['sales_value']) && $last['sales_value'] < 0 ? 'text-red' : '' ?>">
                        <?= isset($last['sales_value']) && $last['sales_value'] != 0 ? formatNum($last['sales_value']) : '-' ?>
                    </span></div>

                <div>Cost: <span
                        class="spn-last <?= isset($last['cost_value']) && $last['cost_value'] < 0 ? 'text-red' : '' ?>">
                        <?= isset($last['cost_value']) && $last['cost_value'] != 0 ? formatNum($last['cost_value']) : '-' ?>
                    </span></div>

                <div>GP: <span class="spn-last <?= isset($last['gp']) && $last['gp'] < 0 ? 'text-red' : '' ?>">
                        <?= isset($last['gp']) && $last['gp'] != 0 ? formatNum($last['gp']) : '-' ?>
                    </span></div>

                <div>GP%: <span
                        class="spn-last <?= isset($last['gp_percent']) && $last['gp_percent'] < 0 ? 'text-red' : '' ?>">
                        <?= isset($last['gp_percent']) && $last['gp_percent'] != 0 ? number_format($last['gp_percent'], 2) . '%' : '-' ?>
                    </span></div>
            </div>


        </div>

    <?php endforeach; ?>

</div>