<style type="text/css">
    /* Search Form Styling */
    .search-form {
        display: inline-block;
        max-width: 600px;
        width: 100%;
    }

    .search-group {
        width: 100%;
    }

    .search-input {
        border-radius: 25px 0 0 25px;
        padding: 10px 15px;
        font-size: 14px;
    }

    .search-btn {
        border-radius: 0 25px 25px 0;
        padding: 10px 20px;
        font-size: 14px;
    }

    .stats-table {
        /*      max-width: 800px;
      margin: 40px auto;*/
        font-weight: 600;
    }

    .stats-header {
        display: flex;
        justify-content: space-between;
        margin-bottom: 2px;
        font-size: 16px;
    }

    .stats-header div {
        flex: 1;
        text-align: center;
    }

    .header-this {
        color: #1c9d7d;
    }

    .header-prev {
        color: #ca51a2;
    }

    .stats-row {
        display: flex;
        margin-bottom: 12px;
        margin: 7px;
    }

    .stats-label {
        flex: 1;
        /* background: linear-gradient(180deg, #00895a, #00593f); */
        color: #000000;
        border-radius: 8px;
        padding: 0px;
        text-align: left;
        line-height: 38px;
    }

    .stats-box {
        flex: 1;
        background: #cef3eb;
        border-radius: 8px;
        padding: 4px;
        text-align: left;
        color: #1c9d7d;
        height: 30px;
        margin: 5px;
    }

    .stats-box-prev {
        flex: 1;
        background: #ffe7f7;
        border-radius: 8px;
        padding: 4px;
        text-align: left;
        color: #ca51a2;
        height: 30px;
        margin: 5px;
    }

    /* Responsive for Mobile */
    @media (max-width: 600px) {
        .stats-header {
            display: none;
        }

        .stats-row {
            flex-direction: column;
        }

        .stats-label,
        .stats-box,
        .stats-box-prev {
            margin-bottom: 8px;
        }
    }

    .bg-info {
        background-color: #f5f5f5;
    }

    .nw-dash-main-wrpr h4 {
        background: linear-gradient(135deg, #005252 0%, #27b98d 100%);
        padding: 7px;
        color: white;
        border-radius: 12px;
    }
</style>


<script>
    $(document).ready(function () {
        function LoadSalesDetails(empId) {
            $.ajax({
                url: '<?php echo Yii::app()->createUrl("DashboardmatrixEmployee/LoadSalesDetails"); ?>',
                type: 'POST',
                data: { employee_id: empId },
                success: function (response) {
                    $('#employee-sales-details').html(response);
                },
                error: function () {
                    $('#employee-sales-details').html('<p style="color:red;">Failed to load details.</p>');
                }
            });
        }

        function LoadSalesInvouceDetailsCustomer(empId) {
            $.ajax({
                url: '<?php echo Yii::app()->createUrl("DashboardmatrixEmployee/CustomerSales"); ?>',
                type: 'POST',
                data: { employee_id: empId },
                success: function (response) {
                    $('#employee-invoice-sales-details_customer').html(response);
                },
                error: function () {
                    $('#employee-invoice-sales-details_customer').html('<p style="color:red;">Failed to load details.</p>');
                }
            });
        }

        function LoadSalesInvouceDetailsProduct(empId) {
            $.ajax({
                url: '<?php echo Yii::app()->createUrl("DashboardmatrixEmployee/ProductSales"); ?>',
                type: 'POST',
                data: { employee_id: empId },
                success: function (response) {
                    $('#employee-invoice-sales-details_product').html(response);
                },
                error: function () {
                    $('#employee-invoice-sales-details_product').html('<p style="color:red;">Failed to load details.</p>');
                }
            });
        }
         function LoadSalesInvouceDetailsVehicle(empId) {
            $.ajax({
                url: '<?php echo Yii::app()->createUrl("DashboardmatrixEmployee/VehicleSales"); ?>',
                type: 'POST',
                data: { employee_id: empId },
                success: function (response) {
                    $('#employee-invoice-sales-details_vehicle').html(response);
                },
                error: function () {
                    $('#employee-invoice-sales-details_vehicle').html('<p style="color:red;">Failed to load details.</p>');
                }
            });
        }
        function LoadEmployeeDetails(empId) {
            $.ajax({
                url: '<?php echo Yii::app()->createUrl("DashboardmatrixEmployee/LoadEmployeeDetails"); ?>',
                type: 'POST',
                data: { employee_id: empId },
                success: function (response) {
                    $('#employee-personal-details').html(response);
                },
                error: function () {
                    $('#employee-personal-details').html('<p style="color:red;">Failed to load details.</p>');
                }
            });
        }
        function LoadEmployeeSalaryDetails(empId) {
            $.ajax({
                url: '<?php echo Yii::app()->createUrl("DashboardmatrixEmployee/LoadEmployeeSalaryDetails"); ?>',
                type: 'POST',
                data: { employee_id: empId },
                success: function (response) {
                    $('#employee-salary-details').html(response);
                },
                error: function () {
                    $('#employee-salary-details').html('<p style="color:red;">Failed to load details.</p>');
                }
            });
        }

        // initial load
        LoadSalesDetails(0);
        LoadSalesInvouceDetailsCustomer(0);
        LoadSalesInvouceDetailsProduct(0);

        // reload when employee changes
        $('#employee_id').change(function () {
            var empId = $(this).val() || 0;
            LoadSalesDetails(empId);
            LoadSalesInvouceDetailsCustomer(empId);
            LoadSalesInvouceDetailsProduct(empId);
            LoadSalesInvouceDetailsVehicle(empId);
            LoadEmployeeDetails(empId);
            LoadEmployeeSalaryDetails(empId);
        });
    });
</script>

<section class="panel nw-dash-main-wrpr">
    <div class="panel-body">
        <div class="text-center">
            <!-- Top Row -->
            <div class="row" style="margin-bottom:20px;">
                <div class="col-sm-4">
                    <div class="card bg-info" style="height:auto; min-height:120px; border-radius:27px; padding:9px;">
                        <h4>Sales Details</h4>
                        <div id="employee-sales-details"><!-- Stats will load here --></div>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="card bg-info" style="height:auto; min-height:120px; border-radius:27px; padding:9px;">
                     <h4>Employee Details</h4>
                        <div id="employee-personal-details"></div>
                </div>
                </div>
                <div class="col-sm-4">
                    <div class="card bg-info" style="height:auto; min-height:120px; border-radius:27px; padding:9px;">
                        <h4>Employee Status</h4>
                        <div id="employee-salary-details"></div>
                    </div>
                </div>
            </div>
            <div class="row" style="margin-bottom:20px;">
                <div class="col-sm-12 text-center" style="margin-left: 4%;">
                    <form class="form-inline search-form">
                        <div class="input-group search-group">
                            <?php
                            echo CHtml::dropDownList(
                                'employee_id',
                                '',
                                Employee::getMatrixEmployees(),
                                ['empty' => 'Select Employee', 'class' => 'form-control', 'style' => 'height: 42px;']
                            );
                            ?>
                            <span class="input-group-btn">
                                <button class="btn btn-primary search-btn" type="button">
                                    <i class="glyphicon glyphicon-search"></i> Search
                                </button>
                            </span>
                        </div>
                    </form>
                </div>
            </div>
            <!-- Search Row -->
            <div class="row" style="margin-bottom:20px;">
                <div class="col-sm-4 ">
                    <div class="card bg-info"
                        style="height: 750px; border-radius: 27px; padding: 9px; overflow: hidden;">
                        <h4>Customer Wise Sales</h4>
                        <div id="employee-invoice-sales-details_customer" style="max-height: 750px; overflow-y: auto;">
                            <!-- Stats will load here -->
                        </div>
                    </div>
                </div>

                <div class="col-sm-4 text-left">
                    <div class="card bg-info"
                        style="height: 750px; border-radius: 27px; padding: 9px; background: #dbfff7; overflow: hidden;">
                        <h4 class="text-center">Product Wise Sales & GP</h4>
                        <div id="employee-invoice-sales-details_product" style="max-height: 750px; overflow-y: auto;">
                            <!-- Stats will load here -->
                        </div>
                    </div>
                </div>
                 <div class="col-sm-4 text-left">
                    <div class="card bg-info"
                        style="height: 750px; border-radius: 27px; padding: 9px; background: #dbfff7; overflow: hidden;">
                        <h4 class="text-center">Vehicle Allotment</h4>
                        <div id="employee-invoice-sales-details_vehicle" style="max-height: 750px; overflow-y: auto;">
                            <!-- Stats will load here -->
                        </div>
                    </div>
                </div>
            </div>
            
        </div>

        <!-- Bottom Row -->
        <!-- <div class="row">
            <div class="col-sm-4">
                <div class="card bg-info" style="height:auto; min-height:120px; border-radius:27px; padding:9px;background: #dbfff7;">
                </div>
            </div>
            <div class="col-sm-4">
                <div class="card bg-info" style="height:120px;border-radius: 27px;"></div>
            </div>
            <div class="col-sm-4">
                <div class="card bg-info" style="height:120px;background: #dbfff7;border-radius: 27px;"></div>
            </div>
        </div> -->
    </div>
    </div>
    </div>
</section>