<?php
$todayStart = date('Y-m-d 00:00:00');
$todayEnd = date('Y-m-d 23:59:59');
$weekStart = date('Y-m-d 00:00:00', strtotime('monday this week'));
$weekEnd = date('Y-m-d 23:59:59', strtotime('sunday this week'));
$monthStart = date('Y-m-01 00:00:00');
$monthEnd = date('Y-m-t 23:59:59');
$yearStart = date('Y-01-01 00:00:00');
$yearEnd = date('Y-12-31 23:59:59');
$lastMonthStart = date('Y-m-01 00:00:00', strtotime('first day of last month'));
$lastMonthEnd = date('Y-m-t 23:59:59', strtotime('last day of last month'));

$currentYear = date("Y");
$lastYear = $currentYear - 1;
$lastYearStart = $lastYear . '-01-01 00:00:00';
$lastYearEnd = $lastYear . '-12-31 23:59:59';



// customer

$todayCustomerCount = Customer::model()->count("created_date_time BETWEEN :start AND :end", [":start" => $todayStart, ":end" => $todayEnd]);
$weekCustomerCount = Customer::model()->count("created_date_time BETWEEN :start AND :end", [":start" => $weekStart, ":end" => $weekEnd]);
$monthCustomerCount = Customer::model()->count("created_date_time BETWEEN :start AND :end", [":start" => $monthStart, ":end" => $monthEnd]);
$yearCustomerCount = Customer::model()->count("created_date_time BETWEEN :start AND :end", [":start" => $yearStart, ":end" => $yearEnd]);
$lastMonthCustomerCount = Customer::model()->count("created_date_time BETWEEN :start AND :end", [":start" => $lastMonthStart, ":end" => $lastMonthEnd]);
$lastYearCustomerCount = Customer::model()->count("created_date_time BETWEEN :start AND :end", [":start" => $lastYearStart, ":end" => $lastYearEnd]);

// lead

$todayLead = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(value),0) as total")
    ->from("erp_lead")
    ->where("enq_date BETWEEN :start AND :end", [":start" => $todayStart, ":end" => $todayEnd])
    ->queryRow();

$weekLead = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(value),0) as total")
    ->from("erp_lead")
    ->where("enq_date BETWEEN :start AND :end", [":start" => $weekStart, ":end" => $weekEnd])
    ->queryRow();

$monthLead = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(value),0) as total")
    ->from("erp_lead")
    ->where("enq_date BETWEEN :start AND :end", [":start" => $monthStart, ":end" => $monthEnd])
    ->queryRow();

$yearLead = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(value),0) as total")
    ->from("erp_lead")
    ->where("enq_date BETWEEN :start AND :end", [":start" => $yearStart, ":end" => $yearEnd])
    ->queryRow();

$lastMonthLead = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(value),0) as total")
    ->from("erp_lead")
    ->where("enq_date BETWEEN :start AND :end", [":start" => $lastMonthStart, ":end" => $lastMonthEnd])
    ->queryRow();

$lastYearLead = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(value),0) as total")
    ->from("erp_lead")
    ->where("enq_date BETWEEN :start AND :end", [":start" => $lastYearStart, ":end" => $lastYearEnd])
    ->queryRow();

// quotes

$todayQuote = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_quotes")
    ->where("qtn_start_date BETWEEN :start AND :end", [":start" => $todayStart, ":end" => $todayEnd])
    ->queryRow();

$weekQuote = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_quotes")
    ->where("qtn_start_date BETWEEN :start AND :end", [":start" => $weekStart, ":end" => $weekEnd])
    ->queryRow();

$monthQuote = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_quotes")
    ->where("qtn_start_date BETWEEN :start AND :end", [":start" => $monthStart, ":end" => $monthEnd])
    ->queryRow();

$yearQuote = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_quotes")
    ->where("qtn_start_date BETWEEN :start AND :end", [":start" => $yearStart, ":end" => $yearEnd])
    ->queryRow();

$lastMonthQuote = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_quotes")
    ->where("qtn_start_date BETWEEN :start AND :end", [":start" => $lastMonthStart, ":end" => $lastMonthEnd])
    ->queryRow();

$lastYearQuote = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_quotes")
    ->where("qtn_start_date BETWEEN :start AND :end", [":start" => $lastYearStart, ":end" => $lastYearEnd])
    ->queryRow();

// invoice

$todayInvoice = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_invoice")
    ->where("invoice_date BETWEEN :start AND :end", [":start" => $todayStart, ":end" => $todayEnd])
    ->queryRow();

$weekInvoice = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_invoice")
    ->where("invoice_date BETWEEN :start AND :end", [":start" => $weekStart, ":end" => $weekEnd])
    ->queryRow();

$monthInvoice = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_invoice")
    ->where("invoice_date BETWEEN :start AND :end", [":start" => $monthStart, ":end" => $monthEnd])
    ->queryRow();

$yearInvoice = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_invoice")
    ->where("invoice_date BETWEEN :start AND :end", [":start" => $yearStart, ":end" => $yearEnd])
    ->queryRow();

$lastMonthInvoice = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_invoice")
    ->where("invoice_date BETWEEN :start AND :end", [":start" => $lastMonthStart, ":end" => $lastMonthEnd])
    ->queryRow();

$lastYearInvoice = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_invoice")
    ->where("invoice_date BETWEEN :start AND :end", [":start" => $lastYearStart, ":end" => $lastYearEnd])
    ->queryRow();

// Order

$todayOrder = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_order")
    ->where("order_date BETWEEN :start AND :end", [":start" => $todayStart, ":end" => $todayEnd])
    ->queryRow();

$weekOrder = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_order")
    ->where("order_date BETWEEN :start AND :end", [":start" => $weekStart, ":end" => $weekEnd])
    ->queryRow();

$monthOrder = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_order")
    ->where("order_date BETWEEN :start AND :end", [":start" => $monthStart, ":end" => $monthEnd])
    ->queryRow();

$yearOrder = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_order")
    ->where("order_date BETWEEN :start AND :end", [":start" => $yearStart, ":end" => $yearEnd])
    ->queryRow();

$lastMonthOrder = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_order")
    ->where("order_date BETWEEN :start AND :end", [":start" => $lastMonthStart, ":end" => $lastMonthEnd])
    ->queryRow();

$lastYearOrder = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_order")
    ->where("order_date BETWEEN :start AND :end", [":start" => $lastYearStart, ":end" => $lastYearEnd])
    ->queryRow();

// CR

$todayCR = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(credited_amount * exchange_rate),0) as total")
    ->from("erp_creditnote")
    ->where("credited_date BETWEEN :start AND :end", [":start" => $todayStart, ":end" => $todayEnd])
    ->queryRow();

$weekCR = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(credited_amount * exchange_rate),0) as total")
    ->from("erp_creditnote")
    ->where("credited_date BETWEEN :start AND :end", [":start" => $weekStart, ":end" => $weekEnd])
    ->queryRow();

$monthCR = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(credited_amount * exchange_rate),0) as total")
    ->from("erp_creditnote")
    ->where("credited_date BETWEEN :start AND :end", [":start" => $monthStart, ":end" => $monthEnd])
    ->queryRow();

$yearCR = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(credited_amount * exchange_rate),0) as total")
    ->from("erp_creditnote")
    ->where("credited_date BETWEEN :start AND :end", [":start" => $yearStart, ":end" => $yearEnd])
    ->queryRow();

$lastMonthCR = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(credited_amount * exchange_rate),0) as total")
    ->from("erp_creditnote")
    ->where("credited_date BETWEEN :start AND :end", [":start" => $lastMonthStart, ":end" => $lastMonthEnd])
    ->queryRow();

$lastYearCR = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(credited_amount * exchange_rate),0) as total")
    ->from("erp_creditnote")
    ->where("credited_date BETWEEN :start AND :end", [":start" => $lastYearStart, ":end" => $lastYearEnd])
    ->queryRow();
?>

<div class="panel-body">

    <div class="card-row">
        <div class="label-box"></div>
        <div class="stats-boxnw">
            <div class="td-clr"><strong>Today</strong></div>
            <div class="thiswk-clr"><strong>This Week</strong></div>
            <div class="ths-mnth-clr "><strong>This Month</strong></div>
            <div class="prev-mnt-clr"><strong>Prev Month</strong></div>
            <div class="ths-yr-clr"><strong>This Year</strong></div>
            <div class="prev-yr-clr"><strong>Prev Year</strong></div>
        </div>
    </div>

<!-- Customers -->
<div class="card-row">
    <div class="label-box customers left-bg ">Customers</div>
    <div class="stats-box">
        <div class="tdy"><?php echo ($todayCustomerCount > 0) ? $todayCustomerCount : '-'; ?></div>
        <div class="this-wek"><?php echo ($weekCustomerCount > 0) ? $weekCustomerCount : '-'; ?></div>
        <div class="this-month"><?php echo ($monthCustomerCount > 0) ? $monthCustomerCount : '-'; ?></div>
        <div class="prev-mnth"><?php echo ($lastMonthCustomerCount > 0) ? $lastMonthCustomerCount : '-'; ?></div>
        <div class="ths-yer"><?php echo ($yearCustomerCount > 0) ? $yearCustomerCount : '-'; ?></div>
        <div class="prev-yer"><?php echo ($lastYearCustomerCount > 0) ? $lastYearCustomerCount : '-'; ?></div>
    </div>
</div>

<!-- Leads -->
<div class="card-row">
    <div class="label-box leads left-bg ">Leads</div>
    <div class="stats-box">
        <div class="tdy">
            <span><?php echo ($todayLead['count'] > 0) ? $todayLead['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($todayLead['total'] > 0) ? number_format($todayLead['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="this-wek">
            <span><?php echo ($weekLead['count'] > 0) ? $weekLead['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($weekLead['total'] > 0) ? number_format($weekLead['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="this-month">
            <span><?php echo ($monthLead['count'] > 0) ? $monthLead['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($monthLead['total'] > 0) ? number_format($monthLead['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="prev-mnth">
            <span><?php echo ($lastMonthLead['count'] > 0) ? $lastMonthLead['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($lastMonthLead['total'] > 0) ? number_format($lastMonthLead['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="ths-yer">
            <span><?php echo ($yearLead['count'] > 0) ? $yearLead['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($yearLead['total'] > 0) ? number_format($yearLead['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="prev-yer">
            <span><?php echo ($lastYearLead['count'] > 0) ? $lastYearLead['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($lastYearLead['total'] > 0) ? number_format($lastYearLead['total'], 2) : '-'; ?></small></span>
        </div>
    </div>
</div>

<!-- Quotes -->
<div class="card-row">
    <div class="label-box quotes left-bg ">Quotations</div>
    <div class="stats-box">
        <div class="tdy">
            <span><?php echo ($todayQuote['count'] > 0) ? $todayQuote['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($todayQuote['total'] > 0) ? number_format($todayQuote['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="this-wek">
            <span><?php echo ($weekQuote['count'] > 0) ? $weekQuote['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($weekQuote['total'] > 0) ? number_format($weekQuote['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="this-month">
            <span><?php echo ($monthQuote['count'] > 0) ? $monthQuote['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($monthQuote['total'] > 0) ? number_format($monthQuote['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="prev-mnth">
            <span><?php echo ($lastMonthQuote['count'] > 0) ? $lastMonthQuote['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($lastMonthQuote['total'] > 0) ? number_format($lastMonthQuote['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="ths-yer">
            <span><?php echo ($yearQuote['count'] > 0) ? $yearQuote['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($yearQuote['total'] > 0) ? number_format($yearQuote['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="prev-yer">
            <span><?php echo ($lastYearQuote['count'] > 0) ? $lastYearQuote['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($lastYearQuote['total'] > 0) ? number_format($lastYearQuote['total'], 2) : '-'; ?></small></span>
        </div>
    </div>
</div>

<!-- Orders -->
<div class="card-row">
    <div class="label-box quotes left-bg ">Order</div>
    <div class="stats-box">
        <div class="tdy">
            <span><?php echo ($todayOrder['count'] > 0) ? $todayOrder['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($todayOrder['total'] > 0) ? number_format($todayOrder['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="this-wek">
            <span><?php echo ($weekOrder['count'] > 0) ? $weekOrder['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($weekOrder['total'] > 0) ? number_format($weekOrder['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="this-month">
            <span><?php echo ($monthOrder['count'] > 0) ? $monthOrder['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($monthOrder['total'] > 0) ? number_format($monthOrder['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="prev-mnth">
            <span><?php echo ($lastMonthOrder['count'] > 0) ? $lastMonthOrder['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($lastMonthOrder['total'] > 0) ? number_format($lastMonthOrder['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="ths-yer">
            <span><?php echo ($yearOrder['count'] > 0) ? $yearOrder['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($yearOrder['total'] > 0) ? number_format($yearOrder['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="prev-yer">
            <span><?php echo ($lastYearOrder['count'] > 0) ? $lastYearOrder['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($lastYearOrder['total'] > 0) ? number_format($lastYearOrder['total'], 2) : '-'; ?></small></span>
        </div>
    </div>
</div>

<!-- Invoices -->
<div class="card-row">
    <div class="label-box invoices left-bg ">Invoices</div>
    <div class="stats-box">
        <div class="tdy">
            <span><?php echo ($todayInvoice['count'] > 0) ? $todayInvoice['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($todayInvoice['total'] > 0) ? number_format($todayInvoice['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="this-wek">
            <span><?php echo ($weekInvoice['count'] > 0) ? $weekInvoice['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($weekInvoice['total'] > 0) ? number_format($weekInvoice['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="this-month">
            <span><?php echo ($monthInvoice['count'] > 0) ? $monthInvoice['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($monthInvoice['total'] > 0) ? number_format($monthInvoice['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="prev-mnth">
            <span><?php echo ($lastMonthInvoice['count'] > 0) ? $lastMonthInvoice['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($lastMonthInvoice['total'] > 0) ? number_format($lastMonthInvoice['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="ths-yer">
            <span><?php echo ($yearInvoice['count'] > 0) ? $yearInvoice['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($yearInvoice['total'] > 0) ? number_format($yearInvoice['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="prev-yer">
            <span><?php echo ($lastYearInvoice['count'] > 0) ? $lastYearInvoice['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($lastYearInvoice['total'] > 0) ? number_format($lastYearInvoice['total'], 2) : '-'; ?></small></span>
        </div>
    </div>
</div>

<!-- Credit Note -->
<div class="card-row">
    <div class="label-box invoices left-bg ">Credit Note</div>
    <div class="stats-box">
        <div class="tdy">
            <span><?php echo ($todayCR['count'] > 0) ? $todayCR['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($todayCR['total'] > 0) ? number_format($todayCR['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="this-wek">
            <span><?php echo ($weekCR['count'] > 0) ? $weekCR['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($weekCR['total'] > 0) ? number_format($weekCR['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="this-month">
            <span><?php echo ($monthCR['count'] > 0) ? $monthCR['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($monthCR['total'] > 0) ? number_format($monthCR['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="prev-mnth">
            <span><?php echo ($lastMonthCR['count'] > 0) ? $lastMonthCR['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($lastMonthCR['total'] > 0) ? number_format($lastMonthCR['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="ths-yer">
            <span><?php echo ($yearCR['count'] > 0) ? $yearCR['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($yearCR['total'] > 0) ? number_format($yearCR['total'], 2) : '-'; ?></small></span>
        </div>
        <div class="prev-yer">
            <span><?php echo ($lastYearCR['count'] > 0) ? $lastYearCR['count'] : '-'; ?></span>
            <span class="spn-last"><small><?php echo ($lastYearCR['total'] > 0) ? number_format($lastYearCR['total'], 2) : '-'; ?></small></span>
        </div>
    </div>
</div>


</div>