<?php
$todayStart = date('Y-m-d 00:00:00');
$todayEnd = date('Y-m-d 23:59:59');
$weekStart = date('Y-m-d 00:00:00', strtotime('monday this week'));
$weekEnd = date('Y-m-d 23:59:59', strtotime('sunday this week'));
$monthStart = date('Y-m-01 00:00:00');
$monthEnd = date('Y-m-t 23:59:59');
$yearStart = date('Y-01-01 00:00:00');
$yearEnd = date('Y-12-31 23:59:59');
$lastMonthStart = date('Y-m-01 00:00:00', strtotime('first day of last month'));
$lastMonthEnd = date('Y-m-t 23:59:59', strtotime('last day of last month'));

$currentYear = date("Y");
$lastYear = $currentYear - 1;
$lastYearStart = $lastYear . '-01-01 00:00:00';
$lastYearEnd = $lastYear . '-12-31 23:59:59';

// Store

$todayStoreCount = Store::model()->count("created_date_time BETWEEN :start AND :end", [":start" => $todayStart, ":end" => $todayEnd]);
$weekStoreCount = Store::model()->count("created_date_time BETWEEN :start AND :end", [":start" => $weekStart, ":end" => $weekEnd]);
$monthStoreCount = Store::model()->count("created_date_time BETWEEN :start AND :end", [":start" => $monthStart, ":end" => $monthEnd]);
$yearStoreCount = Store::model()->count("created_date_time BETWEEN :start AND :end", [":start" => $yearStart, ":end" => $yearEnd]);
$lastMonthStoreCount = Store::model()->count("created_date_time BETWEEN :start AND :end", [":start" => $lastMonthStart, ":end" => $lastMonthEnd]);
$lastYearStoreCount = Store::model()->count("created_date_time BETWEEN :start AND :end", [":start" => $lastYearStart, ":end" => $lastYearEnd]);

// GI

$todayGI = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $todayStart, ":end" => $todayEnd])
  ->andWhere("transaction_from = 'GOODS_ISSUE'")
  ->queryRow();

$weekGI = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $weekStart, ":end" => $weekEnd])
  ->andWhere("transaction_from = 'GOODS_ISSUE'")
  ->queryRow();

$monthGI = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $monthStart, ":end" => $monthEnd])
  ->andWhere("transaction_from = 'GOODS_ISSUE'")
  ->queryRow();

$yearGI = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $yearStart, ":end" => $yearEnd])
  ->andWhere("transaction_from = 'GOODS_ISSUE'")
  ->queryRow();

$lastMonthGI = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $lastMonthStart, ":end" => $lastMonthEnd])
  ->andWhere("transaction_from = 'GOODS_ISSUE'")
  ->queryRow();

$lastYearGI = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $lastYearStart, ":end" => $lastYearEnd])
  ->andWhere("transaction_from = 'GOODS_ISSUE'")
  ->queryRow();

// GR

$todayGR = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $todayStart, ":end" => $todayEnd])
  ->andWhere("transaction_from = 'GOODS_RECEIPT'")
  ->queryRow();

$weekGR = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $weekStart, ":end" => $weekEnd])
  ->andWhere("transaction_from = 'GOODS_RECEIPT'")
  ->queryRow();

$monthGR = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $monthStart, ":end" => $monthEnd])
  ->andWhere("transaction_from = 'GOODS_RECEIPT'")
  ->queryRow();

$yearGR = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $yearStart, ":end" => $yearEnd])
  ->andWhere("transaction_from = 'GOODS_RECEIPT'")
  ->queryRow();

$lastMonthGR = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $lastMonthStart, ":end" => $lastMonthEnd])
  ->andWhere("transaction_from = 'GOODS_RECEIPT'")
  ->queryRow();

$lastYearGR = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $lastYearStart, ":end" => $lastYearEnd])
  ->andWhere("transaction_from = 'GOODS_RECEIPT'")
  ->queryRow();

// DIRIN

$todayDIRIN = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $todayStart, ":end" => $todayEnd])
  ->andWhere("transaction_from = 'DIRECT_TRANSFER_IN'")
  ->queryRow();

$weekDIRIN = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $weekStart, ":end" => $weekEnd])
  ->andWhere("transaction_from = 'DIRECT_TRANSFER_IN'")
  ->queryRow();

$monthDIRIN = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $monthStart, ":end" => $monthEnd])
  ->andWhere("transaction_from = 'DIRECT_TRANSFER_IN'")
  ->queryRow();

$yearDIRIN = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $yearStart, ":end" => $yearEnd])
  ->andWhere("transaction_from = 'DIRECT_TRANSFER_IN'")
  ->queryRow();

$lastMonthDIRIN = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $lastMonthStart, ":end" => $lastMonthEnd])
  ->andWhere("transaction_from = 'DIRECT_TRANSFER_IN'")
  ->queryRow();

$lastYearDIRIN = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $lastYearStart, ":end" => $lastYearEnd])
  ->andWhere("transaction_from = 'DIRECT_TRANSFER_IN'")
  ->queryRow();

// DIROUT

$todayDIROUT = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $todayStart, ":end" => $todayEnd])
  ->andWhere("transaction_from = 'TRANSFER_OUT'")
  ->queryRow();

$weekDIROUT = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $weekStart, ":end" => $weekEnd])
  ->andWhere("transaction_from = 'TRANSFER_OUT'")
  ->queryRow();

$monthDIROUT = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $monthStart, ":end" => $monthEnd])
  ->andWhere("transaction_from = 'TRANSFER_OUT'")
  ->queryRow();

$yearDIROUT = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $yearStart, ":end" => $yearEnd])
  ->andWhere("transaction_from = 'TRANSFER_OUT'")
  ->queryRow();

$lastMonthDIROUT = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $lastMonthStart, ":end" => $lastMonthEnd])
  ->andWhere("transaction_from = 'TRANSFER_OUT'")
  ->queryRow();

$lastYearDIROUT = Yii::app()->db->createCommand()
  ->select("COUNT(*) as count, IFNULL(SUM(ABS(quantity * unit_factor) * cost_price), 0) as total")
  ->from("erp_stock_ledger")
  ->where("transaction_date BETWEEN :start AND :end", [":start" => $lastYearStart, ":end" => $lastYearEnd])
  ->andWhere("transaction_from = 'TRANSFER_OUT'")
  ->queryRow();

?>
<div class="panel-body">

  <!-- Header Row -->
  <div class="card-row">
    <div class="label-box"></div>
    <div class="stats-boxnw">
      <div class="td-clr"><strong>Today</strong></div>
      <div class="thiswk-clr"><strong>This Week</strong></div>
      <div class="ths-mnth-clr"><strong>This Month</strong></div>
      <div class="prev-mnt-clr"><strong>Prev Month</strong></div>
      <div class="ths-yr-clr"><strong>This Year</strong></div>
      <div class="prev-yr-clr"><strong>Prev Year</strong></div>
    </div>
  </div>

  <!-- Inventory -->
  <div class="card-row">
    <div class="label-box leads left-bg">Inventory</div>
    <div class="stats-box">
      <div class="tdy"><span><?php echo ($todayStoreCount > 0) ? $todayStoreCount : '-'; ?></span></div>
      <div class="this-wek"><span><?php echo ($weekStoreCount > 0) ? $weekStoreCount : '-'; ?></span></div>
      <div class="this-month"><span><?php echo ($monthStoreCount > 0) ? $monthStoreCount : '-'; ?></span></div>
      <div class="prev-mnth"><span><?php echo ($lastMonthStoreCount > 0) ? $lastMonthStoreCount : '-'; ?></span></div>
      <div class="ths-yer"><span><?php echo ($yearStoreCount > 0) ? $yearStoreCount : '-'; ?></span></div>
      <div class="prev-yer"><span><?php echo ($lastYearStoreCount > 0) ? $lastYearStoreCount : '-'; ?></span></div>
    </div>
  </div>

  <!-- Goods Issues -->
  <div class="card-row">
    <div class="label-box leads left-bg">Goods Issues</div>
    <div class="stats-box">
      <div class="tdy">
        <span><?php echo ($todayGI['count'] > 0) ? $todayGI['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($todayGI['total'] > 0) ? number_format($todayGI['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="this-wek">
        <span><?php echo ($weekGI['count'] > 0) ? $weekGI['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($weekGI['total'] > 0) ? number_format($weekGI['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="this-month">
        <span><?php echo ($monthGI['count'] > 0) ? $monthGI['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($monthGI['total'] > 0) ? number_format($monthGI['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="prev-mnth">
        <span><?php echo ($lastMonthGI['count'] > 0) ? $lastMonthGI['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($lastMonthGI['total'] > 0) ? number_format($lastMonthGI['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="ths-yer">
        <span><?php echo ($yearGI['count'] > 0) ? $yearGI['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($yearGI['total'] > 0) ? number_format($yearGI['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="prev-yer">
        <span><?php echo ($lastYearGI['count'] > 0) ? $lastYearGI['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($lastYearGI['total'] > 0) ? number_format($lastYearGI['total'], 2) : '-'; ?></small></span>
      </div>
    </div>
  </div>

  <!-- Goods Receipts -->
  <div class="card-row">
    <div class="label-box quotes left-bg">Goods Receipts</div>
    <div class="stats-box">
      <div class="tdy">
        <span><?php echo ($todayGR['count'] > 0) ? $todayGR['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($todayGR['total'] > 0) ? number_format($todayGR['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="this-wek">
        <span><?php echo ($weekGR['count'] > 0) ? $weekGR['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($weekGR['total'] > 0) ? number_format($weekGR['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="this-month">
        <span><?php echo ($monthGR['count'] > 0) ? $monthGR['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($monthGR['total'] > 0) ? number_format($monthGR['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="prev-mnth">
        <span><?php echo ($lastMonthGR['count'] > 0) ? $lastMonthGR['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($lastMonthGR['total'] > 0) ? number_format($lastMonthGR['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="ths-yer">
        <span><?php echo ($yearGR['count'] > 0) ? $yearGR['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($yearGR['total'] > 0) ? number_format($yearGR['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="prev-yer">
        <span><?php echo ($lastYearGR['count'] > 0) ? $lastYearGR['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($lastYearGR['total'] > 0) ? number_format($lastYearGR['total'], 2) : '-'; ?></small></span>
      </div>
    </div>
  </div>

  <!-- Direct Transfers IN-->
  <div class="card-row">
    <div class="label-box orders left-bg">Transfers In</div>
    <div class="stats-box">
      <div class="tdy">
        <span><?php echo ($todayDIRIN['count'] > 0) ? $todayDIRIN['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($todayDIRIN['total'] > 0) ? number_format($todayDIRIN['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="this-wek">
        <span><?php echo ($weekDIRIN['count'] > 0) ? $weekDIRIN['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($weekDIRIN['total'] > 0) ? number_format($weekDIRIN['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="this-month">
        <span><?php echo ($monthDIRIN['count'] > 0) ? $monthDIRIN['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($monthDIRIN['total'] > 0) ? number_format($monthDIRIN['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="prev-mnth">
        <span><?php echo ($lastMonthDIRIN['count'] > 0) ? $lastMonthDIRIN['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($lastMonthDIRIN['total'] > 0) ? number_format($lastMonthDIRIN['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="ths-yer">
        <span><?php echo ($yearDIRIN['count'] > 0) ? $yearDIRIN['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($yearDIRIN['total'] > 0) ? number_format($yearDIRIN['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="prev-yer">
        <span><?php echo ($lastYearDIRIN['count'] > 0) ? $lastYearDIRIN['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($lastYearDIRIN['total'] > 0) ? number_format($lastYearDIRIN['total'], 2) : '-'; ?></small></span>
      </div>
    </div>
  </div>

  <!-- Direct Transfers OUT-->
  <div class="card-row">
    <div class="label-box orders left-bg">Transfers Out</div>
    <div class="stats-box">
      <div class="tdy">
        <span><?php echo ($todayDIROUT['count'] > 0) ? $todayDIROUT['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($todayDIROUT['total'] > 0) ? number_format($todayDIROUT['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="this-wek">
        <span><?php echo ($weekDIROUT['count'] > 0) ? $weekDIROUT['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($weekDIROUT['total'] > 0) ? number_format($weekDIROUT['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="this-month">
        <span><?php echo ($monthDIROUT['count'] > 0) ? $monthDIROUT['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($monthDIROUT['total'] > 0) ? number_format($monthDIROUT['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="prev-mnth">
        <span><?php echo ($lastMonthDIROUT['count'] > 0) ? $lastMonthDIROUT['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($lastMonthDIROUT['total'] > 0) ? number_format($lastMonthDIROUT['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="ths-yer">
        <span><?php echo ($yearDIROUT['count'] > 0) ? $yearDIROUT['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($yearDIROUT['total'] > 0) ? number_format($yearDIROUT['total'], 2) : '-'; ?></small></span>
      </div>
      <div class="prev-yer">
        <span><?php echo ($lastYearDIROUT['count'] > 0) ? $lastYearDIROUT['count'] : '-'; ?></span>
        <span
          class="spn-last"><small><?php echo ($lastYearDIROUT['total'] > 0) ? number_format($lastYearDIROUT['total'], 2) : '-'; ?></small></span>
      </div>
    </div>
  </div>

</div>