<?php
$todayStart = date('Y-m-d 00:00:00');
$todayEnd = date('Y-m-d 23:59:59');
$weekStart = date('Y-m-d 00:00:00', strtotime('monday this week'));
$weekEnd = date('Y-m-d 23:59:59', strtotime('sunday this week'));
$monthStart = date('Y-m-01 00:00:00');
$monthEnd = date('Y-m-t 23:59:59');
$yearStart = date('Y-01-01 00:00:00');
$yearEnd = date('Y-12-31 23:59:59');
$lastMonthStart = date('Y-m-01 00:00:00', strtotime('first day of last month'));
$lastMonthEnd = date('Y-m-t 23:59:59', strtotime('last day of last month'));

$currentYear = date("Y");
$lastYear = $currentYear - 1;
$lastYearStart = $lastYear . '-01-01 00:00:00';
$lastYearEnd = $lastYear . '-12-31 23:59:59';
$modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
$ledgerDebtors = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
$subledgerTypeC = (new AccSubledgerType())->getIdFromType('C');

// Today
$todayAR = Yii::app()->db->createCommand("
    SELECT SUM(amount) FROM {{acc_voucher_items}} I
    INNER JOIN {{acc_subledger}} S ON I.subledger_id=S.id
    WHERE ledger_id='$ledgerDebtors' 
      AND subledger_type='$subledgerTypeC'
")->queryScalar() ?: 0;



$ledgerCreditors = $modelAccSystemAccountsMapping->getSystemdefault('creditors');
$subledgerTypeV = (new AccSubledgerType())->getIdFromType('V');
$todayAP = Yii::app()->db->createCommand("SELECT SUM(amount) FROM {{acc_voucher_items}} I INNER JOIN {{acc_subledger}} S ON I.subledger_id=S.id WHERE ledger_id='$ledgerCreditors' AND subledger_type='$subledgerTypeV'")->queryScalar() ?: 0;
$todayCash = Yii::app()->db->createCommand("SELECT SUM(amount*exchange_rate) FROM erp_acc_voucher_items I LEFT JOIN erp_acc_ledger L ON L.id=I.ledger_id WHERE L.classification='CASH'")->queryScalar() ?: 0;
$todayBank = Yii::app()->db->createCommand("SELECT SUM(amount*exchange_rate) FROM erp_acc_voucher_items I LEFT JOIN erp_acc_ledger L ON L.id=I.ledger_id WHERE L.classification='BANK'")->queryScalar() ?: 0;


$target_ledgers = ['ASSET', 'Trade Debtors', 'Inventory', 'Current Liability', 'VAT Payables', 'NET PROFIT'];
$highlight_ledgers = [];
$netprofit_ledgers = [];
$sql = "SELECT id,level,root,ledger_main_acc,is_parent,ledger_acc_name,ledger_acc_no,have_subledger  FROM  {{acc_ledger}} ORDER BY {{acc_ledger}}.`ledger_acc_no`  ASC";
$level = 3;
if ($level > 0) {

  $sql = "SELECT id,level,root,ledger_main_acc,is_parent,ledger_acc_name,ledger_acc_no,have_subledger  FROM  {{acc_ledger}} 

        WHERE ledger_main_acc IN ('A','L','NP') AND level<=" . $level . "

        ORDER BY {{acc_ledger}}.`ledger_acc_no`  ASC";

}

$arr_ledgers = Yii::app()->db->createCommand($sql)->queryAll();
foreach ($arr_ledgers as $eachledger) {
  $ledger_name = $eachledger['ledger_acc_name'];
  if (in_array($ledger_name, $target_ledgers)) {
    $debit = $credit = $netamount = 0.00;
    if ($eachledger['ledger_acc_name'] == 'Trade Debtors') {
      $ledger_name = 'Debtors';
    }
    if ($eachledger['ledger_acc_name'] == 'ASSET') {
      $ledger_name = 'Assets';
    }
    if ($eachledger['ledger_main_acc'] == 'NP') {
      // --- Special case: NET PROFIT ---
      $sql_net_profit_today = "SELECT SUM(debit + credit) AS amount 
                               FROM view_account_voucher_items  
                               WHERE ledger_main_acc IN ('I','E') 
                                 AND is_posted='Y'  
                                 AND voucher_date <= :todayEnd";

      $net_profit_today = Yii::app()->db->createCommand($sql_net_profit_today)
        ->bindValue(':todayEnd', $todayEnd)
        ->queryScalar();

      if ($net_profit_today > 0) {
        $debit = $net_profit_today;
      } else {
        $credit = $net_profit_today;
      }

      $amount = abs($debit ?: $credit);
      $formattedAmount = Yii::app()->numberFormatter->formatCurrency($amount, "");

      if ($debit > 0) {
        $formattedAmount .= " Dr.";
      } elseif ($credit) {
        $formattedAmount .= " Cr.";
      }

      // Push NET PROFIT separately
      $netprofit_ledgers[] = [
        'name' => $ledger_name,
        'amount' => $formattedAmount
      ];

    } else {
      // --- Other ledgers (Assets, Liabilities, etc.) ---
      $condition1 = "level >= :level AND root LIKE :root 
                     AND voucher_date <= :todayEnd AND is_posted = 'Y'";

      $sqlVI = "SELECT IFNULL(SUM(debit + credit), 0) AS amount 
                FROM view_account_voucher_items 
                WHERE $condition1";

      $command = Yii::app()->db->createCommand($sqlVI);
      $command->bindValues([
        ':level' => $eachledger['level'],
        ':root' => $eachledger['root'] . '%',
        ':todayEnd' => $todayEnd
      ]);

      $netamount = $command->queryScalar();

      if ($netamount > 0) {
        $debit = $netamount;
      } else {
        $credit = $netamount;
      }

      $amount = abs($debit ?: $credit);
      $formattedAmount = Yii::app()->numberFormatter->formatCurrency($amount, "");

      if ($debit > 0) {
        $formattedAmount .= " Dr.";
      } elseif ($credit) {
        $formattedAmount .= " Cr.";
      }

      $highlight_ledgers[] = [
        'name' => $ledger_name,
        'amount' => $formattedAmount
      ];
    }
  }
}


$accounts = [
  'DIRECT EXPENSES',
  'GROSS PROFIT',
  'INDIRECT EXPENSES',
  'INDIRECT INCOME',
  'EARNINGS BEFORE INTEREST AND TAXES - EBIT',
];

$sql = "SELECT id,level,root,ledger_main_acc,is_parent,ledger_acc_name,ledger_acc_no,have_subledger FROM {{acc_ledger}} ORDER BY {{acc_ledger}}.`ledger_acc_no`  ASC";
$level = 2;
if ($level > 0) {

  $sql = "SELECT id,level,root,ledger_main_acc,is_parent,ledger_acc_name,ledger_acc_no,have_subledger FROM {{acc_ledger}} 

                WHERE ledger_main_acc IN ('I','E','GP','NP','EB') AND

                level<=" . $level . "

                ORDER BY {{acc_ledger}}.`ledger_acc_no`  ASC";
}

$arr_ledgers = Yii::app()->db->createCommand($sql)->queryAll();
$highlight_ledgers_profit = [];

foreach ($arr_ledgers as $eachledger) {
  $ledger_name = $eachledger['ledger_acc_name'];
  $name = $eachledger['ledger_acc_name'];

  if ($eachledger['ledger_acc_name'] == 'EARNINGS BEFORE INTEREST AND TAXES - EBIT') {
    $name = 'EBIT';
  }
  if ($eachledger['ledger_acc_name'] == 'INDIRECT EXPENSES') {
    $name = 'Ind. Expenses';
  }
  if ($eachledger['ledger_acc_name'] == 'INDIRECT INCOME') {
    $name = 'Ind. Income';
  }

  if (in_array($ledger_name, $accounts)) {

    // Initialize amounts
    $tdy = $thiswk = $thismonth = $lastmonth = $thisyear = $lastyear = 0;

    // Condition common
    $common_condition = "is_posted='Y'";

    // Today
    if ($eachledger['ledger_main_acc'] == 'NP') {
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND voucher_date BETWEEN '$todayStart' AND '$todayEnd' 
                    AND $common_condition";
      $tdy = Yii::app()->db->createCommand($sql)->queryScalar();
    } else if ($eachledger['ledger_main_acc'] == 'GP') {
      $gp_acc = $eachledger['ledger_acc_no'];
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND ledger_acc_no <= $gp_acc 
                    AND voucher_date >= '$todayStart' AND voucher_date <='$todayEnd' 
                    AND $common_condition";
      $tdy = Yii::app()->db->createCommand($sql)->queryScalar();
    } else if ($eachledger['ledger_main_acc'] == 'EB') {
      $eb_acc = $eachledger['ledger_acc_no'];
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND ledger_acc_no <= $eb_acc 
                    AND voucher_date BETWEEN '$todayStart' AND '$todayEnd' 
                    AND $common_condition";
      $tdy = Yii::app()->db->createCommand($sql)->queryScalar();
    } else {
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE level >= {$eachledger['level']} 
                    AND root LIKE '{$eachledger['root']}%' 
                    AND voucher_date BETWEEN '$todayStart' AND '$todayEnd' 
                    AND $common_condition";
      $tdy = Yii::app()->db->createCommand($sql)->queryScalar();
    }

    // This Week
    if ($eachledger['ledger_main_acc'] == 'NP') {
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND voucher_date BETWEEN '$weekStart' AND '$weekEnd' 
                    AND $common_condition";
      $thiswk = Yii::app()->db->createCommand($sql)->queryScalar();
    } else if ($eachledger['ledger_main_acc'] == 'GP') {
      $gp_acc = $eachledger['ledger_acc_no'];
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND ledger_acc_no <= $gp_acc 
                    AND voucher_date BETWEEN '$weekStart' AND '$weekEnd' 
                    AND $common_condition";
      $thiswk = Yii::app()->db->createCommand($sql)->queryScalar();
    } else if ($eachledger['ledger_main_acc'] == 'EB') {
      $eb_acc = $eachledger['ledger_acc_no'];
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND ledger_acc_no <= $eb_acc 
                    AND voucher_date BETWEEN '$weekStart' AND '$weekEnd' 
                    AND $common_condition";
      $thiswk = Yii::app()->db->createCommand($sql)->queryScalar();
    } else {
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE level >= {$eachledger['level']} 
                    AND root LIKE '{$eachledger['root']}%' 
                    AND voucher_date BETWEEN '$weekStart' AND '$weekEnd' 
                    AND $common_condition";
      $thiswk = Yii::app()->db->createCommand($sql)->queryScalar();
    }

    // This Month
    if ($eachledger['ledger_main_acc'] == 'NP') {
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND voucher_date BETWEEN '$monthStart' AND '$monthEnd' 
                    AND $common_condition";
      $thismonth = Yii::app()->db->createCommand($sql)->queryScalar();
    } else if ($eachledger['ledger_main_acc'] == 'GP') {
      $gp_acc = $eachledger['ledger_acc_no'];
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND ledger_acc_no <= $gp_acc 
                    AND voucher_date BETWEEN '$monthStart' AND '$monthEnd' 
                    AND $common_condition";
      $thismonth = Yii::app()->db->createCommand($sql)->queryScalar();
    } else if ($eachledger['ledger_main_acc'] == 'EB') {
      $eb_acc = $eachledger['ledger_acc_no'];
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND ledger_acc_no <= $eb_acc 
                    AND voucher_date BETWEEN '$monthStart' AND '$monthEnd' 
                    AND $common_condition";
      $thismonth = Yii::app()->db->createCommand($sql)->queryScalar();
    } else {
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE level >= {$eachledger['level']} 
                    AND root LIKE '{$eachledger['root']}%' 
                    AND voucher_date BETWEEN '$monthStart' AND '$monthEnd' 
                    AND $common_condition";
      $thismonth = Yii::app()->db->createCommand($sql)->queryScalar();
    }

    // Last Month
    if ($eachledger['ledger_main_acc'] == 'NP') {
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND voucher_date BETWEEN '$lastMonthStart' AND '$lastMonthEnd' 
                    AND $common_condition";
      $lastmonth = Yii::app()->db->createCommand($sql)->queryScalar();
    } else if ($eachledger['ledger_main_acc'] == 'GP') {
      $gp_acc = $eachledger['ledger_acc_no'];
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND ledger_acc_no <= $gp_acc 
                    AND voucher_date BETWEEN '$lastMonthStart' AND '$lastMonthEnd' 
                    AND $common_condition";
      $lastmonth = Yii::app()->db->createCommand($sql)->queryScalar();
    } else if ($eachledger['ledger_main_acc'] == 'EB') {
      $eb_acc = $eachledger['ledger_acc_no'];
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND ledger_acc_no <= $eb_acc 
                    AND voucher_date BETWEEN '$lastMonthStart' AND '$lastMonthEnd' 
                    AND $common_condition";
      $lastmonth = Yii::app()->db->createCommand($sql)->queryScalar();
    } else {
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE level >= {$eachledger['level']} 
                    AND root LIKE '{$eachledger['root']}%' 
                    AND voucher_date BETWEEN '$lastMonthStart' AND '$lastMonthEnd' 
                    AND $common_condition";
      $lastmonth = Yii::app()->db->createCommand($sql)->queryScalar();
    }


    // This Year
    if ($eachledger['ledger_main_acc'] == 'NP') {
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND voucher_date BETWEEN '$yearStart' AND '$yearEnd' 
                    AND $common_condition";
      $thisyear = Yii::app()->db->createCommand($sql)->queryScalar();
    } else if ($eachledger['ledger_main_acc'] == 'GP') {
      $gp_acc = $eachledger['ledger_acc_no'];
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND ledger_acc_no <= $gp_acc 
                    AND voucher_date BETWEEN '$yearStart' AND '$yearEnd' 
                    AND $common_condition";
      $thisyear = Yii::app()->db->createCommand($sql)->queryScalar();
    } else if ($eachledger['ledger_main_acc'] == 'EB') {
      $eb_acc = $eachledger['ledger_acc_no'];
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND ledger_acc_no <= $eb_acc 
                    AND voucher_date BETWEEN '$yearStart' AND '$yearEnd' 
                    AND $common_condition";
      $thisyear = Yii::app()->db->createCommand($sql)->queryScalar();
    } else {
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE level >= {$eachledger['level']} 
                    AND root LIKE '{$eachledger['root']}%' 
                    AND voucher_date BETWEEN '$yearStart' AND '$yearEnd' 
                    AND $common_condition";
      $thisyear = Yii::app()->db->createCommand($sql)->queryScalar();
    }


    // Last Year
    if ($eachledger['ledger_main_acc'] == 'NP') {
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND voucher_date BETWEEN '$yearStart' AND '$lastYearEnd' 
                    AND $common_condition";
      $lastyear = Yii::app()->db->createCommand($sql)->queryScalar();
    } else if ($eachledger['ledger_main_acc'] == 'GP') {
      $gp_acc = $eachledger['ledger_acc_no'];
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND ledger_acc_no <= $gp_acc 
                    AND voucher_date BETWEEN '$yearStart' AND '$lastYearEnd' 
                    AND $common_condition";
      $lastyear = Yii::app()->db->createCommand($sql)->queryScalar();
    } else if ($eachledger['ledger_main_acc'] == 'EB') {
      $eb_acc = $eachledger['ledger_acc_no'];
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE ledger_main_acc IN ('I','E') 
                    AND ledger_acc_no <= $eb_acc 
                    AND voucher_date BETWEEN '$yearStart' AND '$lastYearEnd' 
                    AND $common_condition";
      $lastyear = Yii::app()->db->createCommand($sql)->queryScalar();
    } else {
      $sql = "SELECT IFNULL(SUM(debit+credit),0) 
                    FROM view_account_voucher_items 
                    WHERE level >= {$eachledger['level']} 
                    AND root LIKE '{$eachledger['root']}%' 
                    AND voucher_date BETWEEN '$yearStart' AND '$lastYearEnd' 
                    AND $common_condition";
      $lastyear = Yii::app()->db->createCommand($sql)->queryScalar();
    }

    $highlight_ledgers_profit[] = [
      'name' => $name,
      'tdy' => Yii::app()->numberFormatter->formatCurrency(abs($tdy), ""),
      'thiswk' => Yii::app()->numberFormatter->formatCurrency(abs($thiswk), ""),
      'thismonth' => Yii::app()->numberFormatter->formatCurrency(abs($thismonth), ""),
      'lastmonth' => Yii::app()->numberFormatter->formatCurrency(abs($lastmonth), ""),
      'thisyear' => Yii::app()->numberFormatter->formatCurrency(abs($thisyear), ""),
      'lastyear' => Yii::app()->numberFormatter->formatCurrency(abs($lastyear), "")
    ];
  }
}


?>

<div class="panel-body">

  <!-- Same Dashboard Content -->
  <div class="card-row">
    <div class="label-box"></div>
    <div class="stats-boxnw">
      <div class="td-clr"><strong>Today</strong></div>
      <div class="thiswk-clr"><strong>This Week</strong></div>
      <div class="ths-mnth-clr "><strong>This Month</strong></div>
      <div class="prev-mnt-clr"><strong>Prev Month</strong></div>
      <div class="ths-yr-clr"><strong>This Year</strong></div>
      <div class="prev-yr-clr"><strong>Prev Year</strong></div>
    </div>
  </div>

  <!-- Accounts Receivable -->
  <div class="card-row">
    <div class="label-box customers left-bg ">Receivables</div>
    <div class="stats-box">
      <div class="tdy"><span class="spn-last"><?php echo (isset($todayAR)) ? number_format($todayAR, 2) : '-'; ?></span>
      </div>
      <div class="this-wek"><span class="spn-last"><?php echo ($weekAR > 0) ? number_format($weekAR, 2) : '-'; ?></span>
      </div>
      <div class="this-month"><span
          class="spn-last"><?php echo ($monthAR > 0) ? number_format($monthAR, 2) : '-'; ?></span></div>
      <div class="prev-mnth"><span
          class="spn-last"><?php echo ($lastMonthAR > 0) ? number_format($lastMonthAR, 2) : '-'; ?></span></div>
      <div class="ths-yer"><span class="spn-last"><?php echo ($yearAR > 0) ? number_format($yearAR, 2) : '-'; ?></span>
      </div>
      <div class="prev-yer"><span
          class="spn-last"><?php echo ($lastYearAR > 0) ? number_format($lastYearAR, 2) : '-'; ?></span></div>
    </div>
  </div>

  <!-- Accounts Payables -->
  <div class="card-row">
    <div class="label-box customers left-bg ">Payables</div>
    <div class="stats-box">
      <div class="tdy"><span class="spn-last"><?php echo (isset($todayAP)) ? number_format($todayAP, 2) : '-'; ?></span>
      </div>
      <div class="this-wek"><span class="spn-last"><?php echo ($weekAP > 0) ? number_format($weekAP, 2) : '-'; ?></span>
      </div>
      <div class="this-month"><span
          class="spn-last"><?php echo ($monthAP > 0) ? number_format($monthAP, 2) : '-'; ?></span></div>
      <div class="prev-mnth"><span
          class="spn-last"><?php echo ($lastMonthAP > 0) ? number_format($lastMonthAP, 2) : '-'; ?></span></div>
      <div class="ths-yer"><span class="spn-last"><?php echo ($yearAP > 0) ? number_format($yearAP, 2) : '-'; ?></span>
      </div>
      <div class="prev-yer"><span
          class="spn-last"><?php echo ($lastYearAP > 0) ? number_format($lastYearAP, 2) : '-'; ?></span></div>
    </div>
  </div>

  <!-- CASH -->
  <div class="card-row">
    <div class="label-box customers left-bg ">Cash</div>
    <div class="stats-box">
      <div class="tdy"><span
          class="spn-last"><?php echo (isset($todayCash)) ? number_format($todayCash, 2) : '-'; ?></span></div>
      <div class="this-wek"><span
          class="spn-last"><?php echo ($weekCash > 0) ? number_format($weekCash, 2) : '-'; ?></span></div>
      <div class="this-month"><span
          class="spn-last"><?php echo ($monthCash > 0) ? number_format($monthCash, 2) : '-'; ?></span></div>
      <div class="prev-mnth"><span
          class="spn-last"><?php echo ($lastMonthCash > 0) ? number_format($lastMonthCash, 2) : '-'; ?></span>
      </div>
      <div class="ths-yer"><span
          class="spn-last"><?php echo ($yearCash > 0) ? number_format($yearCash, 2) : '-'; ?></span></div>
      <div class="prev-yer"><span
          class="spn-last"><?php echo ($lastYearCash > 0) ? number_format($lastYearCash, 2) : '-'; ?></span>
      </div>
    </div>
  </div>

  <!-- BANK -->
  <div class="card-row">
    <div class="label-box customers left-bg ">Bank</div>
    <div class="stats-box">
      <div class="tdy"><span
          class="spn-last"><?php echo (isset($todayBank)) ? number_format($todayBank, 2) : '-'; ?></span></div>
      <div class="this-wek"><span
          class="spn-last"><?php echo ($weekBank > 0) ? number_format($weekBank, 2) : '-'; ?></span></div>
      <div class="this-month"><span
          class="spn-last"><?php echo ($monthBank > 0) ? number_format($monthBank, 2) : '-'; ?></span></div>
      <div class="prev-mnth"><span
          class="spn-last"><?php echo ($lastMonthBank > 0) ? number_format($lastMonthBank, 2) : '-'; ?></span>
      </div>
      <div class="ths-yer"><span
          class="spn-last"><?php echo ($yearBank > 0) ? number_format($yearBank, 2) : '-'; ?></span></div>
      <div class="prev-yer"><span
          class="spn-last"><?php echo ($lastYearBank > 0) ? number_format($lastYearBank, 2) : '-'; ?></span>
      </div>
    </div>
  </div>






  <!-- Output the card-row boxes -->
  <?php foreach ($highlight_ledgers as $highlight) { ?>

    <div class="card-row">
      <div class="label-box customers left-bg">
        <?php
        if ($highlight['name'] == 'VAT Payables') {
          echo 'VAT Payable'; 
        } else {
          echo ucwords(strtolower($highlight['name'])); // Capitalize each word
        }
        ?>
      </div>
      <div class="stats-box">
        <div class="tdy"><span class="spn-last"><?php echo $highlight['amount']; ?></span></div>
        <div class="this-wek">-</div>
        <div class="this-month">-</div>
        <div class="prev-mnth">-</div>
        <div class="ths-yer">-</div>
        <div class="prev-yer">-</div>
      </div>
    </div>
  <?php } ?>


  <?php foreach ($highlight_ledgers_profit as $highlight) { ?>
    <div class="card-row">
      <div class="label-box customers left-bg">
        <?php
        if ($highlight['name'] == 'EBIT') {
          echo $highlight['name'];
        } else {
          echo ucwords(strtolower($highlight['name']));
        }
        ?>
      </div>
      <div class="stats-box">
        <div class="tdy">
          <span
            class="spn-last"><?php echo (!empty($highlight['tdy']) && $highlight['tdy'] != 0) ? $highlight['tdy'] : '-'; ?></span>
        </div>
        <div class="this-wek">
          <span
            class="spn-last"><?php echo (!empty($highlight['thiswk']) && $highlight['thiswk'] != 0) ? $highlight['thiswk'] : '-'; ?></span>
        </div>
        <div class="this-month">
          <span
            class="spn-last"><?php echo (!empty($highlight['thismonth']) && $highlight['thismonth'] != 0) ? $highlight['thismonth'] : '-'; ?></span>
        </div>
        <div class="prev-mnth">
          <span
            class="spn-last"><?php echo (!empty($highlight['lastmonth']) && $highlight['lastmonth'] != 0) ? $highlight['lastmonth'] : '-'; ?></span>
        </div>
        <div class="ths-yer">
          <span
            class="spn-last"><?php echo (!empty($highlight['thisyear']) && $highlight['thisyear'] != 0) ? $highlight['thisyear'] : '-'; ?></span>
        </div>
        <div class="prev-yer">
          <span
            class="spn-last"><?php echo (!empty($highlight['lastyear']) && $highlight['lastyear'] != 0) ? $highlight['lastyear'] : '-'; ?></span>
        </div>
      </div>
    </div>
  <?php } ?>

  <?php foreach ($netprofit_ledgers as $highlight) { ?>
    <div class="card-row">
      <div class="label-box customers left-bg"><?php echo ucwords(strtolower($highlight['name'])); ?></div>
      <div class="stats-box">
        <div class="tdy"><span class="spn-last"><?php echo $highlight['amount']; ?></span></div>
        <div class="this-wek">-</div>
        <div class="this-month">-</div>
        <div class="prev-mnth">-</div>
        <div class="ths-yer">-</div>
        <div class="prev-yer">-</div>
      </div>
    </div>
  <?php } ?>






  <!-- End Dashboard Content -->

</div>