<?php
    $colors = [
        '5DB5A4', // Base teal
        '88CFC2', // Light mint
        'A2DCD0', // Soft aqua
        '47988B', // Deep teal
        '3E8278', // Ocean green
        '5DAFB5', // Cool blue teal
        '5DB590', // Light green-tinted
        '4F9C8F'  // Dark muted teal
    ];

    $query = 'SELECT G.brand AS brand, G.stock_value AS stock_value FROM (
                SELECT B.product_class AS brand, SUM(P.quantity) * S.rate AS stock_value
                FROM {{product_location_details}} P
                LEFT JOIN {{store}} S ON S.id = P.product_id
                LEFT JOIN {{product_class}} B ON S.brand_class_id = B.id
                GROUP BY S.id
              ) AS G GROUP BY G.brand';

    $graphdata4 = Yii::app()->db->createCommand($query)->queryAll();

    $plot = '[';
    foreach ($graphdata4 as $i => $eachdata) {
        $color = $colors[$i % count($colors)];
        $plot .= '{label:"' . $eachdata['brand'] . '", value:' . $eachdata['stock_value'] . ', color: "#' . $color . '"},';
    }
    $plot .= ']';
?>

<div class="clearfix"></div>
<br>
<div class="clearfix">
    
        <div class="col-lg-4" data-initial-class="col-lg-3" id="pieChartParent">
        <section class="panel">
            <header class="panel-heading">
               Current stock
            </header>
            <div class="panel-body text-center">
                <div class="clearfix canvas-holder">
                    <canvas id="current_stk" width="400" height="400" onclick="loadPopupModal('dashboard/current_stock_details','Current Stock','lg');"></canvas>
                </div>
            </div>
        </section>
    </div>
</div>

<script type="text/javascript">
    $(function(){
        var order_data5=<?php echo $plot;?>;
        var canvas1 =document.getElementById("current_stk");
        Chart.defaults.global.responsive = true;
        var ctx = canvas1.getContext("2d");
        var pieChart = new Chart(ctx).Pie(order_data5);
    });

    
</script>






