<?php
$fromdate = str_replace('/', '-', $fromdate);
$from_date = date("Y-m-d", strtotime($fromdate));
$todate = str_replace('/', '-', $todate);
$end_date = date("Y-m-d", strtotime($todate));
$model_lead = new Lead();
$count_lead = $model_lead->with('file')->count(array('condition' => 't.isActive="Y" AND (enq_date >= "' . $from_date . '" AND enq_date <= "' . $end_date . '")'));
$model_quote = new Quotes();
$count_quote = $model_quote->with('file')->count(array('condition' => 't.isActive="Y" AND (qtn_start_date >= "' . $from_date . '" AND qtn_start_date <= "' . $end_date . '")'));
$model_order = new Order();
$count_order = $model_order->with('file')->count(array('condition' => 't.isActive="Y" AND (order_date >= "' . $from_date . '" AND order_date <= "' . $end_date . '")'));
$model_invoice = new Invoice();
$count_invoice = $model_invoice->with('file')->count(array('condition' => 't.isActive="Y" AND (invoice_date >= "' . $from_date . '" AND invoice_date <= "' . $end_date . '")'));

$count_lead = 0;
if (Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["lead_view_all"]) {
    // View all
    $model_lead = new Lead();
    $count_lead = $model_lead->with('file')->count(array(
        'condition' => 't.isActive = "Y" AND (enq_date >= :from_date AND enq_date <= :end_date)',
        'params' => array(
            ':from_date' => $from_date,
            ':end_date' => $end_date
        )
    ));
} elseif ((int) Yii::app()->user->havePermissionOn["lead_view"]) {
    // View only own leads
    $model_lead = new Lead();
    $count_lead = $model_lead->with('file')->count(array(
        'condition' => 't.isActive = "Y" 
                        AND (enq_date >= :from_date AND enq_date <= :end_date) 
                        AND t.lead_owner_id = :lead_owner_id',
        'params' => array(
            ':from_date' => $from_date,
            ':end_date' => $end_date,
            ':lead_owner_id' => Yii::app()->user->id
        )
    ));
}
// else: no permission → $count_lead stays 0


// Quote Count
$count_quote = 0;
if (Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["quotes_view_all"]) {
    // View all
    $model_quote = new Quotes();
    $count_quote = $model_quote->with('file')->count(array(
        'condition' => 't.isActive = "Y" AND (qtn_start_date >= :from_date AND qtn_start_date <= :end_date)',
        'params' => array(
            ':from_date' => $from_date,
            ':end_date' => $end_date
        )
    ));
} elseif ((int) Yii::app()->user->havePermissionOn["quotes_view"]) {
    // View only own quotes
    $model_quote = new Quotes();
    $count_quote = $model_quote->with('file')->count(array(
        'condition' => 't.isActive = "Y" 
                        AND (qtn_start_date >= :from_date AND qtn_start_date <= :end_date) 
                        AND t.lead_owner_id = :lead_owner_id',
        'params' => array(
            ':from_date' => $from_date,
            ':end_date' => $end_date,
            ':lead_owner_id' => Yii::app()->user->id
        )
    ));
}

// Order Count
$count_order = 0;
if (Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["order_view"]) {
    $model_order = new Order();
    $count_order = $model_order->with('file')->count(array(
        'condition' => 't.isActive = "Y" AND (order_date >= :from_date AND order_date <= :end_date)',
        'params' => array(
            ':from_date' => $from_date,
            ':end_date' => $end_date
        )
    ));
}
// else: no permission → $count_order stays 0


// Invoice Count
$count_invoice = 0;
if (Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["invoice_view"]) {
    $model_invoice = new Invoice();
    $count_invoice = $model_invoice->with('file')->count(array(
        'condition' => 't.isActive = "Y" AND (invoice_date >= :from_date AND invoice_date <= :end_date)',
        'params' => array(
            ':from_date' => $from_date,
            ':end_date' => $end_date
        )
    ));
}
// else: no permission → $count_invoice stays 0


?>
<div class="clearfix"></div>
<br>
<a href="javascript:void(0)">
    <div class="col-lg-3 col-sm-6 wdth-20">
        <section class="panel count-wrp">

            <div class="value">
                <h1 class="count" id="lead_count"><?php echo $count_lead; ?></h1>
                <p>Total Leads
            </div>
        </section>
    </div>
</a>
<a href="javascript:void(0)">
    <div class="col-lg-3 col-sm-6 wdth-20">
        <section class="panel count-wrp">

            <div class="value">
                <h1 class="count" id="quote_count"><?php echo $count_quote; ?></h1>
                <p>Total Quotes</p>
            </div>
        </section>
    </div>
</a>
<a href="javascript:void(0)">
    <div class="col-lg-3 col-sm-6 wdth-20">
        <section class="panel count-wrp">

            <div class="value">
                <h1 class="count" id="order_count"><?php echo $count_order; ?></h1>
                <p>Total Orders</p>
            </div>
        </section>
    </div>
</a>
<a href="javascript:void(0)">
    <div class="col-lg-3 col-sm-6 wdth-20">
        <section class="panel count-wrp">

            <div class="value">
                <h1 class="count" id="invoice_count"><?php echo $count_invoice; ?></h1>
                <p>Total Invoices</p>
            </div>
        </section>
    </div>
</a>