<?php
$start_date = date("Y-m-d");
$end_date = date("Y-m-d", strtotime("+1 week"));
$jasonevents = array();
//activities start
$activity_cndn = 'date(date_to_do)!="0000-00-00" ';
if (Yii::app()->user->authorised_user != 1) {
    $activity_cndn.=' AND crm_user_id=' . Yii::app()->user->id;
}
$activity_cndn.=' AND date(t.date_to_do) >= "' . $start_date . '" AND date(t.date_to_do) <= "' . $end_date . '"';
$activitiestodo = Activity::model()
        ->with(array("pros" => array("select" => "activity,activity_type,colour,f_colour"),
            "user" => array("select" => "id,user_group_id,first_name,last_name"),
            "customer" => array("select" => "customer_name")))
        ->findAll(array('select' => "t.id,t.crm_user_id,t.date_to_do,t.contact_id,t.type_of_activity,t.notes,t.customer_id,t.type",
    'condition' => $activity_cndn,
    'order' => 'date_to_do,t.id ASC'));
foreach ($activitiestodo as $i => $eachActivitytodo) {
    $type = $eachActivitytodo->pros->activity_type;
    $jasoneventstodo['url'] = "loadPopupModal('activity/viewactivity&activity_id=".$eachActivitytodo->id."','View Activity','lg');";
    $jasoneventstodo['date'] = date('Y-m-d', strtotime($eachActivitytodo->date_to_do));
    $jasoneventstodo['backgroundColor'] = $eachActivitytodo->pros->f_colour;
    $date = $eachActivitytodo->date_to_do;
    if ($eachActivitytodo->contact_id == 0) {
        $person = $eachActivitytodo->user->fullname;
    } else {
        $person = $eachActivitytodo->contact_details->person_name;
    }
    $jasoneventstodo['id'] = $eachActivitytodo->id;
    $jasoneventstodo['title'] = $eachActivitytodo->type . $eachActivitytodo->pros->activity . " - " . $person;
    $jasoneventstodo['description'] = "Added by - " . $eachActivitytodo->user->fullname . '<br>Activity : ' . $eachActivitytodo->notes . "                       
                    Date/Time : " . $date;
    if ($eachActivitytodo->customer_id > 0)
        $jasoneventstodo['description'] .= '<br> Customer : ' . $eachActivitytodo->customer->customer_name;
    $jasoneventstodo['type'] = ($eachActivitytodo->type == 'A') ? 'Activity' : 'Task';
    $jasonevents[] = $jasoneventstodo;
}
//activities End
//Lead Start
if (((int) Yii::app()->user->havePermissionOn["lead_view"]) || Yii::app()->user->authorised_user == 1) {
    $criteriaLead = new CDbCriteria;
    $criteriaLead->addCondition(' file.current_process_status="L"', 'AND');
    $criteriaLead->addCondition(' status!="C"', 'AND');
    if (Yii::app()->user->authorised_user != 1) {
        $criteriaLead->addCondition(' t.lead_owner_id=' . Yii::app()->user->id, 'AND');
    }
    $criteriaLead->addCondition('(closing_date BETWEEN "' . $start_date . '" AND "' . $end_date . '")', 'AND');
    $modelLead = new Lead();
    $arr_lead_details = $modelLead->with('file')->findAll($criteriaLead);
    foreach ($arr_lead_details as $eachLeads) {
        $jasoneventsLead['type'] = "LEAD";
        $jasoneventsLead['backgroundColor'] = '#47D1FF'; //#6ad3ff';
        $jasoneventsLead['title'] = "Lead - " . $eachLeads->id; //$type . " - " . $eachActivity->company->company_name;
        $jasoneventsLead['url'] = "loadPopupModal('lead/create&frm=calendar&id=".$eachLeads->id."','".$jasoneventsLead['title']."','lg');";
        $jasoneventsLead['date'] = date('Y-m-d', strtotime($eachLeads->closing_date));
        $jasoneventsLead['id'] = $eachLeads->id;
        $jasoneventsLead['description'] = "Lead: " . $eachLeads->id . " / " . $eachLeads->file->file_title . '<br/> Lead Owner: ' . $eachLeads->leadowner->fullname . '<br/>Customer: ' . $eachLeads->customer->customer_name;
        $jasoneventsLead['allDay'] = false;
        $jasonevents[] = $jasoneventsLead;
    }
    if ((int) Yii::app()->user->havePermissionOn['quotes_view'] || Yii::app()->user->authorised_user == 1) {
        $criteriaQtn = new CDbCriteria;
            $criteriaQtn->addCondition(' file.current_process_status="Q"', 'AND');
            if (Yii::app()->user->authorised_user != 1) {
                $criteriaQtn->addCondition(' t.lead_owner_id=' . Yii::app()->user->id, 'AND'); /* . ' OR t.lead_owner_id in (' . implode(',', $userModel->subordinates) . ')' */
            }
            $criteriaQtn->addCondition('(qtn_validity BETWEEN "' . $start_date . '" AND "' . $end_date . '")', 'AND');
            $modelQuotes = new Quotes();
            $arr_quotation_details = $modelQuotes->with('file')->findAll($criteriaQtn);
            foreach ($arr_quotation_details as $eachQuotation) {
                $jasoneventsQtn['type'] = "Quotation";
                $jasoneventsQtn['backgroundColor'] = '#4256e7'; //#6ad3ff';
                $jasoneventsQtn['date'] = date('Y-m-d', strtotime($eachQuotation->qtn_validity));
                $jasoneventsQtn['id'] = $eachQuotation->id;
                $jasoneventsQtn['title'] = "Quotation - " . $eachQuotation->id; //$type . " - " . $eachActivity->company->company_name;
                $jasoneventsQtn['description'] = "Quotation: " . $eachQuotation->id . " / " . $eachQuotation->file_title . '<br/> Lead Owner: ' . $eachQuotation->leadowner->fullname . '<br/>Customer: ' . $eachQuotation->customer->customer_name;
                $jasoneventsQtn['url'] = "loadPopupModal('quotation/create&frm=calendar&id=".$eachQuotation->id."','".$jasoneventsQtn['title']."','xl');";
                $jasonevents[] = $jasoneventsQtn;
            }
        
    }
    //End Quotation
    //Start Order
    if ((int) Yii::app()->user->havePermissionOn['order_view'] || Yii::app()->user->authorised_user == 1) {
        $criteria2 = new CDbCriteria;
            $criteria2->addCondition(' file.current_process_status="O"', 'AND');
            if (Yii::app()->user->authorised_user != 1) {
                $criteria2->addCondition(' t.lead_owner_id=' . Yii::app()->user->id, 'AND'); /* . ' OR t.lead_owner_id in (' . implode(',', $userModel->subordinates) . ')' */
            }
            $criteria2->addCondition('(delivery_date BETWEEN "' . $start_date . '" AND "' . $end_date . '")', 'AND');
            $modelOrder = new Order();
            $arr_order_details = $modelOrder->with('file')->findAll($criteria2);
            foreach ($arr_order_details as $eachOrder) {
                $jasoneventsOrder['type'] = "ORDER";
                $jasoneventsOrder['backgroundColor'] = '#3dd2c7'; //'#fced89';
                $jasoneventsOrder['id'] = $eachOrder->id;
                $jasoneventsOrder['title'] = "Order - " . $eachOrder->id; //$type . " - " . $eachActivity->company->company_name;
                $jasoneventsOrder['url'] = "loadPopupModal('order/create&frm=calendar&id=".$eachOrder->id."','".$jasoneventsOrder['title']."','xl');";
                $jasoneventsOrder['date'] = date('Y-m-d', strtotime($eachOrder->delivery_date));
                $jasoneventsOrder['description'] = "Order: " . $eachOrder->id . " / " . $eachOrder->file->file_title . '<br/> Lead Owner: ' . $eachOrder->leadowner->fullname . '<br/>Customer:' . $eachOrder->customer->customer_name;
                $jasonevents[] = $jasoneventsOrder;
            }
        
    }
    //End Order
    //Start Invoice
    if ((int) Yii::app()->user->havePermissionOn['invoice_view'] || Yii::app()->user->authorised_user == 1) {
        $criteria2 = new CDbCriteria;
            if (Yii::app()->user->authorised_user != 1) {
                $criteria2->addCondition(' t.lead_owner_id=' . Yii::app()->user->id, 'AND'); /* . ' OR t.lead_owner_id in (' . implode(',', $userModel->subordinates) . ')' */
            }
            $criteria2->addCondition('(invoice_date BETWEEN "' . $start_date . '" AND "' . $end_date . '")', 'AND');
            $files = MasterFile::model()->with('invoices')->findAll($criteria2); // need to put condition here
            $modelInvoice = new Invoice();
            $arr_invoice_details = $modelInvoice->with('file')->findAll($criteria2);
            foreach ($arr_invoice_details as $eachInvoice) {
                $paymentTerm = $eachInvoice->paymentTerm->no_of_days;
                if ($paymentTerm > 0) {
                    $inv_date = date('Y-m-d', strtotime('+' . $paymentTerm . ' days', strtotime($eachInvoice->invoice_date)));
                } else {
                    $inv_date = date('Y-m-d', strtotime($eachInvoice->invoice_date));
                }
                $jasoneventsInvoice['type'] = "Invoice";
                $jasoneventsInvoice['backgroundColor'] = '#8AC8F2'; //'#f4a1d2';
                $jasoneventsInvoice['url'] = "window.open('index.php?r=invoice/PrintInvoiceReportPDF&id=".$eachInvoice->id."&hiring=".$eachInvoice->is_hiring_invoice."&frm=tax')";
                $jasoneventsInvoice['date'] = $inv_date;
                $jasoneventsInvoice['id'] = $eachInvoice->id;
                $jasoneventsInvoice['title'] = "Invoice Created- " . $eachInvoice->id; //$type . " - " . $eachActivity->company->company_name;
                $jasoneventsInvoice['hiring'] = $eachInvoice->is_hiring_invoice;
                $jasoneventsInvoice['description'] = "Invoice: " . $eachInvoice->file_id . " / " . $eachInvoice->invoice_no . '<br/> Lead Owner: ' . $eachInvoice->file->leadowner->fullname . '<br/>Customer: ' . $eachInvoice->customer->customer_name;
                $jasonevents[] = $jasoneventsInvoice;
            }
        
    }
    //End Invoice
}

//End Lead
//Quotation Start
?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-user"></i> Reminders From <?php echo date('d/m/Y',strtotime($start_date)); ?> To <?php echo date('d/m/Y',strtotime($end_date)); ?>         
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-primary table-bordered personal-task" id="tbl_followups">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Title</th>
                        <th width="55%">Details</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $no = 1;
                    if (!empty($jasonevents)) {
                        foreach ($jasonevents as $each) {
                            ?>
                            <tr>
                                <td><?php echo $no; ?></td>
                                <td><?php echo $each['date']; ?></td>
                                <td><?php echo $each['type']; ?></td>
                                <td><?php echo nl2br($each['title']); ?></td>
                                <td><?php echo nl2br($each['description']); ?></td>
                                <td><?php if($each['url']!=''){?>
                                    <button type="button" class="btn btn-sm btn-theme" onclick="<?php echo $each['url']; ?>"><i class="fa fa-eye"></i></button>
                                <?php }?></td>
                            </tr>
                            <?php
                            $no++;
                        }
                    } else {
                        ?>
                        <tr><td colspan="6" class="text-center"> No Details Found</td></tr> 
                    <?php } ?>

                </tbody>
            </table>
        </div>
    </div>
</section>