<?php
$fromdate = str_replace('/', '-', $fromdate);
$from_date = date("Y-m-d", strtotime($fromdate));
$todate = str_replace('/', '-', $todate);
$end_date = date("Y-m-d", strtotime($todate));
$month = date("m", strtotime($fromdate));
$month_1 = date("m", strtotime($todate));
$year = date("Y", strtotime($todate));

$color = ColorSettings::model()->find(); // get first / only record
$primaryColors = [
    ltrim($color->graph_color_one, '#'),
    ltrim($color->graph_color_two, '#'),
    ltrim($color->graph_color_three, '#'),
    ltrim($color->graph_color_four, '#'),
    ltrim($color->graph_color_five, '#'),
    ltrim($color->graph_color_six, '#'),
    ltrim($color->graph_color_seven, '#'),
    ltrim($color->graph_color_eight, '#'),
];

// Define shades and tints of the primary color #5DB5A4
// $primaryColors = [
//     '5DB5A4', // Base teal
//     '88CFC2', // Lighter mint
//     'A2DCD0', // Pale aqua
//     '47988B', // Slightly deeper teal
//     '3E8278', // Muted green-blue
//     '5DAFB5', // Teal with more blue
//     '5DB590', // Greenish version
//     '4F9C8F'  // Muted deep teal
// ];
// Plot 1: Leads per user
$graph_data_quantity = Yii::app()->db->createCommand('
    SELECT CONCAT(user.first_name," ",user.last_name) AS x_value, COUNT(*) AS y_value
    FROM {{lead}} AS L
    INNER JOIN ' . User::MainDb . '.{{user}} AS user ON L.lead_owner_id = user.id
    WHERE L.enq_date BETWEEN "' . $from_date . '" AND "' . $end_date . '"
    GROUP BY user.id
')->queryAll();

$plot = '[';
$index = 0;
foreach ($graph_data_quantity as $eachdata) {
    $color = $primaryColors[$index % count($primaryColors)];
    $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color:"#' . $color . '"},';
    $index++;
}
$plot .= ']';

// Plot 2: Leads per country
$graphdata = Yii::app()->db->createCommand('
    SELECT COUNT(*) AS value, country.country_name AS label
    FROM {{lead}} AS L
    INNER JOIN {{customer}} AS customer ON L.customer_id = customer.id
    INNER JOIN {{mas_country}} AS country ON customer.customer_country = country.id
    WHERE L.enq_date BETWEEN "' . $from_date . '" AND "' . $end_date . '"
    GROUP BY customer.customer_country
')->queryAll();

$plot_1 = '[';
$index = 0;
foreach ($graphdata as $eachdata) {
    $color = $primaryColors[$index % count($primaryColors)];
    $plot_1 .= '{label:"' . $eachdata['label'] . '", value:"' . $eachdata['value'] . '", color:"#' . $color . '"},';
    $index++;
}
$plot_1 .= ']';

// Plot 3: Leads per sales group
$graphdata2 = Yii::app()->db->createCommand('
    SELECT sales_group.group_name AS label, COUNT(*) AS value
    FROM {{lead}} AS L
    INNER JOIN {{mas_sales_group}} AS sales_group ON L.sales_group_id = sales_group.id
    WHERE L.enq_date BETWEEN "' . $from_date . '" AND "' . $end_date . '"
    GROUP BY sales_group.id
')->queryAll();

$plot_2 = '[';
$index = 0;
foreach ($graphdata2 as $eachdata) {
    $color = $primaryColors[$index % count($primaryColors)];
    $plot_2 .= '{label:"' . $eachdata['label'] . '", value:"' . $eachdata['value'] . '", color:"#' . $color . '"},';
    $index++;
}
$plot_2 .= ']';

// Plot 4: Monthly lead count
$currentYear = date("Y");
$currentmonth = date("m");
if ($year == $currentYear) {
    $month_1 = $currentmonth;
}

$plot_4 = '[';
for ($k = $month; $k <= $month_1; $k++) {
    $dateObj = DateTime::createFromFormat('!m', $k);
    $monthName = $dateObj->format('F'); // e.g., March

    $graphdata3 = Yii::app()->db->createCommand('
        SELECT COUNT(id) AS value
        FROM {{lead}}
        WHERE YEAR(enq_date) = "' . $year . '" AND MONTH(enq_date) = "' . $k . '"
    ')->queryAll();

    foreach ($graphdata3 as $eachdata) {
        $color = $primaryColors[$k % count($primaryColors)];
        $plot_4 .= '{label:"' . $monthName . '", value:"' . $eachdata['value'] . '", color:"#' . $color . '"},';
    }
}
$plot_4 .= ']';

$end_year = date("Y", strtotime($todate));
?>

<div class="clearfix"></div>
<br>
<div class="clearfix">
    <div class="col-lg-3" data-initial-class="col-lg-3" id="pieChartParent">
        <section class="panel">
            <header class="panel-heading">
                Salesperson
            </header>
            <div class="panel-body text-center">
                <div class="clearfix canvas-holder">
                    <canvas id="myChart" width="400" height="400" onclick="loadPopupModal('dashboard/leadgraphdetails&type=1&from_date=<?php echo $fromdate; ?>&end_date=<?php echo $todate ?>', 'Lead- SalesPerson', 'lg');"></canvas>
                </div>
            </div>
        </section>
    </div>
    <div class="col-lg-3" data-initial-class="col-lg-3" id="pieChartParent_1">
        <section class="panel">
            <header class="panel-heading">
                Country
            </header>
            <div class="panel-body text-center">
                <div class="clearfix canvas-holder">
                    <canvas id="myChart_1" width="400" height="400" onclick="loadPopupModal('dashboard/leadgraphdetails&type=2&from_date=<?php echo $fromdate; ?>&end_date=<?php echo $todate ?>', 'Lead- Country', 'lg');"></canvas>
                </div>
            </div>
        </section>
    </div>
    <div class="col-lg-3" data-initial-class="col-lg-3" id="pieChartParent_2">
        <section class="panel">
            <header class="panel-heading">
                Sales Group
            </header>
            <div class="panel-body text-center">
                <div class="clearfix canvas-holder">
                    <canvas id="myChart_2" width="400" height="400" onclick="loadPopupModal('dashboard/leadgraphdetails&type=3&from_date=<?php echo $fromdate; ?>&end_date=<?php echo $todate ?>', 'Lead- Sales Group', 'lg');"></canvas>
                </div>
            </div>
        </section>
    </div>

    <div class="col-lg-3" data-initial-class="col-lg-3" id="pieChartParent_yr">
        <section class="panel">
            <header class="panel-heading">
                Month wise - <?php echo $end_year; ?>
            </header>
            <div class="panel-body text-center">
                <div class="clearfix canvas-holder">
                    <canvas id="myChart_yr" width="400" height="400" onclick="loadPopupModal('dashboard/leadgraphdetails&type=4&from_date=<?php echo $fromdate; ?>&end_date=<?php echo $todate ?>', 'Monthly Leads - <?php echo $end_year; ?>', 'lg');"></canvas>
                </div>
            </div>
        </section>
    </div>
</div>


<script type="text/javascript">
    $(function () {
//        var data1 = [
//            { value : 300, color : "#F7464A", highlight : "#FF5A5E", label : "Red"},
//            { value : 50, color : "#46BFBD", highlight : "#5AD3D1", label : "Green"},
//            { value : 100, color : "#FDB45C", highlight : "#FFC870", label : "Yellow"}
//        ];
        var data1 =<?php echo $plot; ?>;
        var data2 =<?php echo $plot_1; ?>;
        var data3 =<?php echo $plot_2; ?>;
        var order_data4 =<?php echo $plot_4; ?>;
        var canvas1 = document.getElementById("myChart");
        Chart.defaults.global.responsive = true;
        var ctx = canvas1.getContext("2d");
        var pieChart = new Chart(ctx).Pie(data1);

        var canvas_1 = document.getElementById("myChart_1");
        Chart.defaults.global.responsive = true;
        var ctx_1 = canvas_1.getContext("2d");
        var pieChart_1 = new Chart(ctx_1).Pie(data2);

        var canvas_2 = document.getElementById("myChart_2");
        Chart.defaults.global.responsive = true;
        var ctx_2 = canvas_2.getContext("2d");
        var pieChart_2 = new Chart(ctx_2).Pie(data3);

        var canvas_3 = document.getElementById("myChart_yr");
        Chart.defaults.global.responsive = true;
        var ctx_3 = canvas_3.getContext("2d");
        var pieChart_3 = new Chart(ctx_3).Pie(order_data4);
    });
    var c_size = {
        //md:"col-xs-6 col-xs-offset-3",
        //  lg:"col-xs-8 col-xs-offset-2",
        // xl:"col-xs-12"
    }
    var returnNextItem = function (item) {
        switch (item) {
            case "md":
                return "lg";
                break;
            case "lg":
                return "xl";
                break;
            case "xl":
                return "init";
                break;
            default:
                return "md";
        }
    }
    var growChart = function (id) {
        var $el = $(id);
        var cs = returnNextItem($el.attr('data-size'));
        $el.attr('data-size', cs);
        if (cs != "init") {
            $el.attr('class', c_size[cs]);
        } else if (cs == "init") {
            $el.attr('class', $el.attr('data-initial-class'));
        }
        resizeWindow();
    }
</script>