<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("loadDamagedStore", '
        $(document).ready(function() {

        var table_id ="#tbl_damaged_store";
        var table = $(table_id).DataTable({
            scrollY         : "380px",
            pageLength      : 50,            
            ajax: {
                url: "' . Yii::app()->createUrl('damagedstore/getList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);

  ?>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-user"></i> Damaged Store
            <?php //if(isset(Yii::app()->user->havePermissionOn['customer_add_edit']) && Yii::app()->user->havePermissionOn['customer_add_edit'] == 1){?>
            <div class="pull-right">
                <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('damagedstore/create','Add Damaged Item','lg')"><i class="fa fa-plus"></i> ADD</button>
            </div>
            <?php // }?>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_damaged_store">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Date</th>
                            <th>Referance</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>ID</th>
                            <th>Date</th>
                            <th>Referance</th>
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
