<?php
$cs = Yii::app()->getClientScript();
$canDelete = isset(Yii::app()->user->havePermissionOn['customer_delete_document']) ? 'true' : 'false';

$cs->registerScript("loadDocs", '
$(document).ready(function () {
    var table_id = "#customer_docs_table";
    var cust_id = $("#hid_cust_id").val();

    var table = $(table_id).DataTable({
        scrollY: "250px",
        ajax: {
            data: { "vendor_id": cust_id },
            url: "' . Yii::app()->createUrl('customer/getDocsList') . '",
            type: "POST",
            cache: false
        },
        aoColumnDefs: [
            { "bSortable": false, "aTargets": [0, 3] }
        ],
        bLengthChange: false,
        bInfo: false,
        bPaginate: false,
        serverSide: true,
        fixedColumns: true,
        processing: true,
        fixedHeader: {
            headerOffset: $("header.main").outerHeight()
        },
        rowCallback: function(row, data) {
            AddDocsContextMenu(row, data);
        }
    });

    $(".dataTables_scrollFoot").hide();

    function AddDocsContextMenu(row, data) {
        var docId = data[5]; // adjust if needed
        var customerName = data[1]; // adjust if needed

        $(row).contextMenu({
            selector: "td",
            items: {
                "edit": {
                    name: "Edit Document",
                    icon: "edit",
                    callback: function () {
                        loadPopupModal("customer/createDocumentform&id=" + docId, docId + " : " + customerName, "lg");
                    }
                },
                "download": {
                    name: "Download",
                    icon: "fa fa-download",
                    callback: function () {
                        window.location.href = "' . Yii::app()->createUrl('customer/downloaddocument') . '&id=" + docId;
                    }
                },
                "delete": {
                    name: "Delete",
                    icon: "delete",
                    callback: function () {
                        deleteERPDocument(docId);
                    },
                    disabled: function () {
                        return ' . ($canDelete === 'true' ? 'false' : 'true') . ';
                    }
                }
            }
        });
    }
});
', CClientScript::POS_HEAD);



    $cs->registerScript("deleteERPDocument",  "function deleteERPDocument(id){
    var r = confirm('Are you sure to delete this Document?');
    
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id ,
              'url'  : $('#liveSite').val()+'index.php?r=customer/deleteDocument',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    alert('Error while Deleting');
                }else {
                    alert('Document Deleted SuccessFully!');
                    reloadTable('#customer_docs_table');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);

  ?>
<section class="panel">
        <header class="panel-heading clearfix panel-theame">
           Documents
            <?php $arr_count = CustomerDocs::model()->findAll(array('condition'=>'customer_id="'.$model->id.'"'))?>
            <?php  if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_upload_document"])) { ?>
            <div class="pull-right">
                <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('customer/createDocumentform&c_id=<?php echo $model->id ?>','Add Document','lg')" title="Add Documents"><i class="fa fa-plus"></i> </button>
            </div>
            <?php } ?>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="customer_docs_table">
                    <thead>
                        <tr>
                            <th>Sl No</th>
                            <th>Document Name</th>
                            <th>Document No </th>
                            <!-- <th>From Date</th> -->
                            <th>Expiry Date</th>
                            <!-- <th>Actions</th> -->
                            
                        </tr>
                    </thead>
                    
                </table>
            </div>
        </div>
</section>
<script type="text/javascript">
$(document).ready(function(){
    $("div.modal button.close").show();   
});

</script> 
