<style>
    .clockpicker-popover {
        z-index: 999999999999 !important;
    }
</style>
<div class="table-responsive">
    <table class="table table-hover table-bordered personal-task" id="tbl_customer_machine">
        <thead>
            <tr>
                <th>Machine Name</th>
                <th>Serial No</th>
                <th>Outlet</th>
                <th>Location</th>
                <th>Last Service</th>
                <th>Next Service</th>
            </tr>
        </thead>
        <tbody>
            <?php $serial = 1; ?>
            <?php foreach ($modelMachine as $header): ?>
                <?php if (!empty($modelMachineItems[$header->id])): ?>
                    <?php foreach ($modelMachineItems[$header->id] as $item): ?>
                        <tr>
                            <!-- Machine Name -->
                            <td style="pointer-events:none">
                                <?= CHtml::textField("machine[$serial][machine_name]", Store::getProductName($item->machine_id), ['class' => 'form-control']); ?>
                            </td>

                            <!-- Serial Number -->
                            <td style="pointer-events:none">
                                <?= CHtml::textField("machine[$serial][serial_no]", $item->serial_no, ['class' => 'form-control']); ?>
                            </td>

                            <!-- Outlet -->
                            <td style="pointer-events:none">
                                <?= CHtml::textField(
                                    "machine[$serial][outlet]",
                                    ($header->customer_shiiping ? $header->customer_shiiping->outlet_location : ''),
                                    ['class' => 'form-control']
                                ); ?>
                            </td>

                            <!-- Location -->
                            <td style="pointer-events:none">
                                <?= CHtml::textField(
                                    "machine[$serial][location]",
                                    ($item->customerlocation ? $item->customerlocation->location_name : ''),
                                    ['class' => 'form-control']
                                ); ?>
                            </td>
                            <!-- Last Service -->
                            <td style="pointer-events:none">
                                <?= CHtml::textField(
                                    "machine[$serial][last_service]",
                                    (
                                        !empty($item->last_service) && $item->last_service != '0000-00-00'
                                        ? date('d/m/Y', strtotime($item->last_service))
                                        : ''
                                    ),
                                    ['class' => 'form-control']
                                ); ?>
                            </td>

                            <!-- Next Service -->
                            <td style="pointer-events:none">
                                <?= CHtml::textField(
                                    "machine[$serial][next_service]",
                                    (
                                        !empty($item->next_service) && $item->next_service != '0000-00-00'
                                        ? date('d/m/Y', strtotime($item->next_service))
                                        : ''
                                    ),
                                    ['class' => 'form-control']
                                ); ?>
                            </td>

                        </tr>
                        <?php $serial++; ?>
                    <?php endforeach; ?>
                <?php endif; ?>
            <?php endforeach; ?>

            <?php if ($serial === 1): // means no data ?>
                <tr>
                    <td colspan="7" class="text-center">No machine details found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("removeTableMachine", " function removeTableMachine(jQtable,evt) {
        formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
        var num_rows    =   jQtable.find('tr:gt(0)').length;
        if(num_rows>1){
            var tr  =   $(evt).parent().parent();
            if(isRowEmpty(tr)) {
                
                $(evt).parents('tr').remove();
                var i=0;
                jQtable.find('tr:gt(0)').each(function() { 
                    $(this).find('input,select,textarea,.errorMessage').each(function()
                    {
                        old_id   =   $(this).attr('id');
                        new_id   =   old_id.replace(/\d+/,i);
                        $(this).attr('id',new_id);
                        old_name =   $(this).attr('name');
                        if(old_name!==undefined) {
                            new_name =   old_name.replace(/\d+/,i);
                            $(this).attr('name',new_name);
                        } 
                    });
                    $(this).find('td:first label').html(++i); 
                });
            }
            
        } else alert('Atleast one item needed here'); 
    }", CClientScript::POS_HEAD);
?>
<?php
$cs->registerScript("addMachineRow", " function addMachineRow(jQtable) {
    
                formId              =   jQtable.attr('id');
                formIdStarter       =   jQtable.attr('id').split(/_(.+)?/)[0];
                lastId = jQtable.find('tr:last input:first').attr('id');
                thenum = lastId.match(/\d+/g);
               
                newId = Number(thenum) + 1;
                
                newrow= jQtable.find('tr:last').clone();
                
                newrow.find('label:first').html(newId+1);
                newrow.attr('class',newId);
                
                 newrow.find('.hasDatepicker').removeClass('hasDatepicker');
                newrow.find('.datetimepicker').siblings().remove();
               newrow.find('div,input,textarea,checkbox,td,select,.errorMessage,a,span').each(function() {
                    this.id= this.id.replace(/\d+/,newId);
                   if(!$(this).is(':checkbox'))
                        this.value  = '';
                    else
                        $(this).prop('checked', false);
                    (this.name!==undefined) ? this.name= this.name.replace(/\d+/,newId) : this.style  =   '';});
                jQtable.append(newrow);
                
                $('#CustomerMachine_'+newId+'_last_service').datetimepicker({format: 'DD/MM/YYYY'});
                $('#CustomerMachine_'+newId+'_next_service').datetimepicker({format: 'DD/MM/YYYY'});
                
    }", CClientScript::POS_HEAD);
$cs->registerScript("removeMachineRow", "function removeMachineRow(jQtable, evt,field_id) {
        var arr_fields= field_id.split('_');
        var row_field=arr_fields[1];
      //  var id=$('#CustomerMachine_'+row_field+'_id').val();
         var id=$('#ServiceMasCustomerMachines_'+row_field+'_id').val();
        var num_rows = jQtable.find('tr:gt(0)').length;
        if (num_rows > 1) {
            var tr = $(evt).parent().parent();
            if (isRowEmpty(tr)) {
                if(id>0){
                    jQuery.ajax({
                        'type': 'post',
                        'dataType': 'json',
                        'url': '" . Yii::app()->createUrl('customer/DeleteMachineDetails') . "',
                        'data': {'id':id}  ,
                        'cache': false,
                        'success': function(data) {
                            if(data.status=='success'){
                                $(evt).parents('tr').remove();
                                var i=0;
                                jQtable.find('tr:gt(0)').each(function() { 
                                    $(this).find('input,textarea,.errorMessage').each(function()
                                    {
                                        old_id   =   $(this).attr('id');
                                        new_id   =   old_id.replace(/\d+/,i);
                                        $(this).attr('id',new_id);
                                        old_name =   $(this).attr('name');
                                        if(old_name!==undefined) {
                                            new_name =   old_name.replace(/\d+/,i);
                                            $(this).attr('name',new_name);
                                        } 
                                    });
                                    $(this).find('td:first label').html(++i); 
                                });
                                     t8.success('Machine Details Deleted','');
                            }else{
                              t8.error('Deletion Not Possible, History Exist','error');
                            }
                        }
                    });
                }else{
                    $(evt).parents('tr').remove();
                    var i = 0;
                    jQtable.find('tr:gt(0)').each(function () {
                        $(this).find('input,select,textarea,.errorMessage').each(function () {
                            old_id = $(this).attr('id');
                            new_id = old_id.replace(/\d+/, i);
                            $(this).attr('id', new_id);
                            old_name = $(this).attr('name');
                            if (old_name !== undefined) {
                                new_name = old_name.replace(/\d+/, i);
                                $(this).attr('name', new_name);
                            }
                        });
                        $(this).find('td:first label').html(++i);
                    });
                }
            }
        } else
            alert('Atleast one item needed here');
    }", CClientScript::POS_HEAD);
?>