<?php
$modelCustomerOutletLocation = [];

if ($model->id > 0) {
    $modelCustomerOutletLocation = CustomerOutletLocation::model()->findAll([
        'condition' => 'customer_id = :cid',
        'params' => [':cid' => $model->id],
    ]);
}

// Ensure at least one instance exists
if (empty($modelCustomerOutletLocation)) {
    $modelCustomerOutletLocation = [new CustomerOutletLocation()];
}
?>

<div class="table-responsive">
    <input type="hidden" id="outlet_toggler" value="0">
    <table class="table table-hover table-bordered personal-task" id="customer_outlet_loc_table">
        <tr>
            <th>Customer Name
                <a href="#" title="Copy Customer Name" onclick="copyOutletName()">
                    <i id="outlet_copy_icon" class="fa fa-files-o"></i>
                </a>
            </th>
            <th>Outlet</th>
            <th>
                <?php if ((int) Yii::app()->user->havePermissionOn['customer_add_outlet'] > 0 || Yii::app()->user->authorised_user == 1) { ?>
                    <a class="btn btn-sm btn-theme" href="javascript:void(0);" onclick="addTableRow($('#customer_outlet_loc_table'));"><i class="fa fa-plus"></i></a>
                <?php } ?>
            </th>
        </tr>

        <?php foreach ($modelCustomerOutletLocation as $i => $eachItem): ?>
            <tr id="<?php echo $i; ?>" class="<?php echo $i; ?>">
                <td>
                    <?php echo $form->textField($eachItem, "[$i]shipping_customer_name", ['class' => 'form-control']); ?>
                    <?php echo $form->error($eachItem, 'shipping_customer_name'); ?>
                    <?php echo $form->hiddenField($eachItem, "[" . $i . "]id"); ?>

                </td>

                <td>
                    <?php echo $form->textField($eachItem, "[$i]outlet_location", [
                        'class' => 'form-control',
                    ]); ?>
                    <?php echo $form->error($eachItem, 'outlet_location'); ?>
                    <?php echo $form->hiddenField($eachItem, "[$i]id"); ?>
                </td>

                <td>
                    <?php if ((int) Yii::app()->user->havePermissionOn['customer_delete_outlet'] > 0 || Yii::app()->user->authorised_user == 1) { ?>
                        <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', [
                            'class' => 'btn btn-sm btn-danger',
                            'onclick' => 'removeOutletLocationTableRow($("#customer_outlet_loc_table"), this, this.id)',
                            'title' => 'Remove this item',
                            'id' => "shippingmaterial_$i"
                        ]);
                    } ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>

<?php
$cs = Yii::app()->getClientScript();
$deleteUrl = Yii::app()->createUrl('customer/deleteoutletlocationitem');

// Copy function (similar to copyAdds)
$cs->registerScript("copyOutletName", "
function copyOutletName() {
    var t = $('#outlet_toggler').val();
    var name, location;

    if (t == 0) {
        name = $('#Customer_customer_name').val();
        location = $('#Customer_customer_address').val();
        $('#outlet_toggler').val(1);
        $('#outlet_copy_icon').removeClass('fa-files-o').addClass('fa-times-circle');
    } else {
        $('#outlet_toggler').val(0);
        $('#outlet_copy_icon').removeClass('fa-times-circle').addClass('fa-files-o');
        name = location = '';
    }

    // Fill in the first 20 outlet rows (just like shipping)
    for (var i = 0; i < 20; i++) {
        $('#CustomerOutletLocation_' + i + '_shipping_customer_name').val(name);
        $('#CustomerOutletLocation_' + i + '_outlet_location').val(location);
    }
}
", CClientScript::POS_HEAD);


// Remove row function (same structure as shipping)
$cs->registerScript("removeOutletLocationTableRow", "
function removeOutletLocationTableRow(jQtable, evt, field_id) {
    var row_field = field_id.split('_')[1];
    var num_rows = jQtable.find('tr:gt(0)').length;
    var row_id = $(evt).closest('tr').attr('class');
    var id = $('#CustomerOutletLocation_' + row_id + '_id').val();

    if (num_rows <= 1) {
        alert('At least one outlet is required.');
        return;
    }

    // If row exists in DB, delete via AJAX
    if (id) {
        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: '$deleteUrl',
            data: { id: id },
            cache: false,
            success: function (data) {
                if (data.status === 'success') {
                    $(evt).closest('tr').remove();
                    reorderOutletLocationRows(jQtable);
                    // t8.success('Outlet Deleted!', 'success');
                    $.pnotify_remove_all();
                } else if (data.status === 'exist') {
                    t8.error('Outlet Already Used!', 'error');
                } else {
                    t8.error('Deletion Not Possible, History Exist', 'error');
                }
            }
        });
    } else {
        $(evt).closest('tr').remove();
        reorderOutletLocationRows(jQtable);
    }
}

// Reorder remaining outlet rows
function reorderOutletLocationRows(jQtable) {
    var i = 0;
    jQtable.find('tr:gt(0)').each(function () {
        $(this).find('input, textarea, .errorMessage').each(function () {
            var oldId = $(this).attr('id');
            if (oldId) $(this).attr('id', oldId.replace(/\\d+/, i));
            var oldName = $(this).attr('name');
            if (oldName) $(this).attr('name', oldName.replace(/\\d+/, i));
        });
        $(this).find('td:first label').html(++i);
    });
}
", CClientScript::POS_END);
?>
