<?php
$modelServiceCustomerLocation = [];

if ($model->id > 0) {
    $modelServiceCustomerLocation = ServiceCustomerLocation::model()->findAll([
        'condition' => 'customer_id = :cid',
        'params' => [':cid' => $model->id],
    ]);
}

// Ensure at least one instance exists
if (empty($modelServiceCustomerLocation)) {
    $modelServiceCustomerLocation = [new ServiceCustomerLocation()];
}

// Get outlet list
$outletList = CustomerOutletLocation::getOutlet($customer_id); // id => name
?>

<div class="table-responsive">
    <input type="hidden" id="toggler" value="0">
    <table class="table table-hover table-bordered personal-task" id="customer_loc_table">
        <tr>
            <th>Outlet</th>
            <th>Location</th>
            <th class="hidden">Is Default</th>
            <th>
                <a class="btn btn-sm btn-theme" href="javascript:void(0);"
                    onclick="addTableRow($('#customer_loc_table'));">
                    <i class="fa fa-plus"></i>
                </a>
            </th>
        </tr>

        <?php foreach ($modelServiceCustomerLocation as $i => $eachItem): ?>
            <tr id="<?php echo $i; ?>" class="<?php echo $i; ?>">
                <td>
                    <?php echo $form->dropDownList(
                        $eachItem,
                        "[$i]customer_outlet_location_id",
                        $outletList,
                        ['class' => 'form-control', 'empty' => '-- Select Outlet --']
                    ); ?>
                    <?php echo $form->error($eachItem, 'customer_outlet_location_id'); ?>
                    <?php echo $form->hiddenField($eachItem, "[" . $i . "]id"); ?>

                </td>

                <td>
                    <?php echo $form->textField($eachItem, "[$i]location_name", ['class' => 'form-control']); ?>
                    <?php echo $form->error($eachItem, 'location_name'); ?>
                </td>

                <td class="hidden">
                    <?php echo $form->dropDownList(
                        $eachItem,
                        "[$i]is_default_location",
                        ['Y' => 'Yes', 'N' => 'No'],
                        ['class' => 'form-control']
                    ); ?>
                    <?php echo $form->error($eachItem, 'is_default_location'); ?>
                    <?php echo $form->hiddenField($eachItem, "[$i]id"); ?>
                </td>

                <td>
                    <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', [
                        'class' => 'btn btn-sm btn-danger',
                        'onclick' => 'removeServiceLocationTableRow($("#customer_loc_table"), this, this.id)',
                        'title' => 'Remove this item',
                        'id' => "servicelocation_$i"
                    ]); ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>

<?php
$cs = Yii::app()->getClientScript();
$deleteUrl = Yii::app()->createUrl('customer/deleteServiceLocationItem');

// JS to handle removing and reordering rows
$cs->registerScript("removeServiceLocationTableRow", "
function removeServiceLocationTableRow(jQtable, evt, field_id) {
    var row_field = field_id.split('_')[1];
    var num_rows = jQtable.find('tr:gt(0)').length;
    var row_id = $(evt).closest('tr').attr('class');
    var id = $('#ServiceCustomerLocation_' + row_id + '_id').val();

    if (num_rows <= 1) {
        alert('At least one location is required.');
        return;
    }

    // If row exists in DB, delete via AJAX
    if (id) {
        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: '$deleteUrl',
            data: { id: id },
            cache: false,
            success: function (data) {
                if (data.status === 'success') {
                    $(evt).closest('tr').remove();
                    reorderServiceLocationRows(jQtable);
                    // t8.success('Location Deleted!', 'success');
                    $.pnotify_remove_all();
                } else {
                    t8.error('Deletion Not Possible, History Exist', 'error');
                }
            }
        });
    } else {
        $(evt).closest('tr').remove();
        reorderServiceLocationRows(jQtable);
    }
}

// Reorder rows
function reorderServiceLocationRows(jQtable) {
    var i = 0;
    jQtable.find('tr:gt(0)').each(function () {
        $(this).find('input, select, .errorMessage').each(function () {
            var oldId = $(this).attr('id');
            if (oldId) $(this).attr('id', oldId.replace(/\\d+/, i));
            var oldName = $(this).attr('name');
            if (oldName) $(this).attr('name', oldName.replace(/\\d+/, i));
        });
        $(this).find('td:first label').html(++i);
    });
}
", CClientScript::POS_END);
?>